/*
 * Decompiled with CFR 0.152.
 */
package newBiospheresMod.Models;

import java.util.ArrayList;
import java.util.Collection;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Random;
import net.minecraft.block.Block;
import net.minecraft.util.ChunkCoordinates;
import net.minecraft.util.WeightedRandom;
import net.minecraft.world.World;
import net.minecraft.world.biome.BiomeGenBase;
import newBiospheresMod.BiosphereChunkProvider;
import newBiospheresMod.BlockDome;
import newBiospheresMod.BlockEntry;
import newBiospheresMod.Configuration.ModConfig;
import newBiospheresMod.Helpers.Blx;
import newBiospheresMod.Helpers.Creator;
import newBiospheresMod.Helpers.Func2;
import newBiospheresMod.Helpers.IKeyProvider;
import newBiospheresMod.Helpers.LruCacheList;
import newBiospheresMod.Helpers.TopDownBoundingBox;
import newBiospheresMod.Helpers.Utils;
import newBiospheresMod.Models.NoiseChunk;

public class Sphere {
    private static LruCacheList<Sphere> spheresCache = new LruCacheList<Sphere>(12, new IKeyProvider<Sphere>(){

        @Override
        public Object provideKey(Sphere item) {
            if (item == null) {
                return null;
            }
            return new CacheKey(item.chunkProvider, item.sphereLocation.field_71574_a, item.sphereLocation.field_71573_c);
        }
    });
    private final int centerChunkX;
    private final int centerChunkZ;
    private final NoiseChunk centerNoiseChunk;
    private final long seed;
    public final BiosphereChunkProvider chunkProvider;
    public final ChunkCoordinates sphereLocation;
    public final ChunkCoordinates orbLocation;
    public final ChunkCoordinates lakeLocation;
    public final boolean lavaLake;
    public final boolean hasLake;
    public final int scaledLakeEdgeRadius;
    public final int scaledOrbRadius;
    public final int scaledSphereRadius;
    public final int scaledLakeRadius;
    public final BiomeGenBase biome;
    public final double scale;
    public final boolean isNoiseEnabled;
    public final int scaledGridSize;
    public final int bridgeWidth;
    private TopDownBoundingBox orbStairwayBox;
    private Map<ChunkCoordinates, Block> orbStairwayBlx;
    private List<TopDownBoundingBox> boundingBoxes = null;
    public final int seaLevel;
    public final int sphereType;

    public static Sphere get(World world, int chunkX, int chunkZ) {
        if (world == null) {
            return null;
        }
        BiosphereChunkProvider provider = BiosphereChunkProvider.get(world);
        return Sphere.get(provider, chunkX, chunkZ);
    }

    public static Sphere get(final BiosphereChunkProvider chunkProvider, final int chunkX, final int chunkZ) {
        if (chunkProvider == null) {
            return null;
        }
        ChunkCoordinates coords = Sphere.GetSphereCenter(chunkX, chunkZ, chunkProvider.config);
        CacheKey key = new CacheKey(chunkProvider, coords.field_71574_a, coords.field_71573_c);
        return spheresCache.FindOrAdd(key, new Creator<Sphere>(){

            @Override
            public Sphere create() {
                return new Sphere(chunkProvider, chunkX, chunkZ);
            }
        });
    }

    private Sphere(BiosphereChunkProvider chunkProvider, int chunkX, int chunkZ) {
        this.chunkProvider = chunkProvider;
        ModConfig _cfg = this.chunkProvider.config;
        this.seaLevel = _cfg.getSeaLevel();
        this.scale = _cfg.getScale();
        this.isNoiseEnabled = _cfg.isNoiseEnabled();
        this.scaledGridSize = _cfg.getScaledGridSize();
        this.bridgeWidth = _cfg.getBridgeWidth();
        this.scaledOrbRadius = _cfg.getScaledOrbRadius();
        this.sphereLocation = Sphere.GetSphereCenter(chunkX, chunkZ, _cfg);
        this.centerChunkX = this.sphereLocation.field_71574_a >> 4;
        this.centerChunkZ = this.sphereLocation.field_71573_c >> 4;
        this.centerNoiseChunk = this.isNoiseEnabled ? NoiseChunk.get(chunkProvider.world, this.centerChunkX, this.centerChunkZ, this.chunkProvider.noiseGenerator, this.scale, this.seaLevel) : null;
        this.sphereLocation.field_71572_b = this.getRawSurfaceLevel(this.sphereLocation.field_71574_a, this.sphereLocation.field_71573_c);
        Random rnd = new Random(chunkProvider.worldSeed);
        long xm = rnd.nextLong() / 2L * 2L + 1L;
        long zm = rnd.nextLong() / 2L * 2L + 1L;
        long _seed = ((long)this.sphereLocation.field_71574_a * xm + (long)this.sphereLocation.field_71573_c * zm) * 2512576L ^ chunkProvider.worldSeed;
        rnd.setSeed(_seed);
        double minRad = _cfg.getMinSphereRadius() * this.scale;
        double maxRad = _cfg.getMaxSphereRadius() * this.scale;
        double radRange = maxRad - minRad;
        this.scaledSphereRadius = (int)Math.round(minRad + rnd.nextDouble() * radRange);
        double lakeRatio = _cfg.getMinLakeRatio() + (_cfg.getMaxLakeRatio() - _cfg.getMinLakeRatio()) * rnd.nextDouble();
        this.scaledLakeRadius = (int)Math.round((double)this.scaledSphereRadius * lakeRatio);
        this.scaledLakeEdgeRadius = this.scaledLakeRadius + 2;
        this.biome = this.chunkProvider.world.func_72959_q().func_76935_a(this.sphereLocation.field_71574_a, this.sphereLocation.field_71573_c);
        this.lavaLake = this.biome == BiomeGenBase.field_76778_j || this.biome != BiomeGenBase.field_76780_h && this.biome != BiomeGenBase.field_76768_g && this.biome != BiomeGenBase.field_76774_n && this.biome != BiomeGenBase.field_76779_k && rnd.nextInt(10) == 0;
        this.hasLake = this.biome == BiomeGenBase.field_76780_h || this.biome != BiomeGenBase.field_76779_k && rnd.nextInt(2) == 0;
        this.orbLocation = Utils.GetCoords(this.sphereLocation);
        int lowY = this.sphereLocation.field_71572_b - this.scaledSphereRadius;
        int highY = this.sphereLocation.field_71572_b + this.scaledSphereRadius;
        int orbRange = this.scaledGridSize * 8 - this.scaledOrbRadius;
        this.orbLocation.field_71574_a = this.sphereLocation.field_71574_a;
        this.orbLocation.field_71573_c = this.sphereLocation.field_71573_c;
        this.orbLocation.field_71572_b = this.seaLevel;
        for (int giveUpAfter = 100; !this.ValidOrbLocation() && giveUpAfter > 0; --giveUpAfter) {
            this.orbLocation.field_71574_a = this.sphereLocation.field_71574_a - orbRange + (int)Math.round(rnd.nextDouble() * (double)(orbRange * 2));
            this.orbLocation.field_71573_c = this.sphereLocation.field_71573_c - orbRange + (int)Math.round(rnd.nextDouble() * (double)(orbRange * 2));
            this.orbLocation.field_71572_b = Utils.RndBetween(rnd, lowY, highY);
        }
        if (!this.ValidOrbLocation()) {
            this.orbLocation.field_71572_b = this.seaLevel;
            this.orbLocation.field_71574_a = this.sphereLocation.field_71574_a + this.scaledGridSize * 32;
            this.orbLocation.field_71573_c = this.sphereLocation.field_71573_c + this.scaledGridSize * 32;
        }
        this.lakeLocation = Utils.GetCoords(this.sphereLocation);
        if (this.hasLake && this.isNoiseEnabled) {
            this.SetLakeHeight();
            if (rnd.nextDouble() > 0.65) {
                this.lakeLocation.field_71572_b -= (int)Math.round(rnd.nextDouble() * 2.0 * this.scale);
            }
        }
        this.SetupOrbStairway(rnd);
        xm = rnd.nextLong() / 2L * 2L + 1L;
        zm = rnd.nextLong() / 2L * 2L + 1L;
        this.seed = ((long)this.centerChunkX * xm + (long)this.centerChunkZ * zm) * 3168045L ^ this.chunkProvider.worldSeed;
        rnd = this.GetPhaseRandom("SphereType", this.centerChunkX, this.centerChunkZ);
        int sType = -1;
        if (this.AnySphereTypeValid()) {
            while (!this.SphereTypeValid(sType)) {
                sType = rnd.nextInt() % 4;
            }
        }
        this.sphereType = sType;
    }

    public Block getDomeBlock(int x, int y, int z) {
        Block ret = Blx.glass;
        if (this.SphereTypeValid(this.sphereType)) {
            Random rnd = this.GetPhaseRandom("SphereType_" + Integer.toString(x) + "_" + Integer.toString(y) + "_" + Integer.toString(z), this.centerChunkX, this.centerChunkZ);
            ModConfig cfr_ignored_0 = this.chunkProvider.config;
            ret = ((BlockEntry)WeightedRandom.func_76271_a((Random)rnd, ModConfig.DomeBlocks[this.sphereType])).Block;
        }
        return BlockDome.GetDomeBlock(ret);
    }

    public int getMainDistance(int rawX, int rawY, int rawZ) {
        return Utils.GetDistance(this.sphereLocation, rawX, rawY, rawZ);
    }

    public int getOrbDistance(int rawX, int rawY, int rawZ) {
        return Utils.GetDistance(this.orbLocation, rawX, rawY, rawZ);
    }

    public int getLakeDistance(int rawX, int rawY, int rawZ) {
        if (!this.hasLake) {
            return Integer.MAX_VALUE;
        }
        int lly = this.lakeLocation.field_71572_b;
        double dy = rawY - lly;
        if (dy < 0.0) {
            dy *= 2.0;
            if (this.isNoiseEnabled) {
                int afterNoise;
                int beforeNoise = (int)Math.round(Utils.GetDistance((double)this.lakeLocation.field_71574_a, 0.0, (double)this.lakeLocation.field_71573_c, (double)rawX, dy, (double)rawZ));
                if (rawX >= this.lakeLocation.field_71574_a - this.scaledLakeEdgeRadius && rawZ >= this.lakeLocation.field_71573_c - this.scaledLakeEdgeRadius && rawX <= this.lakeLocation.field_71574_a + this.scaledLakeEdgeRadius && rawZ <= this.lakeLocation.field_71573_c + this.scaledLakeEdgeRadius) {
                    int x = this.sphereLocation.field_71574_a + (rawX - this.sphereLocation.field_71574_a) * 20;
                    int z = this.sphereLocation.field_71573_c + (rawZ - this.sphereLocation.field_71573_c) * 20;
                    double offset = this.getRawSurfaceLevel(x, z) - this.seaLevel;
                    dy += Math.abs(offset / 4.0);
                }
                if ((afterNoise = (int)Math.round(Utils.GetDistance((double)this.lakeLocation.field_71574_a, 0.0, (double)this.lakeLocation.field_71573_c, (double)rawX, dy, (double)rawZ))) < beforeNoise) {
                    return afterNoise;
                }
                return beforeNoise;
            }
        }
        return (int)Math.round(Utils.GetDistance((double)this.lakeLocation.field_71574_a, 0.0, (double)this.lakeLocation.field_71573_c, (double)rawX, dy, (double)rawZ));
    }

    public int getRawSurfaceLevel(int rawX, int rawZ) {
        if (this.centerNoiseChunk != null) {
            return this.centerNoiseChunk.getRawSurfaceLevel(rawX, rawZ);
        }
        return this.seaLevel;
    }

    public Block GetLakeBlock() {
        if (!this.hasLake) {
            return Blx.air;
        }
        return this.lavaLake ? Blx.flowing_lava : Blx.flowing_water;
    }

    public List<TopDownBoundingBox> getBoundingBoxes() {
        if (this.boundingBoxes == null) {
            this.boundingBoxes = new ArrayList<TopDownBoundingBox>();
            this.boundingBoxes.add(TopDownBoundingBox.FromCircle(this.sphereLocation.field_71574_a, this.sphereLocation.field_71573_c, this.scaledSphereRadius + 1));
            this.boundingBoxes.add(TopDownBoundingBox.FromCircle(this.orbLocation.field_71574_a, this.orbLocation.field_71573_c, this.scaledOrbRadius + 1));
            this.boundingBoxes.add(new TopDownBoundingBox(this.sphereLocation.field_71574_a - (this.bridgeWidth + 1), Integer.MIN_VALUE, this.sphereLocation.field_71574_a + (this.bridgeWidth + 1), Integer.MAX_VALUE));
            this.boundingBoxes.add(new TopDownBoundingBox(Integer.MIN_VALUE, this.sphereLocation.field_71573_c - (this.bridgeWidth + 1), Integer.MAX_VALUE, this.sphereLocation.field_71573_c + (this.bridgeWidth + 1)));
            if (this.orbStairwayBox != null) {
                this.boundingBoxes.add(this.orbStairwayBox);
            }
        }
        return this.boundingBoxes;
    }

    public Block getOrbStairwayBlock(int x, int y, int z) {
        if (this.orbStairwayBox == null) {
            return null;
        }
        if (!this.orbStairwayBox.CollidesWith(x, z)) {
            return null;
        }
        ChunkCoordinates key = Utils.GetCoords(x, y, z);
        if (this.orbStairwayBlx.containsKey(key)) {
            return this.orbStairwayBlx.get(key);
        }
        return null;
    }

    public Random GetPhaseRandom(String phase, int chunkX, int chunkZ) {
        Random rnd = new Random(this.seed);
        long xm = rnd.nextLong() / 2L * 2L + 1L;
        long zm = rnd.nextLong() / 2L * 2L + 1L;
        long _seed = ((long)chunkX * xm + (long)chunkZ * zm) * (long)phase.hashCode() ^ this.chunkProvider.worldSeed;
        rnd.setSeed(_seed);
        return rnd;
    }

    private boolean AnySphereTypeValid() {
        for (int i = 0; i < 4; ++i) {
            if (!this.SphereTypeValid(i)) continue;
            return true;
        }
        return false;
    }

    private boolean SphereTypeValid(int typeIndex) {
        if (typeIndex < 0) {
            return false;
        }
        if (typeIndex >= 4) {
            return false;
        }
        ModConfig config = this.chunkProvider.config;
        if (ModConfig.DomeBlocks[typeIndex] != null) {
            int i = 0;
            while (true) {
                if (i >= ModConfig.DomeBlocks[typeIndex].size()) break;
                if (ModConfig.DomeBlocks[typeIndex].get((int)i).field_76292_a > 0) {
                    return true;
                }
                ++i;
            }
        }
        return false;
    }

    private static ChunkCoordinates GetSphereCenter(int chunkX, int chunkZ, ModConfig cfg) {
        if (cfg == null) {
            return null;
        }
        int chunkOffsetToCenterX = -((int)Math.floor(Math.IEEEremainder(chunkX, cfg.getScaledGridSize())));
        int chunkOffsetToCenterZ = -((int)Math.floor(Math.IEEEremainder(chunkZ, cfg.getScaledGridSize())));
        int x = ((chunkX += chunkOffsetToCenterX) << 4) + 8;
        int z = ((chunkZ += chunkOffsetToCenterZ) << 4) + 8;
        int y = cfg.getSeaLevel();
        return Utils.GetCoords(x, y, z);
    }

    private boolean ValidOrbLocation() {
        if (this.orbLocation.field_71572_b < 0 + this.scaledOrbRadius) {
            return false;
        }
        if (this.orbLocation.field_71572_b > 255 - this.scaledOrbRadius) {
            return false;
        }
        int groundLevel = this.getRawSurfaceLevel(this.orbLocation.field_71574_a, this.orbLocation.field_71573_c);
        if (Math.abs(groundLevel - this.orbLocation.field_71572_b) <= this.scaledOrbRadius + 2) {
            return false;
        }
        TopDownBoundingBox sphereBox = TopDownBoundingBox.FromCircle(this.sphereLocation.field_71574_a, this.sphereLocation.field_71573_c, this.scaledSphereRadius + 1);
        TopDownBoundingBox orbBox = TopDownBoundingBox.FromCircle(this.orbLocation.field_71574_a, this.orbLocation.field_71573_c, this.scaledOrbRadius + 1);
        return !orbBox.CollidesWith(sphereBox);
    }

    private void SetLakeHeight() {
        if (this.centerNoiseChunk == null) {
            this.lakeLocation.field_71572_b = this.seaLevel;
        } else {
            int z = this.lakeLocation.field_71573_c - this.scaledLakeRadius;
            boolean first = true;
            double min = 0.0;
            for (int x = this.lakeLocation.field_71574_a - this.scaledLakeRadius; x <= this.lakeLocation.field_71574_a + this.scaledLakeRadius; x += 16) {
                while (z <= this.lakeLocation.field_71573_c + this.scaledLakeRadius) {
                    double val = this.centerNoiseChunk.GetChunkAt((int)x, (int)z).minNoise;
                    if (first || val < min) {
                        min = val;
                        first = false;
                    }
                    z += 16;
                }
            }
            this.lakeLocation.field_71572_b = (int)Math.round((double)this.seaLevel + min * 8.0 * this.scale);
        }
    }

    private void SetupOrbStairway(final Random rnd) {
        int tox;
        if (this.chunkProvider.config.doesNeedProtectionGlass()) {
            return;
        }
        final List<BlockEntry> stairwayBlocks = this.chunkProvider.config.StairwayBlocks;
        boolean foundBlock = false;
        for (BlockEntry be : stairwayBlocks) {
            if (be.field_76292_a <= 0) continue;
            foundBlock = true;
            break;
        }
        if (!foundBlock) {
            return;
        }
        int orbDistX = this.orbLocation.field_71574_a - this.sphereLocation.field_71574_a;
        int orbDistZ = this.orbLocation.field_71573_c - this.sphereLocation.field_71573_c;
        if (Math.abs(orbDistX) < Math.abs(orbDistZ)) {
            orbDistZ = 0;
        } else if (Math.abs(orbDistX) > Math.abs(orbDistZ)) {
            orbDistX = 0;
        } else if (rnd.nextBoolean()) {
            orbDistX = 0;
        } else {
            orbDistZ = 0;
        }
        int ix = this.orbLocation.field_71574_a - orbDistX;
        int iz = this.orbLocation.field_71573_c - orbDistZ;
        int iy = this.getRawSurfaceLevel(ix, iz);
        int n = orbDistX == 0 ? 0 : (tox = orbDistX > 0 ? 1 : -1);
        final int toz = orbDistZ == 0 ? 0 : (orbDistZ > 0 ? 1 : -1);
        this.orbStairwayBlx = new HashMap<ChunkCoordinates, Block>();
        if (orbDistZ == 0) {
            Utils.DoLine(this.orbLocation.field_71574_a, this.orbLocation.field_71572_b, ix, iy, new Func2<Integer, Integer, Boolean>(){

                @Override
                public Boolean func(Integer x, Integer y) {
                    for (int z = Sphere.this.orbLocation.field_71573_c - Sphere.this.bridgeWidth; z <= Sphere.this.orbLocation.field_71573_c + Sphere.this.bridgeWidth; ++z) {
                        Block block = ((BlockEntry)WeightedRandom.func_76271_a((Random)rnd, (Collection)stairwayBlocks)).Block;
                        if (block != Blx.air) {
                            Sphere.this.orbStairwayBlx.put(Utils.GetCoords(x, y, z), block);
                        }
                        if ((block = ((BlockEntry)WeightedRandom.func_76271_a((Random)rnd, (Collection)stairwayBlocks)).Block) == Blx.air) continue;
                        Sphere.this.orbStairwayBlx.put(Utils.GetCoords(x + tox, y, z + toz), block);
                    }
                    return true;
                }
            });
        } else {
            Utils.DoLine(this.orbLocation.field_71573_c, this.orbLocation.field_71572_b, iz, iy, new Func2<Integer, Integer, Boolean>(){

                @Override
                public Boolean func(Integer z, Integer y) {
                    for (int x = Sphere.this.orbLocation.field_71574_a - Sphere.this.bridgeWidth; x <= Sphere.this.orbLocation.field_71574_a + Sphere.this.bridgeWidth; ++x) {
                        Block block = ((BlockEntry)WeightedRandom.func_76271_a((Random)rnd, (Collection)stairwayBlocks)).Block;
                        if (block != Blx.air) {
                            Sphere.this.orbStairwayBlx.put(Utils.GetCoords(x, y, z), block);
                        }
                        if ((block = ((BlockEntry)WeightedRandom.func_76271_a((Random)rnd, (Collection)stairwayBlocks)).Block) == Blx.air) continue;
                        Sphere.this.orbStairwayBlx.put(Utils.GetCoords(x + tox, y, z + toz), block);
                    }
                    return true;
                }
            });
        }
        this.orbStairwayBox = TopDownBoundingBox.FromArray(this.orbStairwayBlx.keySet());
    }

    private static class CacheKey {
        public final int x;
        public final int z;
        public final BiosphereChunkProvider chunkProvider;

        public CacheKey(BiosphereChunkProvider chunkProvider, int x, int z) {
            this.chunkProvider = chunkProvider;
            this.x = x;
            this.z = z;
        }

        public boolean equals(Object obj) {
            if (obj == null) {
                return false;
            }
            if (this == obj) {
                return true;
            }
            if (!(obj instanceof CacheKey)) {
                return false;
            }
            CacheKey other = (CacheKey)obj;
            return this.x == other.x && this.z == other.z && this.chunkProvider == other.chunkProvider;
        }

        public int hashCode() {
            int chunkProviderHash = this.chunkProvider == null ? 0 : this.chunkProvider.hashCode();
            return (this.x & 0xFFFF | (this.z & 0xFFFF) << 16) ^ chunkProviderHash ^ 0x1A1D5198;
        }
    }
}

