/*
 * Decompiled with CFR 0.152.
 */
package newBiospheresMod.Models;

import java.util.Random;
import newBiospheresMod.BiosphereChunkProvider;
import newBiospheresMod.Configuration.ModConfig;
import newBiospheresMod.Helpers.Creator;
import newBiospheresMod.Helpers.IKeyProvider;
import newBiospheresMod.Helpers.LruCacheList;
import newBiospheresMod.Models.NoiseChunk;
import newBiospheresMod.Models.Sphere;

public class SphereChunk {
    private static LruCacheList<SphereChunk> sphereChunksCache = new LruCacheList<SphereChunk>(15, new IKeyProvider<SphereChunk>(){

        @Override
        public Object provideKey(SphereChunk item) {
            if (item == null) {
                return null;
            }
            return new CacheKey(item.chunkProvider, item.chunkX, item.chunkZ);
        }
    });
    public final int chunkX;
    public final int chunkZ;
    public final BiosphereChunkProvider chunkProvider;
    public final Sphere masterSphere;
    public final boolean isNoiseEnabled;
    public final NoiseChunk noise;

    public static SphereChunk get(final BiosphereChunkProvider chunkProvider, final int chunkX, final int chunkZ) {
        return sphereChunksCache.FindOrAdd(new CacheKey(chunkProvider, chunkX, chunkZ), new Creator<SphereChunk>(){

            @Override
            public SphereChunk create() {
                return new SphereChunk(chunkProvider, chunkX, chunkZ);
            }
        });
    }

    public SphereChunk(BiosphereChunkProvider chunkProvider, int chunkX, int chunkZ) {
        this.chunkProvider = chunkProvider;
        this.chunkX = chunkX;
        this.chunkZ = chunkZ;
        ModConfig cfg = this.chunkProvider.config;
        this.isNoiseEnabled = cfg.isNoiseEnabled();
        this.noise = this.isNoiseEnabled ? NoiseChunk.get(this.chunkProvider.world, chunkX, chunkZ, this.chunkProvider.noiseGenerator, cfg.getScale(), cfg.getSeaLevel()) : null;
        this.masterSphere = Sphere.get(chunkProvider, chunkX, chunkZ);
    }

    public Random GetPhaseRandom(String phase) {
        return this.masterSphere.GetPhaseRandom(phase, this.chunkX, this.chunkZ);
    }

    public int getChunkBoundSurfaceLevel(int boundX, int boundZ) {
        if (this.noise != null) {
            return this.noise.getChunkBoundSurfaceLevel(boundX, boundZ);
        }
        return this.chunkProvider.config.getSeaLevel();
    }

    private static class CacheKey {
        public final int x;
        public final int z;
        public final BiosphereChunkProvider chunkProvider;

        public CacheKey(BiosphereChunkProvider chunkProvider, int x, int z) {
            this.chunkProvider = chunkProvider;
            this.x = x;
            this.z = z;
        }

        public boolean equals(Object obj) {
            if (obj == null) {
                return false;
            }
            if (this == obj) {
                return true;
            }
            if (!(obj instanceof CacheKey)) {
                return false;
            }
            CacheKey other = (CacheKey)obj;
            return this.x == other.x && this.z == other.z && this.chunkProvider == other.chunkProvider;
        }

        public int hashCode() {
            int chunkProviderHash = this.chunkProvider == null ? 0 : this.chunkProvider.hashCode();
            return (this.x & 0xFFFF | (this.z & 0xFFFF) << 16) ^ chunkProviderHash ^ 0x70AC05AD;
        }
    }
}

