/*
 * Decompiled with CFR 0.152.
 */
package com.bluepowermod.client.gui.gate;

import com.bluepowermod.BluePower;
import com.bluepowermod.client.gui.GuiScreenBase;
import com.bluepowermod.network.BPNetworkHandler;
import com.bluepowermod.network.message.MessageGuiUpdate;
import com.bluepowermod.part.gate.GateBase;
import cpw.mods.fml.common.network.simpleimpl.IMessage;
import cpw.mods.fml.relauncher.Side;
import cpw.mods.fml.relauncher.SideOnly;
import java.util.ArrayList;
import java.util.List;
import net.minecraft.client.Minecraft;
import net.minecraft.client.resources.I18n;
import net.minecraft.util.ResourceLocation;
import org.apache.commons.lang3.text.WordUtils;
import uk.co.qmunity.lib.client.gui.widget.BaseWidget;
import uk.co.qmunity.lib.client.gui.widget.IGuiWidget;
import uk.co.qmunity.lib.client.gui.widget.IWidgetListener;

@SideOnly(value=Side.CLIENT)
public class GuiGate
extends GuiScreenBase
implements IWidgetListener {
    private final GateBase<?, ?, ?, ?, ?, ?> gate;
    private final List<IGuiWidget> widgets = new ArrayList<IGuiWidget>();

    public GuiGate(GateBase<?, ?, ?, ?, ?, ?> gate, int xSize, int ySize) {
        super(xSize, ySize);
        this.gate = gate;
    }

    public GateBase<?, ?, ?, ?, ?, ?> getGate() {
        return this.gate;
    }

    protected void sendToServer(int id, int value) {
        BPNetworkHandler.INSTANCE.sendToServer((IMessage)new MessageGuiUpdate(this.gate, id, value));
    }

    public boolean func_73868_f() {
        return false;
    }

    public void actionPerformed(IGuiWidget widget) {
    }

    protected void addWidget(IGuiWidget widget) {
        this.widgets.add(widget);
        widget.setListener((IWidgetListener)this);
    }

    public void func_146280_a(Minecraft par1Minecraft, int par2, int par3) {
        this.widgets.clear();
        super.func_146280_a(par1Minecraft, par2, par3);
    }

    public void redraw() {
        this.field_146292_n.clear();
        this.widgets.clear();
        this.func_73866_w_();
    }

    @Override
    public final void func_73863_a(int x, int y, float partialTick) {
        super.func_73863_a(x, y, partialTick);
        for (IGuiWidget widget : this.widgets) {
            widget.render(x, y, partialTick);
        }
        this.renderGUI(x, y, partialTick);
        ArrayList tooltip = new ArrayList();
        boolean shift = BluePower.proxy.isSneakingInGui();
        for (IGuiWidget widget : this.widgets) {
            if (!widget.getBounds().contains(x, y)) continue;
            widget.addTooltip(x, y, tooltip, shift);
        }
        if (!tooltip.isEmpty()) {
            ArrayList<String> localizedTooltip = new ArrayList<String>();
            for (String line : tooltip) {
                String[] lines;
                String localizedLine = I18n.func_135052_a((String)line, (Object[])new Object[0]);
                for (String locLine : lines = WordUtils.wrap((String)localizedLine, (int)50).split(System.getProperty("line.separator"))) {
                    localizedTooltip.add(locLine);
                }
            }
            this.drawHoveringText(localizedTooltip, x, y, this.field_146289_q);
        }
    }

    protected void renderGUI(int x, int y, float partialTick) {
    }

    protected void func_73864_a(int x, int y, int button) {
        super.func_73864_a(x, y, button);
        for (IGuiWidget widget : this.widgets) {
            if (!widget.getBounds().contains(x, y) || widget instanceof BaseWidget && !((BaseWidget)widget).enabled) continue;
            widget.onMouseClicked(x, y, button);
        }
    }

    @Override
    protected ResourceLocation getTexture() {
        return null;
    }
}

