/*
 * Decompiled with CFR 0.152.
 */
package com.bluepowermod.client.gui.gate;

import com.bluepowermod.client.gui.gate.GuiGate;
import com.bluepowermod.part.gate.GateBase;
import cpw.mods.fml.relauncher.Side;
import cpw.mods.fml.relauncher.SideOnly;
import net.minecraft.client.gui.GuiButton;
import net.minecraft.client.resources.I18n;
import net.minecraft.util.ResourceLocation;

@SideOnly(value=Side.CLIENT)
public abstract class GuiGateSingleCounter
extends GuiGate {
    private static final ResourceLocation resLoc = new ResourceLocation("bluepower", "textures/gui/gate.png");
    private static final String[] buttonTexts = new String[]{"-10s", "-1s", "-50ms", "+50ms", "+1s", "+10s"};
    private static final int[] buttonActions = new int[]{-200, -20, -1, 1, 20, 200};

    public GuiGateSingleCounter(GateBase<?, ?, ?, ?, ?, ?> gate) {
        super(gate, 228, 66);
    }

    @Override
    public void func_73866_w_() {
        String[] text = this.getButtonText();
        super.func_73866_w_();
        int buttonWidth = 35;
        for (int i = 0; i < text.length; ++i) {
            this.field_146292_n.add(new GuiButton(i, this.guiLeft + 4 + i * (buttonWidth + 2), this.guiTop + 35, buttonWidth, 20, text[i]));
        }
    }

    public void func_146284_a(GuiButton button) {
        int newTimerValue = this.getCurrentAmount() + this.getButtonActions()[button.field_146127_k];
        if (newTimerValue < this.getMinValue()) {
            newTimerValue = this.getMinValue();
        }
        if (newTimerValue > this.getMaxValue()) {
            newTimerValue = this.getMaxValue();
        }
        this.sendToServer(0, newTimerValue);
    }

    @Override
    protected ResourceLocation getTexture() {
        return resLoc;
    }

    @Override
    public void renderGUI(int x, int y, float partialTicks) {
        this.func_73732_a(this.field_146289_q, I18n.func_135052_a((String)this.getTitle(), (Object[])new Object[0]) + ": " + this.getDisplayedString(), this.guiLeft + this.xSize / 2, this.guiTop + 10, 0xFFFFFF);
    }

    protected String getDisplayedString() {
        int time = this.getCurrentAmount() * 50;
        if (time >= 1000) {
            String ms = "" + time % 1000;
            if (ms.length() > 1) {
                while (ms.length() < 3) {
                    ms = "0" + ms;
                }
            }
            return time / 1000 + "." + ms + "s";
        }
        return time + "ms";
    }

    protected abstract int getCurrentAmount();

    protected String[] getButtonText() {
        return buttonTexts;
    }

    protected int[] getButtonActions() {
        return buttonActions;
    }

    protected String getTitle() {
        return "gui.bluepower:timer.interval";
    }

    protected int getMinValue() {
        return 2;
    }

    protected int getMaxValue() {
        return Integer.MAX_VALUE;
    }
}

