/*
 * Decompiled with CFR 0.152.
 */
package com.bluepowermod.client.render;

import com.bluepowermod.client.render.IconSupplier;
import cpw.mods.fml.relauncher.Side;
import cpw.mods.fml.relauncher.SideOnly;
import java.nio.DoubleBuffer;
import net.minecraft.client.Minecraft;
import net.minecraft.client.renderer.RenderBlocks;
import net.minecraft.client.renderer.Tessellator;
import net.minecraft.client.renderer.texture.TextureMap;
import net.minecraft.init.Blocks;
import net.minecraft.util.ResourceLocation;
import net.minecraftforge.common.util.ForgeDirection;
import org.lwjgl.BufferUtils;
import org.lwjgl.opengl.GL11;
import uk.co.qmunity.lib.client.render.RenderUtils;
import uk.co.qmunity.lib.vec.Vec3dCube;

@SideOnly(value=Side.CLIENT)
public class RenderHelper {
    private static RenderBlocks rb = new RenderBlocks();

    public static void addVertex(double x, double y, double z) {
        GL11.glVertex3d((double)x, (double)y, (double)z);
    }

    public static void addVertexWithTexture(double x, double y, double z, double tx, double ty) {
        GL11.glTexCoord2d((double)tx, (double)ty);
        GL11.glVertex3d((double)x, (double)y, (double)z);
    }

    public static void renderDigitalRedstoneTorch(double x, double y, double z, double height, boolean state) {
        RenderHelper.renderRedstoneTorch(x, y, z, height, state, true);
    }

    public static void renderAnalogRedstoneTorch(double x, double y, double z, double height, boolean state) {
        RenderHelper.renderRedstoneTorch(x, y, z, height, state, false);
    }

    public static void renderRedstoneTorch(double x, double y, double z, double height, boolean state, boolean digital) {
        GL11.glPushMatrix();
        Minecraft.func_71410_x().field_71446_o.func_110577_a(TextureMap.field_110575_b);
        RenderHelper.rb.field_147840_d = digital ? (state ? IconSupplier.bluestoneTorchOn : IconSupplier.bluestoneTorchOff) : (state ? Blocks.field_150429_aA.func_149691_a(0, 0) : Blocks.field_150437_az.func_149691_a(0, 0));
        GL11.glEnable((int)12288);
        GL11.glClipPlane((int)12288, (DoubleBuffer)RenderUtils.planeEquation((double)0.0, (double)1.0, (double)0.0));
        GL11.glTranslated((double)x, (double)(y + height - 1.0), (double)z);
        Tessellator t = Tessellator.field_78398_a;
        t.func_78386_a(1.0f, 1.0f, 1.0f);
        t.func_78382_b();
        rb.func_147782_a(0.4375, 0.0, 0.0, 0.5625, 1.0, 1.0);
        t.func_78375_b(-1.0f, 1.0f, 0.0f);
        rb.func_147798_e(Blocks.field_150348_b, 0.0, 0.0, 0.0, null);
        t.func_78375_b(1.0f, 1.0f, 0.0f);
        rb.func_147764_f(Blocks.field_150348_b, 0.0, 0.0, 0.0, null);
        rb.func_147782_a(0.0, 0.0, 0.4375, 1.0, 1.0, 0.5625);
        t.func_78375_b(0.0f, 1.0f, -1.0f);
        rb.func_147761_c(Blocks.field_150348_b, 0.0, 0.0, 0.0, null);
        t.func_78375_b(0.0f, 1.0f, 1.0f);
        rb.func_147734_d(Blocks.field_150348_b, 0.0, 0.0, 0.0, null);
        rb.func_147782_a(0.4375, 0.0, 0.375, 0.5625, 0.625, 0.5);
        t.func_78375_b(0.0f, 1.0f, 0.0f);
        rb.func_147806_b(Blocks.field_150348_b, 0.0, 0.0, 0.0625, null);
        t.func_78381_a();
        GL11.glDisable((int)12288);
        RenderHelper.rb.field_147840_d = null;
        GL11.glPopMatrix();
    }

    public static void renderRandomizerButton(double x, double y, double z, boolean tainted) {
        String res = "bluepower:textures/blocks/gates/components/" + (tainted ? "tainted_" : "") + "silicon_chip_on.png";
        String resSide = "bluepower:textures/blocks/gates/randomizer/button_side.png";
        RenderHelper.renderButton(x, y, z, res, resSide);
    }

    public static void renderQuartzResonator(double x, double y, double z) {
        String res = "bluepower:textures/blocks/gates/components/resonator.png";
        String resSide = "bluepower:textures/blocks/gates/randomizer/button_side.png";
        RenderHelper.renderButton(x, y, z, res, resSide);
    }

    public static void renderButton(double x, double y, double z, String res, String resSide) {
        GL11.glPushMatrix();
        GL11.glTranslated((double)x, (double)y, (double)z);
        GL11.glPushMatrix();
        GL11.glTranslated((double)0.375, (double)0.125, (double)0.5);
        Minecraft.func_71410_x().field_71446_o.func_110577_a(new ResourceLocation(resSide));
        for (int i = 0; i < 4; ++i) {
            GL11.glTranslated((double)0.125, (double)0.0, (double)0.125);
            GL11.glRotated((double)90.0, (double)0.0, (double)1.0, (double)0.0);
            GL11.glTranslated((double)-0.125, (double)0.0, (double)-0.125);
            GL11.glBegin((int)7);
            GL11.glNormal3d((double)1.0, (double)0.0, (double)0.0);
            RenderHelper.addVertexWithTexture(0.0, 0.0, 0.0, 0.0, 0.0);
            RenderHelper.addVertexWithTexture(0.0, 0.0625, 0.0, 0.0, 1.0);
            RenderHelper.addVertexWithTexture(0.25, 0.0625, 0.0, 1.0, 1.0);
            RenderHelper.addVertexWithTexture(0.25, 0.0, 0.0, 1.0, 0.0);
            GL11.glEnd();
        }
        GL11.glPopMatrix();
        GL11.glTranslated((double)0.0, (double)0.0625, (double)0.0);
        Minecraft.func_71410_x().field_71446_o.func_110577_a(new ResourceLocation(res));
        Tessellator t = Tessellator.field_78398_a;
        y = 0.125;
        t.func_78382_b();
        t.func_78375_b(0.0f, 1.0f, 0.0f);
        t.func_78374_a(0.0, y, 0.0, 1.0, 1.0);
        t.func_78374_a(0.0, y, 1.0, 1.0, 0.0);
        t.func_78374_a(1.0, y, 1.0, 0.0, 0.0);
        t.func_78374_a(1.0, y, 0.0, 0.0, 1.0);
        t.func_78381_a();
        GL11.glPopMatrix();
    }

    public static void renderPointer(double x, double y, double z, double angle) {
        GL11.glPushMatrix();
        GL11.glTranslated((double)x, (double)y, (double)z);
        GL11.glTranslated((double)0.5, (double)0.5, (double)0.5);
        GL11.glRotated((double)(180.0 + 360.0 * -angle), (double)0.0, (double)1.0, (double)0.0);
        GL11.glTranslated((double)-0.5, (double)-0.5, (double)-0.5);
        Minecraft.func_71410_x().field_71446_o.func_110577_a(new ResourceLocation("minecraft:textures/blocks/stone.png"));
        GL11.glBegin((int)7);
        GL11.glNormal3d((double)0.0, (double)-1.0, (double)0.0);
        RenderHelper.addVertexWithTexture(0.5, 0.0, 0.125, 0.5, 0.0625);
        RenderHelper.addVertexWithTexture(0.625, 0.0, 0.5, 0.625, 0.5);
        RenderHelper.addVertexWithTexture(0.5, 0.0, 0.625, 0.5, 0.625);
        RenderHelper.addVertexWithTexture(0.375, 0.0, 0.5, 0.375, 0.5);
        GL11.glNormal3d((double)0.0, (double)1.0, (double)0.0);
        RenderHelper.addVertexWithTexture(0.5, 0.0625, 0.125, 0.5, 0.0625);
        RenderHelper.addVertexWithTexture(0.375, 0.0625, 0.5, 0.375, 0.5);
        RenderHelper.addVertexWithTexture(0.5, 0.0625, 0.625, 0.5, 0.625);
        RenderHelper.addVertexWithTexture(0.625, 0.0625, 0.5, 0.625, 0.5);
        GL11.glNormal3d((double)1.0, (double)0.0, (double)0.0);
        RenderHelper.addVertexWithTexture(0.5, 0.0625, 0.125, 0.5, 0.0625);
        RenderHelper.addVertexWithTexture(0.5, 0.0, 0.125, 0.5, 0.0625);
        RenderHelper.addVertexWithTexture(0.375, 0.0, 0.5, 0.375, 0.5);
        RenderHelper.addVertexWithTexture(0.375, 0.0625, 0.5, 0.375, 0.5);
        RenderHelper.addVertexWithTexture(0.375, 0.0625, 0.5, 0.375, 0.5);
        RenderHelper.addVertexWithTexture(0.375, 0.0, 0.5, 0.375, 0.5);
        RenderHelper.addVertexWithTexture(0.5, 0.0, 0.625, 0.5, 0.625);
        RenderHelper.addVertexWithTexture(0.5, 0.0625, 0.625, 0.5, 0.625);
        GL11.glNormal3d((double)-1.0, (double)0.0, (double)0.0);
        RenderHelper.addVertexWithTexture(0.5, 0.0625, 0.625, 0.5, 0.625);
        RenderHelper.addVertexWithTexture(0.5, 0.0, 0.625, 0.5, 0.625);
        RenderHelper.addVertexWithTexture(0.625, 0.0, 0.5, 0.625, 0.5);
        RenderHelper.addVertexWithTexture(0.625, 0.0625, 0.5, 0.625, 0.5);
        RenderHelper.addVertexWithTexture(0.625, 0.0625, 0.5, 0.625, 0.5);
        RenderHelper.addVertexWithTexture(0.625, 0.0, 0.5, 0.625, 0.5);
        RenderHelper.addVertexWithTexture(0.5, 0.0, 0.125, 0.5, 0.0625);
        RenderHelper.addVertexWithTexture(0.5, 0.0625, 0.125, 0.5, 0.0625);
        GL11.glEnd();
        GL11.glPopMatrix();
    }

    public static DoubleBuffer planeEquation(double x1, double y1, double z1, double x2, double y2, double z2, double x3, double y3, double z3) {
        double[] eq = new double[]{y1 * (z2 - z3) + y2 * (z3 - z1) + y3 * (z1 - z2), z1 * (x2 - x3) + z2 * (x3 - x1) + z3 * (x1 - x2), x1 * (y2 - y3) + x2 * (y3 - y1) + x3 * (y1 - y2), -(x1 * (y2 * z3 - y3 * z2) + x2 * (y3 * z1 - y1 * z3) + x3 * (y1 * z2 - y2 * z1))};
        DoubleBuffer b = BufferUtils.createDoubleBuffer((int)8).put(eq);
        b.flip();
        return b;
    }

    public static void drawColoredCube(Vec3dCube vector) {
        GL11.glColor3f((float)1.0f, (float)0.0f, (float)0.0f);
        GL11.glNormal3d((double)0.0, (double)1.0, (double)0.0);
        RenderHelper.addVertex(vector.getMinX(), vector.getMaxY(), vector.getMaxZ());
        RenderHelper.addVertex(vector.getMaxX(), vector.getMaxY(), vector.getMaxZ());
        RenderHelper.addVertex(vector.getMaxX(), vector.getMaxY(), vector.getMinZ());
        RenderHelper.addVertex(vector.getMinX(), vector.getMaxY(), vector.getMinZ());
        GL11.glColor3f((float)1.0f, (float)1.0f, (float)0.0f);
        GL11.glNormal3d((double)0.0, (double)-1.0, (double)0.0);
        RenderHelper.addVertex(vector.getMaxX(), vector.getMinY(), vector.getMaxZ());
        RenderHelper.addVertex(vector.getMinX(), vector.getMinY(), vector.getMaxZ());
        RenderHelper.addVertex(vector.getMinX(), vector.getMinY(), vector.getMinZ());
        RenderHelper.addVertex(vector.getMaxX(), vector.getMinY(), vector.getMinZ());
        GL11.glColor3f((float)0.0f, (float)1.0f, (float)0.0f);
        GL11.glNormal3d((double)-1.0, (double)0.0, (double)0.0);
        RenderHelper.addVertex(vector.getMinX(), vector.getMinY(), vector.getMaxZ());
        RenderHelper.addVertex(vector.getMinX(), vector.getMaxY(), vector.getMaxZ());
        RenderHelper.addVertex(vector.getMinX(), vector.getMaxY(), vector.getMinZ());
        RenderHelper.addVertex(vector.getMinX(), vector.getMinY(), vector.getMinZ());
        GL11.glColor3f((float)0.0f, (float)1.0f, (float)1.0f);
        GL11.glNormal3d((double)1.0, (double)0.0, (double)0.0);
        RenderHelper.addVertex(vector.getMaxX(), vector.getMinY(), vector.getMinZ());
        RenderHelper.addVertex(vector.getMaxX(), vector.getMaxY(), vector.getMinZ());
        RenderHelper.addVertex(vector.getMaxX(), vector.getMaxY(), vector.getMaxZ());
        RenderHelper.addVertex(vector.getMaxX(), vector.getMinY(), vector.getMaxZ());
        GL11.glColor3f((float)0.0f, (float)0.0f, (float)1.0f);
        GL11.glNormal3d((double)0.0, (double)0.0, (double)-1.0);
        RenderHelper.addVertex(vector.getMinX(), vector.getMinY(), vector.getMinZ());
        RenderHelper.addVertex(vector.getMinX(), vector.getMaxY(), vector.getMinZ());
        RenderHelper.addVertex(vector.getMaxX(), vector.getMaxY(), vector.getMinZ());
        RenderHelper.addVertex(vector.getMaxX(), vector.getMinY(), vector.getMinZ());
        GL11.glColor3f((float)0.0f, (float)0.0f, (float)0.0f);
        GL11.glNormal3d((double)0.0, (double)0.0, (double)1.0);
        RenderHelper.addVertex(vector.getMinX(), vector.getMinY(), vector.getMaxZ());
        RenderHelper.addVertex(vector.getMaxX(), vector.getMinY(), vector.getMaxZ());
        RenderHelper.addVertex(vector.getMaxX(), vector.getMaxY(), vector.getMaxZ());
        RenderHelper.addVertex(vector.getMinX(), vector.getMaxY(), vector.getMaxZ());
    }

    public static void drawColoredCube(Vec3dCube vector, double r, double g, double b, double a, boolean ... renderFaces) {
        GL11.glColor4d((double)r, (double)g, (double)b, (double)a);
        if (renderFaces.length < 1 || renderFaces[0]) {
            GL11.glNormal3d((double)0.0, (double)1.0, (double)0.0);
            RenderHelper.addVertex(vector.getMinX(), vector.getMaxY(), vector.getMaxZ());
            RenderHelper.addVertex(vector.getMaxX(), vector.getMaxY(), vector.getMaxZ());
            RenderHelper.addVertex(vector.getMaxX(), vector.getMaxY(), vector.getMinZ());
            RenderHelper.addVertex(vector.getMinX(), vector.getMaxY(), vector.getMinZ());
        }
        if (renderFaces.length < 2 || renderFaces[1]) {
            GL11.glNormal3d((double)0.0, (double)-1.0, (double)0.0);
            RenderHelper.addVertex(vector.getMaxX(), vector.getMinY(), vector.getMaxZ());
            RenderHelper.addVertex(vector.getMinX(), vector.getMinY(), vector.getMaxZ());
            RenderHelper.addVertex(vector.getMinX(), vector.getMinY(), vector.getMinZ());
            RenderHelper.addVertex(vector.getMaxX(), vector.getMinY(), vector.getMinZ());
        }
        if (renderFaces.length < 3 || renderFaces[2]) {
            GL11.glNormal3d((double)-1.0, (double)0.0, (double)0.0);
            RenderHelper.addVertex(vector.getMinX(), vector.getMinY(), vector.getMaxZ());
            RenderHelper.addVertex(vector.getMinX(), vector.getMaxY(), vector.getMaxZ());
            RenderHelper.addVertex(vector.getMinX(), vector.getMaxY(), vector.getMinZ());
            RenderHelper.addVertex(vector.getMinX(), vector.getMinY(), vector.getMinZ());
        }
        if (renderFaces.length < 4 || renderFaces[3]) {
            GL11.glNormal3d((double)1.0, (double)0.0, (double)0.0);
            RenderHelper.addVertex(vector.getMaxX(), vector.getMinY(), vector.getMinZ());
            RenderHelper.addVertex(vector.getMaxX(), vector.getMaxY(), vector.getMinZ());
            RenderHelper.addVertex(vector.getMaxX(), vector.getMaxY(), vector.getMaxZ());
            RenderHelper.addVertex(vector.getMaxX(), vector.getMinY(), vector.getMaxZ());
        }
        if (renderFaces.length < 5 || renderFaces[4]) {
            GL11.glNormal3d((double)0.0, (double)0.0, (double)-1.0);
            RenderHelper.addVertex(vector.getMinX(), vector.getMinY(), vector.getMinZ());
            RenderHelper.addVertex(vector.getMinX(), vector.getMaxY(), vector.getMinZ());
            RenderHelper.addVertex(vector.getMaxX(), vector.getMaxY(), vector.getMinZ());
            RenderHelper.addVertex(vector.getMaxX(), vector.getMinY(), vector.getMinZ());
        }
        if (renderFaces.length < 6 || renderFaces[5]) {
            GL11.glNormal3d((double)0.0, (double)0.0, (double)1.0);
            RenderHelper.addVertex(vector.getMinX(), vector.getMinY(), vector.getMaxZ());
            RenderHelper.addVertex(vector.getMaxX(), vector.getMinY(), vector.getMaxZ());
            RenderHelper.addVertex(vector.getMaxX(), vector.getMaxY(), vector.getMaxZ());
            RenderHelper.addVertex(vector.getMinX(), vector.getMaxY(), vector.getMaxZ());
        }
        GL11.glColor4d((double)1.0, (double)1.0, (double)1.0, (double)1.0);
    }

    public static void drawTesselatedColoredCube(Vec3dCube vector, int r, int g, int b, int a) {
        Tessellator t = Tessellator.field_78398_a;
        boolean wasTesselating = false;
        try {
            t.func_78382_b();
        }
        catch (IllegalStateException e) {
            wasTesselating = true;
        }
        t.func_78370_a(r, g, b, a);
        t.func_78375_b(0.0f, 1.0f, 0.0f);
        t.func_78377_a(vector.getMinX(), vector.getMaxY(), vector.getMaxZ());
        t.func_78377_a(vector.getMaxX(), vector.getMaxY(), vector.getMaxZ());
        t.func_78377_a(vector.getMaxX(), vector.getMaxY(), vector.getMinZ());
        t.func_78377_a(vector.getMinX(), vector.getMaxY(), vector.getMinZ());
        t.func_78375_b(0.0f, -1.0f, 0.0f);
        t.func_78377_a(vector.getMaxX(), vector.getMinY(), vector.getMaxZ());
        t.func_78377_a(vector.getMinX(), vector.getMinY(), vector.getMaxZ());
        t.func_78377_a(vector.getMinX(), vector.getMinY(), vector.getMinZ());
        t.func_78377_a(vector.getMaxX(), vector.getMinY(), vector.getMinZ());
        t.func_78375_b(-1.0f, 0.0f, 0.0f);
        t.func_78377_a(vector.getMinX(), vector.getMinY(), vector.getMaxZ());
        t.func_78377_a(vector.getMinX(), vector.getMaxY(), vector.getMaxZ());
        t.func_78377_a(vector.getMinX(), vector.getMaxY(), vector.getMinZ());
        t.func_78377_a(vector.getMinX(), vector.getMinY(), vector.getMinZ());
        t.func_78375_b(1.0f, 0.0f, 0.0f);
        t.func_78377_a(vector.getMaxX(), vector.getMinY(), vector.getMinZ());
        t.func_78377_a(vector.getMaxX(), vector.getMaxY(), vector.getMinZ());
        t.func_78377_a(vector.getMaxX(), vector.getMaxY(), vector.getMaxZ());
        t.func_78377_a(vector.getMaxX(), vector.getMinY(), vector.getMaxZ());
        t.func_78375_b(0.0f, 0.0f, -1.0f);
        t.func_78377_a(vector.getMinX(), vector.getMinY(), vector.getMinZ());
        t.func_78377_a(vector.getMinX(), vector.getMaxY(), vector.getMinZ());
        t.func_78377_a(vector.getMaxX(), vector.getMaxY(), vector.getMinZ());
        t.func_78377_a(vector.getMaxX(), vector.getMinY(), vector.getMinZ());
        t.func_78375_b(0.0f, 0.0f, 1.0f);
        t.func_78377_a(vector.getMinX(), vector.getMinY(), vector.getMaxZ());
        t.func_78377_a(vector.getMaxX(), vector.getMinY(), vector.getMaxZ());
        t.func_78377_a(vector.getMaxX(), vector.getMaxY(), vector.getMaxZ());
        t.func_78377_a(vector.getMinX(), vector.getMaxY(), vector.getMaxZ());
        GL11.glColor4d((double)1.0, (double)1.0, (double)1.0, (double)1.0);
        if (!wasTesselating) {
            t.func_78381_a();
        }
    }

    public static void drawTesselatedColoredCube(Vec3dCube vector) {
        Tessellator t = Tessellator.field_78398_a;
        boolean wasTesselating = false;
        try {
            t.func_78382_b();
        }
        catch (IllegalStateException e) {
            wasTesselating = true;
        }
        t.func_78369_a(1.0f, 0.0f, 0.0f, 1.0f);
        t.func_78375_b(0.0f, 1.0f, 0.0f);
        t.func_78377_a(vector.getMinX(), vector.getMaxY(), vector.getMaxZ());
        t.func_78377_a(vector.getMaxX(), vector.getMaxY(), vector.getMaxZ());
        t.func_78377_a(vector.getMaxX(), vector.getMaxY(), vector.getMinZ());
        t.func_78377_a(vector.getMinX(), vector.getMaxY(), vector.getMinZ());
        t.func_78369_a(1.0f, 1.0f, 0.0f, 1.0f);
        t.func_78375_b(0.0f, -1.0f, 0.0f);
        t.func_78377_a(vector.getMaxX(), vector.getMinY(), vector.getMaxZ());
        t.func_78377_a(vector.getMinX(), vector.getMinY(), vector.getMaxZ());
        t.func_78377_a(vector.getMinX(), vector.getMinY(), vector.getMinZ());
        t.func_78377_a(vector.getMaxX(), vector.getMinY(), vector.getMinZ());
        t.func_78369_a(0.0f, 1.0f, 0.0f, 1.0f);
        t.func_78375_b(-1.0f, 0.0f, 0.0f);
        t.func_78377_a(vector.getMinX(), vector.getMinY(), vector.getMaxZ());
        t.func_78377_a(vector.getMinX(), vector.getMaxY(), vector.getMaxZ());
        t.func_78377_a(vector.getMinX(), vector.getMaxY(), vector.getMinZ());
        t.func_78377_a(vector.getMinX(), vector.getMinY(), vector.getMinZ());
        t.func_78369_a(0.0f, 1.0f, 1.0f, 1.0f);
        t.func_78375_b(1.0f, 0.0f, 0.0f);
        t.func_78377_a(vector.getMaxX(), vector.getMinY(), vector.getMinZ());
        t.func_78377_a(vector.getMaxX(), vector.getMaxY(), vector.getMinZ());
        t.func_78377_a(vector.getMaxX(), vector.getMaxY(), vector.getMaxZ());
        t.func_78377_a(vector.getMaxX(), vector.getMinY(), vector.getMaxZ());
        t.func_78369_a(0.0f, 0.0f, 1.0f, 1.0f);
        t.func_78375_b(0.0f, 0.0f, -1.0f);
        t.func_78377_a(vector.getMinX(), vector.getMinY(), vector.getMinZ());
        t.func_78377_a(vector.getMinX(), vector.getMaxY(), vector.getMinZ());
        t.func_78377_a(vector.getMaxX(), vector.getMaxY(), vector.getMinZ());
        t.func_78377_a(vector.getMaxX(), vector.getMinY(), vector.getMinZ());
        t.func_78369_a(0.0f, 0.0f, 0.0f, 1.0f);
        t.func_78375_b(0.0f, 0.0f, 1.0f);
        t.func_78377_a(vector.getMinX(), vector.getMinY(), vector.getMaxZ());
        t.func_78377_a(vector.getMaxX(), vector.getMinY(), vector.getMaxZ());
        t.func_78377_a(vector.getMaxX(), vector.getMaxY(), vector.getMaxZ());
        t.func_78377_a(vector.getMinX(), vector.getMaxY(), vector.getMaxZ());
        if (!wasTesselating) {
            t.func_78381_a();
        }
    }

    public static void drawTesselatedTexturedCube(Vec3dCube vector) {
        Tessellator t = Tessellator.field_78398_a;
        boolean wasTesselating = false;
        try {
            t.func_78382_b();
        }
        catch (IllegalStateException e) {
            wasTesselating = true;
        }
        double minU = 0.0;
        double maxU = 1.0;
        double minV = 0.0;
        double maxV = 1.0;
        t.func_78375_b(0.0f, 1.0f, 0.0f);
        t.func_78374_a(vector.getMinX(), vector.getMaxY(), vector.getMaxZ(), minU, maxV);
        t.func_78374_a(vector.getMaxX(), vector.getMaxY(), vector.getMaxZ(), minU, minV);
        t.func_78374_a(vector.getMaxX(), vector.getMaxY(), vector.getMinZ(), maxU, minV);
        t.func_78374_a(vector.getMinX(), vector.getMaxY(), vector.getMinZ(), maxU, maxV);
        t.func_78375_b(0.0f, -1.0f, 0.0f);
        t.func_78374_a(vector.getMaxX(), vector.getMinY(), vector.getMaxZ(), minU, maxV);
        t.func_78374_a(vector.getMinX(), vector.getMinY(), vector.getMaxZ(), minU, minV);
        t.func_78374_a(vector.getMinX(), vector.getMinY(), vector.getMinZ(), maxU, minV);
        t.func_78374_a(vector.getMaxX(), vector.getMinY(), vector.getMinZ(), maxU, maxV);
        t.func_78375_b(-1.0f, 0.0f, 0.0f);
        t.func_78374_a(vector.getMinX(), vector.getMinY(), vector.getMaxZ(), minU, maxV);
        t.func_78374_a(vector.getMinX(), vector.getMaxY(), vector.getMaxZ(), minU, minV);
        t.func_78374_a(vector.getMinX(), vector.getMaxY(), vector.getMinZ(), maxU, minV);
        t.func_78374_a(vector.getMinX(), vector.getMinY(), vector.getMinZ(), maxU, maxV);
        t.func_78375_b(1.0f, 0.0f, 0.0f);
        t.func_78374_a(vector.getMaxX(), vector.getMinY(), vector.getMinZ(), minU, maxV);
        t.func_78374_a(vector.getMaxX(), vector.getMaxY(), vector.getMinZ(), minU, minV);
        t.func_78374_a(vector.getMaxX(), vector.getMaxY(), vector.getMaxZ(), maxU, minV);
        t.func_78374_a(vector.getMaxX(), vector.getMinY(), vector.getMaxZ(), maxU, maxV);
        t.func_78375_b(0.0f, 0.0f, -1.0f);
        t.func_78374_a(vector.getMinX(), vector.getMinY(), vector.getMinZ(), minU, maxV);
        t.func_78374_a(vector.getMinX(), vector.getMaxY(), vector.getMinZ(), minU, minV);
        t.func_78374_a(vector.getMaxX(), vector.getMaxY(), vector.getMinZ(), maxU, minV);
        t.func_78374_a(vector.getMaxX(), vector.getMinY(), vector.getMinZ(), maxU, maxV);
        t.func_78375_b(0.0f, 0.0f, 1.0f);
        t.func_78374_a(vector.getMinX(), vector.getMinY(), vector.getMaxZ(), minU, maxV);
        t.func_78374_a(vector.getMaxX(), vector.getMinY(), vector.getMaxZ(), minU, minV);
        t.func_78374_a(vector.getMaxX(), vector.getMaxY(), vector.getMaxZ(), maxU, minV);
        t.func_78374_a(vector.getMinX(), vector.getMaxY(), vector.getMaxZ(), maxU, maxV);
        if (!wasTesselating) {
            t.func_78381_a();
        }
    }

    public static void drawTesselatedCube(Vec3dCube vector) {
        Tessellator t = Tessellator.field_78398_a;
        boolean wasTesselating = false;
        try {
            t.func_78382_b();
        }
        catch (IllegalStateException e) {
            wasTesselating = true;
        }
        t.func_78375_b(0.0f, 1.0f, 0.0f);
        t.func_78377_a(vector.getMinX(), vector.getMaxY(), vector.getMaxZ());
        t.func_78377_a(vector.getMaxX(), vector.getMaxY(), vector.getMaxZ());
        t.func_78377_a(vector.getMaxX(), vector.getMaxY(), vector.getMinZ());
        t.func_78377_a(vector.getMinX(), vector.getMaxY(), vector.getMinZ());
        t.func_78375_b(0.0f, -1.0f, 0.0f);
        t.func_78377_a(vector.getMaxX(), vector.getMinY(), vector.getMaxZ());
        t.func_78377_a(vector.getMinX(), vector.getMinY(), vector.getMaxZ());
        t.func_78377_a(vector.getMinX(), vector.getMinY(), vector.getMinZ());
        t.func_78377_a(vector.getMaxX(), vector.getMinY(), vector.getMinZ());
        t.func_78375_b(-1.0f, 0.0f, 0.0f);
        t.func_78377_a(vector.getMinX(), vector.getMinY(), vector.getMaxZ());
        t.func_78377_a(vector.getMinX(), vector.getMaxY(), vector.getMaxZ());
        t.func_78377_a(vector.getMinX(), vector.getMaxY(), vector.getMinZ());
        t.func_78377_a(vector.getMinX(), vector.getMinY(), vector.getMinZ());
        t.func_78375_b(1.0f, 0.0f, 0.0f);
        t.func_78377_a(vector.getMaxX(), vector.getMinY(), vector.getMinZ());
        t.func_78377_a(vector.getMaxX(), vector.getMaxY(), vector.getMinZ());
        t.func_78377_a(vector.getMaxX(), vector.getMaxY(), vector.getMaxZ());
        t.func_78377_a(vector.getMaxX(), vector.getMinY(), vector.getMaxZ());
        t.func_78375_b(0.0f, 0.0f, -1.0f);
        t.func_78377_a(vector.getMinX(), vector.getMinY(), vector.getMinZ());
        t.func_78377_a(vector.getMinX(), vector.getMaxY(), vector.getMinZ());
        t.func_78377_a(vector.getMaxX(), vector.getMaxY(), vector.getMinZ());
        t.func_78377_a(vector.getMaxX(), vector.getMinY(), vector.getMinZ());
        t.func_78375_b(0.0f, 0.0f, 1.0f);
        t.func_78377_a(vector.getMinX(), vector.getMinY(), vector.getMaxZ());
        t.func_78377_a(vector.getMaxX(), vector.getMinY(), vector.getMaxZ());
        t.func_78377_a(vector.getMaxX(), vector.getMaxY(), vector.getMaxZ());
        t.func_78377_a(vector.getMinX(), vector.getMaxY(), vector.getMaxZ());
        if (!wasTesselating) {
            t.func_78381_a();
        }
    }

    public static void drawTesselatedCubeWithoutNormals(Vec3dCube vector) {
        Tessellator t = Tessellator.field_78398_a;
        boolean wasTesselating = false;
        try {
            t.func_78382_b();
        }
        catch (IllegalStateException e) {
            wasTesselating = true;
        }
        t.func_78377_a(vector.getMinX(), vector.getMaxY(), vector.getMaxZ());
        t.func_78377_a(vector.getMaxX(), vector.getMaxY(), vector.getMaxZ());
        t.func_78377_a(vector.getMaxX(), vector.getMaxY(), vector.getMinZ());
        t.func_78377_a(vector.getMinX(), vector.getMaxY(), vector.getMinZ());
        t.func_78377_a(vector.getMaxX(), vector.getMinY(), vector.getMaxZ());
        t.func_78377_a(vector.getMinX(), vector.getMinY(), vector.getMaxZ());
        t.func_78377_a(vector.getMinX(), vector.getMinY(), vector.getMinZ());
        t.func_78377_a(vector.getMaxX(), vector.getMinY(), vector.getMinZ());
        t.func_78377_a(vector.getMinX(), vector.getMinY(), vector.getMaxZ());
        t.func_78377_a(vector.getMinX(), vector.getMaxY(), vector.getMaxZ());
        t.func_78377_a(vector.getMinX(), vector.getMaxY(), vector.getMinZ());
        t.func_78377_a(vector.getMinX(), vector.getMinY(), vector.getMinZ());
        t.func_78377_a(vector.getMaxX(), vector.getMinY(), vector.getMinZ());
        t.func_78377_a(vector.getMaxX(), vector.getMaxY(), vector.getMinZ());
        t.func_78377_a(vector.getMaxX(), vector.getMaxY(), vector.getMaxZ());
        t.func_78377_a(vector.getMaxX(), vector.getMinY(), vector.getMaxZ());
        t.func_78377_a(vector.getMinX(), vector.getMinY(), vector.getMinZ());
        t.func_78377_a(vector.getMinX(), vector.getMaxY(), vector.getMinZ());
        t.func_78377_a(vector.getMaxX(), vector.getMaxY(), vector.getMinZ());
        t.func_78377_a(vector.getMaxX(), vector.getMinY(), vector.getMinZ());
        t.func_78377_a(vector.getMinX(), vector.getMinY(), vector.getMaxZ());
        t.func_78377_a(vector.getMaxX(), vector.getMinY(), vector.getMaxZ());
        t.func_78377_a(vector.getMaxX(), vector.getMaxY(), vector.getMaxZ());
        t.func_78377_a(vector.getMinX(), vector.getMaxY(), vector.getMaxZ());
        if (!wasTesselating) {
            t.func_78381_a();
        }
    }

    public static void rotateRenderMatrix(ForgeDirection d) {
        switch (d) {
            case UP: {
                GL11.glRotatef((float)1.0f, (float)0.0f, (float)0.0f, (float)-90.0f);
                break;
            }
            case DOWN: {
                GL11.glRotatef((float)1.0f, (float)0.0f, (float)0.0f, (float)90.0f);
                break;
            }
            case NORTH: {
                GL11.glRotatef((float)1.0f, (float)0.0f, (float)-90.0f, (float)0.0f);
                break;
            }
            case SOUTH: {
                GL11.glRotatef((float)1.0f, (float)0.0f, (float)90.0f, (float)0.0f);
                break;
            }
            case WEST: {
                GL11.glRotatef((float)1.0f, (float)0.0f, (float)0.0f, (float)180.0f);
                break;
            }
            case EAST: {
                GL11.glRotatef((float)1.0f, (float)0.0f, (float)0.0f, (float)0.0f);
                break;
            }
        }
    }
}

