/*
 * Decompiled with CFR 0.152.
 */
package com.bluepowermod.helper;

import com.bluepowermod.api.tube.IPneumaticTube;
import com.bluepowermod.api.tube.ITubeConnection;
import com.bluepowermod.helper.ItemStackHelper;
import com.bluepowermod.part.tube.PneumaticTube;
import com.bluepowermod.part.tube.TubeLogic;
import com.bluepowermod.part.tube.TubeStack;
import net.minecraft.block.Block;
import net.minecraft.block.BlockChest;
import net.minecraft.entity.Entity;
import net.minecraft.entity.item.EntityItem;
import net.minecraft.inventory.IInventory;
import net.minecraft.inventory.ISidedInventory;
import net.minecraft.item.ItemStack;
import net.minecraft.nbt.NBTTagCompound;
import net.minecraft.tileentity.TileEntity;
import net.minecraft.world.World;
import net.minecraftforge.common.util.ForgeDirection;
import uk.co.qmunity.lib.part.compat.MultipartCompatibility;

public class IOHelper {
    public static IInventory getInventoryForTE(TileEntity te) {
        if (te instanceof IInventory) {
            IInventory inv = (IInventory)te;
            Block block = te.func_145838_q();
            if (block instanceof BlockChest) {
                inv = ((BlockChest)block).func_149951_m(te.func_145831_w(), te.field_145851_c, te.field_145848_d, te.field_145849_e);
            }
            return inv;
        }
        return null;
    }

    public static ItemStack extract(TileEntity inventory, ForgeDirection direction, boolean simulate) {
        IInventory inv = IOHelper.getInventoryForTE(inventory);
        if (inv != null) {
            return IOHelper.extract(inv, direction, simulate);
        }
        return null;
    }

    public static ItemStack extract(IInventory inventory, ForgeDirection direction, boolean simulate) {
        if (inventory instanceof ISidedInventory) {
            int[] accessibleSlotsFromSide;
            ISidedInventory isidedinventory = (ISidedInventory)inventory;
            for (int anAccessibleSlotsFromSide : accessibleSlotsFromSide = isidedinventory.func_94128_d(direction.ordinal())) {
                ItemStack stack = IOHelper.extract(inventory, direction, anAccessibleSlotsFromSide, simulate);
                if (stack == null) continue;
                return stack;
            }
        } else {
            int j = inventory.func_70302_i_();
            for (int k = 0; k < j; ++k) {
                ItemStack stack = IOHelper.extract(inventory, direction, k, simulate);
                if (stack == null) continue;
                return stack;
            }
        }
        return null;
    }

    public static ItemStack extract(IInventory inventory, ForgeDirection direction, int slot, boolean simulate) {
        ItemStack itemstack = inventory.func_70301_a(slot);
        if (itemstack != null && IOHelper.canExtractItemFromInventory(inventory, itemstack, slot, direction.ordinal())) {
            if (!simulate) {
                inventory.func_70299_a(slot, null);
            }
            return itemstack;
        }
        return null;
    }

    public static ItemStack extract(TileEntity tile, ForgeDirection direction, ItemStack requestedStack, boolean useItemCount, boolean simulate) {
        return IOHelper.extract(tile, direction, requestedStack, useItemCount, simulate, 0);
    }

    public static int[] getAccessibleSlotsForInventory(IInventory inv, ForgeDirection side) {
        if (inv != null) {
            int[] accessibleSlots;
            if (inv instanceof ISidedInventory) {
                accessibleSlots = ((ISidedInventory)inv).func_94128_d(side.ordinal());
            } else {
                accessibleSlots = new int[inv.func_70302_i_()];
                for (int i = 0; i < accessibleSlots.length; ++i) {
                    accessibleSlots[i] = i;
                }
            }
            return accessibleSlots;
        }
        return new int[0];
    }

    public static int getItemCount(ItemStack type, TileEntity inv, ForgeDirection side, int fuzzySetting) {
        IInventory inventory = IOHelper.getInventoryForTE(inv);
        int[] slots = IOHelper.getAccessibleSlotsForInventory(inventory, side);
        int count = 0;
        for (int slot : slots) {
            ItemStack invStack = inventory.func_70301_a(slot);
            if (invStack == null || !ItemStackHelper.areStacksEqual(invStack, type, fuzzySetting)) continue;
            count += invStack.field_77994_a;
        }
        return count;
    }

    public static ItemStack extract(TileEntity tile, ForgeDirection direction, ItemStack requestedStack, boolean useItemCount, boolean simulate, int fuzzySetting) {
        if (requestedStack == null) {
            return requestedStack;
        }
        IInventory inv = IOHelper.getInventoryForTE(tile);
        if (inv != null) {
            int[] accessibleSlots;
            if (inv instanceof ISidedInventory) {
                accessibleSlots = ((ISidedInventory)inv).func_94128_d(direction.ordinal());
            } else {
                accessibleSlots = new int[inv.func_70302_i_()];
                for (int i = 0; i < accessibleSlots.length; ++i) {
                    accessibleSlots[i] = i;
                }
            }
            int itemsFound = 0;
            for (int slot : accessibleSlots) {
                ItemStack stack = inv.func_70301_a(slot);
                if (stack == null || !ItemStackHelper.areStacksEqual(stack, requestedStack, fuzzySetting) || !IOHelper.canExtractItemFromInventory(inv, requestedStack, slot, direction.ordinal())) continue;
                if (!useItemCount) {
                    if (!simulate) {
                        inv.func_70299_a(slot, null);
                    }
                    return stack;
                }
                itemsFound += stack.field_77994_a;
            }
            if (itemsFound >= requestedStack.field_77994_a) {
                ItemStack exportedStack = null;
                int itemsNeeded = requestedStack.field_77994_a;
                for (int slot : accessibleSlots) {
                    ItemStack stack = inv.func_70301_a(slot);
                    if (stack == null || !ItemStackHelper.areStacksEqual(stack, requestedStack, fuzzySetting) || !IOHelper.canExtractItemFromInventory(inv, requestedStack, slot, direction.ordinal())) continue;
                    int itemsSubstracted = Math.min(itemsNeeded, stack.field_77994_a);
                    if (itemsSubstracted > 0) {
                        exportedStack = stack;
                    }
                    itemsNeeded -= itemsSubstracted;
                    if (simulate) continue;
                    stack.field_77994_a -= itemsSubstracted;
                    if (stack.field_77994_a == 0) {
                        inv.func_70299_a(slot, null);
                    }
                    tile.func_70296_d();
                }
                exportedStack = exportedStack.func_77946_l();
                exportedStack.field_77994_a = requestedStack.field_77994_a;
                return exportedStack;
            }
        }
        return null;
    }

    public static ItemStack extractOneItem(TileEntity tile, ForgeDirection dir) {
        IInventory inv = IOHelper.getInventoryForTE(tile);
        if (inv != null) {
            int[] accessibleSlots;
            if (inv instanceof ISidedInventory) {
                accessibleSlots = ((ISidedInventory)inv).func_94128_d(dir.ordinal());
            } else {
                accessibleSlots = new int[inv.func_70302_i_()];
                for (int i = 0; i < accessibleSlots.length; ++i) {
                    accessibleSlots[i] = i;
                }
            }
            for (int slot : accessibleSlots) {
                ItemStack retrievingStack;
                ItemStack stack = inv.func_70301_a(slot);
                ItemStack itemStack = retrievingStack = stack == null ? null : stack.func_77946_l().func_77979_a(1);
                if (stack == null || !IOHelper.canExtractItemFromInventory(inv, retrievingStack, slot, dir.ordinal())) continue;
                ItemStack ret = stack.func_77979_a(1);
                if (stack.field_77994_a == 0) {
                    inv.func_70299_a(slot, null);
                }
                tile.func_70296_d();
                return ret;
            }
        }
        return null;
    }

    public static ItemStack insert(TileEntity tile, ItemStack itemStack, ForgeDirection direction, boolean simulate) {
        return IOHelper.insert(tile, itemStack, direction, IPneumaticTube.TubeColor.NONE, simulate);
    }

    public static ItemStack insert(TileEntity tile, ItemStack itemStack, ForgeDirection direction, IPneumaticTube.TubeColor color, boolean simulate) {
        if (tile == null || itemStack == null) {
            return itemStack;
        }
        if (tile instanceof ITubeConnection) {
            TubeStack tubeStack = ((ITubeConnection)tile).acceptItemFromTube(new TubeStack(itemStack, direction.getOpposite(), color), direction, simulate);
            if (tubeStack == null) {
                return null;
            }
            return tubeStack.stack;
        }
        IInventory inv = IOHelper.getInventoryForTE(tile);
        if (inv != null) {
            return IOHelper.insert(inv, itemStack, direction.ordinal(), simulate);
        }
        PneumaticTube tube = (PneumaticTube)MultipartCompatibility.getPart((World)tile.func_145831_w(), (int)tile.field_145851_c, (int)tile.field_145848_d, (int)tile.field_145849_e, PneumaticTube.class);
        if (tube != null) {
            TubeLogic logic = tube.getLogic();
            return logic.injectStack(itemStack, direction.getOpposite(), color, simulate) ? null : itemStack;
        }
        return itemStack;
    }

    public static ItemStack insert(IInventory inventory, ItemStack itemStack, int side, boolean simulate) {
        if (inventory instanceof ISidedInventory && side > -1) {
            ISidedInventory isidedinventory = (ISidedInventory)inventory;
            int[] aint = isidedinventory.func_94128_d(side);
            for (int j = 0; j < aint.length && itemStack != null && itemStack.field_77994_a > 0; ++j) {
                itemStack = IOHelper.insert(inventory, itemStack, aint[j], side, simulate);
            }
        } else {
            int k = inventory.func_70302_i_();
            for (int l = 0; l < k && itemStack != null && itemStack.field_77994_a > 0; ++l) {
                itemStack = IOHelper.insert(inventory, itemStack, l, side, simulate);
            }
        }
        if (itemStack != null && itemStack.field_77994_a == 0) {
            itemStack = null;
        }
        return itemStack;
    }

    public static ItemStack insert(IInventory inventory, ItemStack itemStack, int slot, int side, boolean simulate) {
        ItemStack itemstack1 = inventory.func_70301_a(slot);
        if (IOHelper.canInsertItemToInventory(inventory, itemStack, slot, side)) {
            int max;
            boolean flag = false;
            if (itemstack1 == null) {
                int max2 = Math.min(itemStack.func_77976_d(), inventory.func_70297_j_());
                if (max2 >= itemStack.field_77994_a) {
                    if (!simulate) {
                        inventory.func_70299_a(slot, itemStack);
                        flag = true;
                    }
                    itemStack = null;
                } else if (!simulate) {
                    inventory.func_70299_a(slot, itemStack.func_77979_a(max2));
                    flag = true;
                } else {
                    itemStack.func_77979_a(max2);
                }
            } else if (ItemStackHelper.areItemStacksEqual(itemstack1, itemStack) && (max = Math.min(itemStack.func_77976_d(), inventory.func_70297_j_())) > itemstack1.field_77994_a) {
                int l = Math.min(itemStack.field_77994_a, max - itemstack1.field_77994_a);
                itemStack.field_77994_a -= l;
                if (!simulate) {
                    itemstack1.field_77994_a += l;
                    boolean bl = flag = l > 0;
                }
            }
            if (flag) {
                inventory.func_70296_d();
            }
        }
        return itemStack;
    }

    public static boolean canInsertItemToInventory(IInventory inventory, ItemStack itemStack, int slot, int side) {
        return inventory.func_94041_b(slot, itemStack) && (!(inventory instanceof ISidedInventory) || ((ISidedInventory)inventory).func_102007_a(slot, itemStack, side));
    }

    public static boolean canExtractItemFromInventory(IInventory inventory, ItemStack itemStack, int slot, int side) {
        return !(inventory instanceof ISidedInventory) || ((ISidedInventory)inventory).func_102008_b(slot, itemStack, side);
    }

    public static void dropInventory(World world, int x, int y, int z) {
        TileEntity tileEntity = world.func_147438_o(x, y, z);
        if (!(tileEntity instanceof IInventory)) {
            return;
        }
        IInventory inventory = (IInventory)tileEntity;
        for (int i = 0; i < inventory.func_70302_i_(); ++i) {
            ItemStack itemStack = inventory.func_70301_a(i);
            if (itemStack == null || itemStack.field_77994_a <= 0) continue;
            IOHelper.spawnItemInWorld(world, itemStack, x, y, z);
        }
    }

    public static void spawnItemInWorld(World world, ItemStack itemStack, double x, double y, double z) {
        if (world.field_72995_K) {
            return;
        }
        float dX = world.field_73012_v.nextFloat() * 0.8f + 0.1f;
        float dY = world.field_73012_v.nextFloat() * 0.8f + 0.1f;
        float dZ = world.field_73012_v.nextFloat() * 0.8f + 0.1f;
        EntityItem entityItem = new EntityItem(world, x + (double)dX, y + (double)dY, z + (double)dZ, new ItemStack(itemStack.func_77973_b(), itemStack.field_77994_a, itemStack.func_77960_j()));
        if (itemStack.func_77942_o()) {
            entityItem.func_92059_d().func_77982_d((NBTTagCompound)itemStack.func_77978_p().func_74737_b());
        }
        float factor = 0.05f;
        entityItem.field_70159_w = world.field_73012_v.nextGaussian() * (double)factor;
        entityItem.field_70181_x = world.field_73012_v.nextGaussian() * (double)factor + (double)0.2f;
        entityItem.field_70179_y = world.field_73012_v.nextGaussian() * (double)factor;
        world.func_72838_d((Entity)entityItem);
        itemStack.field_77994_a = 0;
    }

    public static boolean canInterfaceWith(TileEntity tile, ForgeDirection direction) {
        return IOHelper.canInterfaceWith(tile, direction, null, true);
    }

    public static boolean canInterfaceWith(TileEntity tile, ForgeDirection direction, PneumaticTube requester, boolean canInterfaceWithIInventory) {
        PneumaticTube tube;
        PneumaticTube pneumaticTube = tube = tile != null ? (PneumaticTube)MultipartCompatibility.getPart((World)tile.func_145831_w(), (int)tile.field_145851_c, (int)tile.field_145848_d, (int)tile.field_145849_e, PneumaticTube.class) : null;
        if (tube != null && tube.isConnected(direction, requester)) {
            return true;
        }
        if (!canInterfaceWithIInventory) {
            return false;
        }
        if (tile instanceof ITubeConnection) {
            return true;
        }
        if (tile instanceof IInventory) {
            return !(tile instanceof ISidedInventory) || ((ISidedInventory)tile).func_94128_d(direction.ordinal()).length > 0;
        }
        return false;
    }
}

