/*
 * Decompiled with CFR 0.152.
 */
package com.bluepowermod.part.gate.analogue;

import com.bluepowermod.api.wire.redstone.RedwireType;
import com.bluepowermod.part.gate.analogue.GateSimpleAnalogue;
import com.bluepowermod.part.gate.component.GateComponentBorder;
import com.bluepowermod.part.gate.component.GateComponentTorch;
import com.bluepowermod.part.gate.component.GateComponentWire;
import com.bluepowermod.part.gate.connection.GateConnectionAnalogue;
import com.bluepowermod.part.gate.connection.GateConnectionBase;
import net.minecraft.nbt.NBTTagCompound;
import uk.co.qmunity.lib.misc.ShiftingBuffer;
import uk.co.qmunity.lib.util.Dir;

public class GateInverter
extends GateSimpleAnalogue {
    private ShiftingBuffer<Byte> buf = new ShiftingBuffer(1, 3, (Object)0);
    private GateComponentTorch t;

    @Override
    protected String getGateType() {
        return "inverter";
    }

    @Override
    protected void initializeConnections() {
        ((GateConnectionAnalogue)this.front()).enable().setOutputOnly().setOutput((byte)-1);
        ((GateConnectionAnalogue)this.left()).enable().setOutputOnly().setOutput((byte)-1);
        ((GateConnectionAnalogue)this.right()).enable().setOutputOnly().setOutput((byte)-1);
        this.back(new GateConnectionAnalogue(this, Dir.BACK)).enable();
    }

    @Override
    protected void initComponents() {
        this.t = new GateComponentTorch(this, 255, 0.25, false).setState(true);
        this.addComponent(this.t);
        this.addComponent(new GateComponentWire(this, 1638144, RedwireType.RED_ALLOY).bind((GateConnectionBase)this.front()));
        this.addComponent(new GateComponentWire(this, 0xFFF600, RedwireType.RED_ALLOY).bind((GateConnectionBase)this.right()));
        this.addComponent(new GateComponentWire(this, 12976383, RedwireType.RED_ALLOY).bind((GateConnectionBase)this.back()));
        this.addComponent(new GateComponentWire(this, 0xFF0000, RedwireType.RED_ALLOY).bind((GateConnectionBase)this.left()));
        this.addComponent(new GateComponentBorder(this, 0x7D7D7D));
    }

    @Override
    public void doLogic() {
        this.buf.set(0, (Object)((GateConnectionAnalogue)this.back()).getInput());
    }

    @Override
    public void tick() {
        if (this.getWorld().field_72995_K) {
            return;
        }
        this.buf.shift();
        byte state = (byte)(255 - ((Byte)this.buf.get(0) & 0xFF));
        this.t.setState((state & 0xFF) > 0);
        ((GateConnectionAnalogue)this.left()).setOutput(state);
        ((GateConnectionAnalogue)this.front()).setOutput(state);
        ((GateConnectionAnalogue)this.right()).setOutput(state);
    }

    @Override
    public boolean changeMode() {
        if (((GateConnectionAnalogue)this.left()).isEnabled() && ((GateConnectionAnalogue)this.front()).isEnabled() && ((GateConnectionAnalogue)this.right()).isEnabled()) {
            ((GateConnectionAnalogue)this.right()).disable();
        } else if (((GateConnectionAnalogue)this.left()).isEnabled() && ((GateConnectionAnalogue)this.front()).isEnabled()) {
            ((GateConnectionAnalogue)this.front()).disable();
            ((GateConnectionAnalogue)this.right()).enable();
        } else if (((GateConnectionAnalogue)this.left()).isEnabled() && ((GateConnectionAnalogue)this.right()).isEnabled()) {
            ((GateConnectionAnalogue)this.left()).disable();
            ((GateConnectionAnalogue)this.front()).enable();
        } else if (((GateConnectionAnalogue)this.front()).isEnabled() && ((GateConnectionAnalogue)this.right()).isEnabled()) {
            ((GateConnectionAnalogue)this.left()).enable();
            ((GateConnectionAnalogue)this.front()).disable();
            ((GateConnectionAnalogue)this.right()).disable();
        } else if (((GateConnectionAnalogue)this.left()).isEnabled()) {
            ((GateConnectionAnalogue)this.left()).disable();
            ((GateConnectionAnalogue)this.front()).enable();
        } else if (((GateConnectionAnalogue)this.front()).isEnabled()) {
            ((GateConnectionAnalogue)this.front()).disable();
            ((GateConnectionAnalogue)this.right()).enable();
        } else {
            ((GateConnectionAnalogue)this.left()).enable();
            ((GateConnectionAnalogue)this.front()).enable();
        }
        return true;
    }

    @Override
    public void writeToNBT(NBTTagCompound tag) {
        super.writeToNBT(tag);
        this.buf.writeToNBT(tag, "buffer");
    }

    @Override
    public void readFromNBT(NBTTagCompound tag) {
        super.readFromNBT(tag);
        this.buf.readFromNBT(tag, "buffer");
    }
}

