/*
 * Decompiled with CFR 0.152.
 */
package com.bluepowermod.redstone;

import com.bluepowermod.api.connect.ConnectionType;
import com.bluepowermod.api.wire.redstone.IBundledDevice;
import com.bluepowermod.api.wire.redstone.IPropagator;
import com.bluepowermod.api.wire.redstone.IRedstoneApi;
import com.bluepowermod.api.wire.redstone.IRedstoneDevice;
import com.bluepowermod.api.wire.redstone.IRedstoneProvider;
import com.bluepowermod.redstone.BundledConnection;
import com.bluepowermod.redstone.BundledConnectionCache;
import com.bluepowermod.redstone.BundledPropagator;
import com.bluepowermod.redstone.DummyRedstoneDevice;
import com.bluepowermod.redstone.RedstoneConnection;
import com.bluepowermod.redstone.RedstoneConnectionCache;
import com.bluepowermod.redstone.RedstonePropagator;
import com.bluepowermod.redstone.RedstoneProviderVanilla;
import java.util.ArrayList;
import java.util.List;
import net.minecraft.world.World;
import net.minecraftforge.common.util.ForgeDirection;

public class RedstoneApi
implements IRedstoneApi {
    private static RedstoneApi INSTANCE = new RedstoneApi();
    private List<IRedstoneProvider> providers = new ArrayList<IRedstoneProvider>();
    private boolean shouldWiresOutputPower = true;
    private boolean shouldLossyWiresOutputPower = true;
    private boolean shouldWiresHandleUpdates = true;
    private DummyRedstoneDevice returnDevice = DummyRedstoneDevice.getDeviceAt(null);

    private RedstoneApi() {
    }

    public static RedstoneApi getInstance() {
        return INSTANCE;
    }

    @Override
    public IRedstoneDevice getRedstoneDevice(World world, int x, int y, int z, ForgeDirection face, ForgeDirection side) {
        boolean returned = false;
        for (IRedstoneProvider provider : this.providers) {
            if (returned && provider instanceof RedstoneProviderVanilla) continue;
            IRedstoneDevice device = provider.getRedstoneDeviceAt(world, x, y, z, face, side);
            if (device == this.returnDevice) {
                returned = true;
                continue;
            }
            if (device == null) continue;
            return device;
        }
        return null;
    }

    @Override
    public IBundledDevice getBundledDevice(World world, int x, int y, int z, ForgeDirection face, ForgeDirection side) {
        for (IRedstoneProvider provider : this.providers) {
            IBundledDevice device = provider.getBundledDeviceAt(world, x, y, z, face, side);
            if (device == this.returnDevice) {
                return null;
            }
            if (device == null) continue;
            return device;
        }
        return null;
    }

    @Override
    public void registerRedstoneProvider(IRedstoneProvider provider) {
        if (provider == null) {
            return;
        }
        if (this.providers.contains(provider)) {
            return;
        }
        this.providers.add(provider);
    }

    @Override
    public boolean shouldWiresOutputPower(boolean lossy) {
        return lossy ? this.shouldLossyWiresOutputPower : this.shouldWiresOutputPower;
    }

    @Override
    public void setWiresOutputPower(boolean shouldWiresOutputPower, boolean lossy) {
        if (lossy) {
            this.shouldLossyWiresOutputPower = shouldWiresOutputPower;
        } else {
            this.shouldWiresOutputPower = shouldWiresOutputPower;
        }
    }

    @Override
    public boolean shouldWiresHandleUpdates() {
        return this.shouldWiresHandleUpdates;
    }

    @Override
    public void setWiresHandleUpdates(boolean shouldWiresHandleUpdates) {
        this.shouldWiresHandleUpdates = shouldWiresHandleUpdates;
    }

    public IRedstoneDevice getReturnDevice() {
        return this.returnDevice;
    }

    public RedstoneConnection createConnection(IRedstoneDevice a, IRedstoneDevice b, ForgeDirection sideA, ForgeDirection sideB, ConnectionType type) {
        if (a == null || b == null || sideA == null || sideB == null || type == null || a == b) {
            return null;
        }
        return new RedstoneConnection(a, b, sideA, sideB, type);
    }

    public BundledConnection createConnection(IBundledDevice a, IBundledDevice b, ForgeDirection sideA, ForgeDirection sideB, ConnectionType type) {
        if (a == null || b == null || sideA == null || sideB == null || type == null || a == b) {
            return null;
        }
        return new BundledConnection(a, b, sideA, sideB, type);
    }

    public RedstoneConnectionCache createRedstoneConnectionCache(IRedstoneDevice dev) {
        return new RedstoneConnectionCache(dev);
    }

    public BundledConnectionCache createBundledConnectionCache(IBundledDevice dev) {
        return new BundledConnectionCache(dev);
    }

    @Override
    public IPropagator<IRedstoneDevice> getRedstonePropagator(IRedstoneDevice device, ForgeDirection side) {
        return new RedstonePropagator.RedPropagator(device, side);
    }

    @Override
    public IPropagator<IBundledDevice> getBundledPropagator(IBundledDevice device, ForgeDirection side) {
        return new BundledPropagator(device, side);
    }
}

