/*
 * Decompiled with CFR 0.152.
 */
package com.bluepowermod.tile.tier2;

import com.bluepowermod.init.BPBlocks;
import com.bluepowermod.part.IGuiButtonSensitive;
import com.bluepowermod.part.PartInfo;
import com.bluepowermod.part.PartManager;
import com.bluepowermod.part.gate.GateBase;
import com.bluepowermod.tile.IGUITextFieldSensitive;
import com.bluepowermod.tile.TileBase;
import java.util.ArrayList;
import java.util.Iterator;
import java.util.List;
import net.minecraft.entity.player.EntityPlayer;
import net.minecraft.inventory.ICrafting;
import net.minecraft.inventory.IInventory;
import net.minecraft.inventory.InventoryBasic;
import net.minecraft.item.ItemStack;
import net.minecraft.nbt.NBTBase;
import net.minecraft.nbt.NBTTagCompound;
import net.minecraft.nbt.NBTTagList;

public class TileCircuitTable
extends TileBase
implements IInventory,
IGuiButtonSensitive,
IGUITextFieldSensitive {
    protected ItemStack[] inventory = new ItemStack[18];
    public final InventoryBasic circuitInventory = new InventoryBasic("circuitInventory", false, 24);
    public int slotsScrolled;
    private String textboxString = "";

    public TileCircuitTable() {
        this.updateGateInventory();
    }

    public void updateGateInventory() {
        List<ItemStack> gates = this.getApplicableItems();
        Iterator<ItemStack> iterator = gates.iterator();
        while (iterator.hasNext()) {
            if (iterator.next().func_82833_r().toLowerCase().contains(this.textboxString.toLowerCase())) continue;
            iterator.remove();
        }
        this.slotsScrolled = Math.max(0, Math.min(this.slotsScrolled, (gates.size() - 17) / 8));
        for (int i = 0; i < this.circuitInventory.func_70302_i_(); ++i) {
            ItemStack stack = gates.size() > this.slotsScrolled * 8 + i ? gates.get(this.slotsScrolled * 8 + i) : null;
            this.circuitInventory.func_70299_a(i, stack);
        }
    }

    protected List<ItemStack> getApplicableItems() {
        ArrayList<ItemStack> gates = new ArrayList<ItemStack>();
        List<PartInfo> registeredParts = PartManager.getRegisteredParts();
        for (PartInfo part : registeredParts) {
            if (!(part.getExample() instanceof GateBase) || !((GateBase)part.getExample()).isCraftableInCircuitTable()) continue;
            ItemStack partStack = part.getStack().func_77946_l();
            gates.add(partStack);
        }
        return gates;
    }

    public int getRequiredScrollStates() {
        return (this.getApplicableItems().size() - 17) / 8;
    }

    @Override
    public void onButtonPress(EntityPlayer player, int messageId, int value) {
        if (messageId == 0) {
            this.slotsScrolled = value;
        }
        this.updateGateInventory();
        ((ICrafting)player).func_71110_a(player.field_71070_bA, player.field_71070_bA.func_75138_a());
    }

    @Override
    public void setText(int textFieldID, String text) {
        this.textboxString = text;
        this.updateGateInventory();
    }

    @Override
    public String getText(int textFieldID) {
        return this.textboxString;
    }

    @Override
    public List<ItemStack> getDrops() {
        List<ItemStack> drops = super.getDrops();
        for (ItemStack stack : this.inventory) {
            if (stack == null) continue;
            drops.add(stack);
        }
        return drops;
    }

    @Override
    public void func_145841_b(NBTTagCompound tag) {
        super.func_145841_b(tag);
        NBTTagList tagList = new NBTTagList();
        for (int currentIndex = 0; currentIndex < this.inventory.length; ++currentIndex) {
            if (this.inventory[currentIndex] == null) continue;
            NBTTagCompound tagCompound = new NBTTagCompound();
            tagCompound.func_74774_a("Slot", (byte)currentIndex);
            this.inventory[currentIndex].func_77955_b(tagCompound);
            tagList.func_74742_a((NBTBase)tagCompound);
        }
        tag.func_74782_a("Items", (NBTBase)tagList);
        tag.func_74778_a("textboxString", this.textboxString);
    }

    @Override
    public void func_145839_a(NBTTagCompound tag) {
        super.func_145839_a(tag);
        NBTTagList tagList = tag.func_150295_c("Items", 10);
        this.inventory = new ItemStack[18];
        for (int i = 0; i < tagList.func_74745_c(); ++i) {
            NBTTagCompound tagCompound = tagList.func_150305_b(i);
            byte slot = tagCompound.func_74771_c("Slot");
            if (slot < 0 || slot >= this.inventory.length) continue;
            this.inventory[slot] = ItemStack.func_77949_a((NBTTagCompound)tagCompound);
        }
        this.textboxString = tag.func_74779_i("textboxString");
    }

    public int func_70302_i_() {
        return this.inventory.length;
    }

    public ItemStack func_70301_a(int i) {
        return this.inventory[i];
    }

    public ItemStack func_70298_a(int slot, int amount) {
        ItemStack itemStack = this.func_70301_a(slot);
        if (itemStack != null) {
            if (itemStack.field_77994_a <= amount) {
                this.func_70299_a(slot, null);
            } else {
                itemStack = itemStack.func_77979_a(amount);
                if (itemStack.field_77994_a == 0) {
                    this.func_70299_a(slot, null);
                }
            }
        }
        return itemStack;
    }

    public ItemStack func_70304_b(int i) {
        ItemStack itemStack = this.func_70301_a(i);
        if (itemStack != null) {
            this.func_70299_a(i, null);
        }
        return itemStack;
    }

    public void func_70299_a(int i, ItemStack itemStack) {
        this.inventory[i] = itemStack;
    }

    public String func_145825_b() {
        return BPBlocks.circuit_table.func_149739_a();
    }

    public boolean func_145818_k_() {
        return false;
    }

    public int func_70297_j_() {
        return 64;
    }

    public boolean func_70300_a(EntityPlayer player) {
        return true;
    }

    public void func_70295_k_() {
    }

    public void func_70305_f() {
    }

    public boolean func_94041_b(int p_94041_1_, ItemStack p_94041_2_) {
        return true;
    }
}

