/*
 * Decompiled with CFR 0.152.
 */
package uk.co.qmunity.lib.misc;

import net.minecraft.nbt.NBTBase;
import net.minecraft.nbt.NBTTagCompound;

public class ShiftingBuffer<T> {
    private Object[][] data;
    private T def;

    public ShiftingBuffer(int buffers, int size, T def) {
        this.data = new Object[buffers][size];
        this.def = def;
        for (int i = 0; i < buffers; ++i) {
            for (int j = 0; j < size; ++j) {
                this.data[i][j] = def;
            }
        }
    }

    public T set(int buffer, T value) {
        this.data[buffer][0] = value;
        return value;
    }

    public T get(int buffer) {
        return this.get(buffer, this.data[buffer].length - 1);
    }

    public T get(int buffer, int id) {
        return (T)this.data[buffer][id];
    }

    public Object[] getAll(int buffer) {
        return this.data[buffer];
    }

    public void shift() {
        this.shift(false);
    }

    public void shift(boolean reset0) {
        for (int i = 0; i < this.data.length; ++i) {
            Object[] data = this.data[i];
            for (int j = data.length - 1; j > 0; --j) {
                data[j] = data[j - 1];
            }
            if (!reset0) continue;
            data[0] = this.def;
        }
    }

    public void writeToNBT(NBTTagCompound tag, String id) {
        NBTTagCompound t = tag.func_74775_l(id);
        if (this.def instanceof Boolean) {
            for (int i = 0; i < this.data.length; ++i) {
                Object[] d = this.data[i];
                for (int j = 0; j < d.length; ++j) {
                    t.func_74757_a(i + "_" + j, ((Boolean)d[j]).booleanValue());
                }
            }
        } else if (this.def instanceof Byte) {
            for (int i = 0; i < this.data.length; ++i) {
                Object[] d = this.data[i];
                for (int j = 0; j < d.length; ++j) {
                    t.func_74774_a(i + "_" + j, ((Byte)d[j]).byteValue());
                }
            }
        } else if (this.def instanceof Integer) {
            for (int i = 0; i < this.data.length; ++i) {
                Object[] d = this.data[i];
                for (int j = 0; j < d.length; ++j) {
                    t.func_74768_a(i + "_" + j, ((Integer)d[j]).intValue());
                }
            }
        }
        tag.func_74782_a(id, (NBTBase)t);
    }

    public void readFromNBT(NBTTagCompound tag, String id) {
        block7: {
            NBTTagCompound t;
            block8: {
                block6: {
                    t = tag.func_74775_l(id);
                    if (!(this.def instanceof Boolean)) break block6;
                    for (int i = 0; i < this.data.length; ++i) {
                        Object[] d = this.data[i];
                        for (int j = 0; j < d.length; ++j) {
                            d[j] = t.func_74767_n(i + "_" + j);
                        }
                    }
                    break block7;
                }
                if (!(this.def instanceof Byte)) break block8;
                for (int i = 0; i < this.data.length; ++i) {
                    Object[] d = this.data[i];
                    for (int j = 0; j < d.length; ++j) {
                        d[j] = t.func_74771_c(i + "_" + j);
                    }
                }
                break block7;
            }
            if (!(this.def instanceof Integer)) break block7;
            for (int i = 0; i < this.data.length; ++i) {
                Object[] d = this.data[i];
                for (int j = 0; j < d.length; ++j) {
                    d[j] = t.func_74762_e(i + "_" + j);
                }
            }
        }
    }
}

