/*
 * Decompiled with CFR 0.152.
 */
package uk.co.qmunity.lib.network;

import cpw.mods.fml.common.network.NetworkRegistry;
import java.io.DataInput;
import java.io.DataOutput;
import java.io.IOException;
import net.minecraft.world.World;
import uk.co.qmunity.lib.network.LocatedPacket;
import uk.co.qmunity.lib.network.Packet;
import uk.co.qmunity.lib.vec.IWorldLocation;

public abstract class LocatedPacketDouble<T extends LocatedPacket<T>>
extends Packet<T> {
    protected double x;
    protected double y;
    protected double z;

    public LocatedPacketDouble(IWorldLocation location) {
        this.x = location.getX();
        this.y = location.getY();
        this.z = location.getZ();
    }

    public LocatedPacketDouble(double x, double y, double z) {
        this.x = x;
        this.y = y;
        this.z = z;
    }

    public LocatedPacketDouble() {
    }

    @Override
    public void read(DataInput buffer) throws IOException {
        this.x = buffer.readDouble();
        this.y = buffer.readDouble();
        this.z = buffer.readDouble();
    }

    @Override
    public void write(DataOutput buffer) throws IOException {
        buffer.writeDouble(this.x);
        buffer.writeDouble(this.y);
        buffer.writeDouble(this.z);
    }

    public NetworkRegistry.TargetPoint getTargetPoint(World world) {
        return this.getTargetPoint(world, 64.0);
    }

    public NetworkRegistry.TargetPoint getTargetPoint(World world, double updateDistance) {
        return new NetworkRegistry.TargetPoint(world.field_73011_w.field_76574_g, this.x, this.y, this.z, updateDistance);
    }
}

