/*
 * Decompiled with CFR 0.152.
 */
package com.bluepowermod;

import com.bluepowermod.BluePowerAPI;
import com.bluepowermod.CommonProxy;
import com.bluepowermod.api.BPApi;
import com.bluepowermod.api.power.CapabilityBlutricity;
import com.bluepowermod.client.gui.GUIHandler;
import com.bluepowermod.compat.CompatibilityUtils;
import com.bluepowermod.event.BPEventHandler;
import com.bluepowermod.init.BPBlocks;
import com.bluepowermod.init.BPEnchantments;
import com.bluepowermod.init.BPItems;
import com.bluepowermod.init.Config;
import com.bluepowermod.init.OreDictionarySetup;
import com.bluepowermod.init.Recipes;
import com.bluepowermod.init.TileEntities;
import com.bluepowermod.network.BPNetworkHandler;
import com.bluepowermod.recipe.AlloyFurnaceRegistry;
import com.bluepowermod.reference.Refs;
import com.bluepowermod.world.WorldGenerationHandler;
import net.minecraft.item.Item;
import net.minecraftforge.common.MinecraftForge;
import net.minecraftforge.common.config.Configuration;
import net.minecraftforge.common.util.EnumHelper;
import net.minecraftforge.fml.common.IWorldGenerator;
import net.minecraftforge.fml.common.Mod;
import net.minecraftforge.fml.common.SidedProxy;
import net.minecraftforge.fml.common.event.FMLInitializationEvent;
import net.minecraftforge.fml.common.event.FMLPostInitializationEvent;
import net.minecraftforge.fml.common.event.FMLPreInitializationEvent;
import net.minecraftforge.fml.common.event.FMLServerStartingEvent;
import net.minecraftforge.fml.common.network.IGuiHandler;
import net.minecraftforge.fml.common.network.NetworkRegistry;
import net.minecraftforge.fml.common.registry.GameRegistry;
import org.apache.logging.log4j.Logger;

@Mod(modid="bluepower", name="Blue Power", guiFactory="com.bluepowermod.client.gui.BPGuiFactory", acceptedMinecraftVersions="[1.12.2]")
public class BluePower {
    @Mod.Instance(value="bluepower")
    public static BluePower instance;
    @SidedProxy(clientSide="com.bluepowermod.ClientProxy", serverSide="com.bluepowermod.CommonProxy")
    public static CommonProxy proxy;
    public static Logger log;
    public static Configuration config;
    public static Item.ToolMaterial gemMaterial;

    @Mod.EventHandler
    public void preInit(FMLPreInitializationEvent event) {
        event.getModMetadata().version = Refs.fullVersionString();
        log = event.getModLog();
        config = new Configuration(event.getSuggestedConfigurationFile());
        BPApi.init(new BluePowerAPI());
        Config.syncConfig(config);
        BPEnchantments.init();
        MinecraftForge.EVENT_BUS.register(BPEnchantments.class);
        CompatibilityUtils.preInit(event);
        CapabilityBlutricity.register();
        MinecraftForge.EVENT_BUS.register((Object)new Config());
        BPEventHandler eventHandler = new BPEventHandler();
        MinecraftForge.EVENT_BUS.register((Object)eventHandler);
        BPBlocks.init();
        BPItems.init();
        proxy.preInitRenderers();
    }

    @Mod.EventHandler
    public void init(FMLInitializationEvent event) {
        proxy.initRenderers();
        TileEntities.init();
        OreDictionarySetup.init();
        GameRegistry.registerWorldGenerator((IWorldGenerator)new WorldGenerationHandler(), (int)0);
        proxy.init();
        BPNetworkHandler.initBP();
        NetworkRegistry.INSTANCE.registerGuiHandler((Object)instance, (IGuiHandler)new GUIHandler());
        CompatibilityUtils.init(event);
    }

    @Mod.EventHandler
    public void postInit(FMLPostInitializationEvent event) {
        CompatibilityUtils.postInit(event);
        Recipes.init();
        AlloyFurnaceRegistry.getInstance().generateRecyclingRecipes();
    }

    @Mod.EventHandler
    public void serverStarting(FMLServerStartingEvent event) {
    }

    static {
        gemMaterial = EnumHelper.addToolMaterial((String)"GEM", (int)2, (int)750, (float)6.0f, (float)2.0f, (int)18);
    }
}

