/*
 * Decompiled with CFR 0.152.
 */
package com.bluepowermod.api.power;

import com.bluepowermod.api.power.BlutricityStorage;
import net.minecraftforge.energy.IEnergyStorage;

public class BlutricityFEStorage
extends BlutricityStorage
implements IEnergyStorage {
    public BlutricityFEStorage(double max) {
        super(max);
    }

    public int receiveEnergy(int maxReceive, boolean simulate) {
        if (!this.canReceive()) {
            return 0;
        }
        int energyReceived = Math.min((int)this.maxEnergy - (int)this.energy, Math.min((int)this.maxEnergy, maxReceive));
        if (!simulate) {
            this.energy += (double)energyReceived;
        }
        return energyReceived;
    }

    public int extractEnergy(int maxExtract, boolean simulate) {
        if (!this.canExtract()) {
            return 0;
        }
        int energyExtracted = Math.min((int)this.energy, Math.min((int)this.maxEnergy, maxExtract));
        if (!simulate) {
            this.energy -= (double)energyExtracted;
        }
        return energyExtracted;
    }

    public int getEnergyStored() {
        return (int)this.energy;
    }

    public int getMaxEnergyStored() {
        return (int)this.maxEnergy;
    }

    public boolean canExtract() {
        return (int)this.energy > 0;
    }

    public boolean canReceive() {
        return (int)this.energy < (int)this.maxEnergy;
    }
}

