/*
 * Decompiled with CFR 0.152.
 */
package com.bluepowermod.api.power;

import com.bluepowermod.api.power.BlutricityStorage;
import com.bluepowermod.api.power.IPowerBase;
import javax.annotation.Nullable;
import net.minecraft.nbt.NBTBase;
import net.minecraft.nbt.NBTTagCompound;
import net.minecraft.util.EnumFacing;
import net.minecraftforge.common.capabilities.Capability;
import net.minecraftforge.common.capabilities.CapabilityInject;
import net.minecraftforge.common.capabilities.CapabilityManager;

public class CapabilityBlutricity {
    @CapabilityInject(value=IPowerBase.class)
    public static Capability<IPowerBase> BLUTRICITY_CAPABILITY = null;

    public static void register() {
        CapabilityManager.INSTANCE.register(IPowerBase.class, new DefaultBlutricityStorage(), BlutricityStorage.class);
    }

    private static class DefaultBlutricityStorage<T extends IPowerBase>
    implements Capability.IStorage<T> {
        private DefaultBlutricityStorage() {
        }

        @Nullable
        public NBTBase writeNBT(Capability<T> capability, T instance, EnumFacing side) {
            NBTTagCompound nbt = new NBTTagCompound();
            nbt.func_74780_a("blutricity", instance.getVoltage());
            return nbt;
        }

        public void readNBT(Capability<T> capability, T instance, EnumFacing side, NBTBase nbt) {
            NBTTagCompound tags = (NBTTagCompound)nbt;
            double energy = tags.func_74769_h("blutricity");
            instance.addEnergy(-(instance.getVoltage() - energy), false);
        }
    }
}

