/*
 * Decompiled with CFR 0.152.
 */
package com.bluepowermod.block;

import com.bluepowermod.BluePower;
import com.bluepowermod.api.block.IAdvancedSilkyRemovable;
import com.bluepowermod.block.BlockBase;
import com.bluepowermod.helper.IOHelper;
import com.bluepowermod.init.BPItems;
import com.bluepowermod.reference.GuiIDs;
import com.bluepowermod.tile.IRotatable;
import com.bluepowermod.tile.TileBase;
import javax.annotation.Nullable;
import net.minecraft.block.Block;
import net.minecraft.block.material.Material;
import net.minecraft.block.state.IBlockState;
import net.minecraft.entity.player.EntityPlayer;
import net.minecraft.item.ItemStack;
import net.minecraft.nbt.NBTTagCompound;
import net.minecraft.tileentity.TileEntity;
import net.minecraft.util.EnumBlockRenderType;
import net.minecraft.util.EnumFacing;
import net.minecraft.util.EnumHand;
import net.minecraft.util.math.BlockPos;
import net.minecraft.world.IBlockAccess;
import net.minecraft.world.World;

public class BlockContainerBase
extends BlockBase
implements IAdvancedSilkyRemovable {
    private GuiIDs guiId = GuiIDs.INVALID;
    private Class<? extends TileBase> tileEntityClass;
    private boolean isRedstoneEmitter;
    private boolean isSilkyRemoving;

    public BlockContainerBase(Material material, Class<? extends TileBase> tileEntityClass) {
        super(material);
        this.field_149758_A = true;
        this.setTileEntityClass(tileEntityClass);
    }

    public BlockContainerBase setGuiId(GuiIDs guiId) {
        this.guiId = guiId;
        return this;
    }

    public BlockContainerBase setTileEntityClass(Class<? extends TileBase> tileEntityClass) {
        this.tileEntityClass = tileEntityClass;
        return this;
    }

    public BlockContainerBase emitsRedstone() {
        this.isRedstoneEmitter = true;
        return this;
    }

    public boolean hasTileEntity(IBlockState state) {
        return true;
    }

    @Nullable
    public TileEntity createTileEntity(World world, IBlockState state) {
        try {
            return this.getTileEntity().newInstance();
        }
        catch (Exception e) {
            return super.createTileEntity(world, state);
        }
    }

    protected Class<? extends TileEntity> getTileEntity() {
        return this.tileEntityClass;
    }

    protected TileBase get(IBlockAccess w, BlockPos pos) {
        TileEntity te = w.func_175625_s(pos);
        if (te == null || !(te instanceof TileBase)) {
            return null;
        }
        return (TileBase)te;
    }

    public void func_189540_a(IBlockState state, World world, BlockPos pos, Block blockIn, BlockPos fromPos) {
        TileBase tileEntity;
        super.func_189540_a(state, world, pos, blockIn, fromPos);
        if (!world.field_72995_K && (tileEntity = this.get((IBlockAccess)world, pos)) != null) {
            tileEntity.onBlockNeighbourChanged();
        }
    }

    public boolean func_149744_f(IBlockState state) {
        return this.isRedstoneEmitter;
    }

    public int func_180656_a(IBlockState blockState, IBlockAccess par1IBlockAccess, BlockPos pos, EnumFacing side) {
        TileBase te = this.get(par1IBlockAccess, pos);
        if (te instanceof TileBase) {
            TileBase tileBase = te;
            return tileBase.getOutputtingRedstone();
        }
        return 0;
    }

    public boolean func_180639_a(World world, BlockPos pos, IBlockState state, EntityPlayer player, EnumHand hand, EnumFacing facing, float hitX, float hitY, float hitZ) {
        if (player.func_70093_af() && !player.func_184586_b(hand).func_190926_b() && player.func_184586_b(hand).func_77973_b() == BPItems.screwdriver) {
            return false;
        }
        if (player.func_70093_af()) {
            return false;
        }
        TileBase entity = this.get((IBlockAccess)world, pos);
        if (entity == null || !(entity instanceof TileBase)) {
            return false;
        }
        if (this.getGuiID() != GuiIDs.INVALID) {
            if (!world.field_72995_K) {
                player.openGui((Object)BluePower.instance, this.getGuiID().ordinal(), world, pos.func_177958_n(), pos.func_177956_o(), pos.func_177952_p());
            }
            return true;
        }
        return false;
    }

    public void func_180663_b(World world, BlockPos pos, IBlockState state) {
        TileBase tile;
        if (!this.isSilkyRemoving && (tile = this.get((IBlockAccess)world, pos)) != null) {
            for (ItemStack stack : tile.getDrops()) {
                IOHelper.spawnItemInWorld(world, stack, (double)pos.func_177958_n() + 0.5, (double)pos.func_177956_o() + 0.5, (double)pos.func_177952_p() + 0.5);
            }
        }
        super.func_180663_b(world, pos, state);
        world.func_175713_t(pos);
    }

    protected boolean canRotateVertical() {
        return true;
    }

    public boolean rotateBlock(World world, BlockPos pos, EnumFacing dir) {
        TileBase te = this.get((IBlockAccess)world, pos);
        if (te instanceof IRotatable) {
            IRotatable rotatable = te;
            if (dir != EnumFacing.UP && dir != EnumFacing.DOWN || this.canRotateVertical()) {
                rotatable.setFacingDirection(dir);
                return true;
            }
        }
        return false;
    }

    public EnumBlockRenderType func_149645_b(IBlockState state) {
        return EnumBlockRenderType.MODEL;
    }

    public GuiIDs getGuiID() {
        return this.guiId;
    }

    @Override
    public boolean preSilkyRemoval(World world, BlockPos pos) {
        this.isSilkyRemoving = true;
        return true;
    }

    @Override
    public void postSilkyRemoval(World world, BlockPos pos) {
        this.isSilkyRemoving = false;
    }

    @Override
    public boolean writeSilkyData(World world, BlockPos pos, NBTTagCompound tag) {
        world.func_175625_s(pos).func_189515_b(tag);
        return false;
    }

    @Override
    public void readSilkyData(World world, BlockPos pos, NBTTagCompound tag) {
        world.func_175625_s(pos).func_145839_a(tag);
    }

    public boolean canConnectRedstone(IBlockState state, IBlockAccess world, BlockPos pos, @Nullable EnumFacing side) {
        TileEntity te = world.func_175625_s(pos);
        return te != null && te instanceof TileBase && ((TileBase)te).canConnectRedstone();
    }
}

