/*
 * Decompiled with CFR 0.152.
 */
package com.bluepowermod.block.gates;

import com.bluepowermod.block.BlockBase;
import com.bluepowermod.reference.Refs;
import com.bluepowermod.util.AABBUtils;
import java.util.HashMap;
import java.util.Map;
import javax.annotation.Nullable;
import net.minecraft.block.Block;
import net.minecraft.block.BlockRedstoneWire;
import net.minecraft.block.material.Material;
import net.minecraft.block.properties.IProperty;
import net.minecraft.block.properties.PropertyBool;
import net.minecraft.block.properties.PropertyDirection;
import net.minecraft.block.properties.PropertyInteger;
import net.minecraft.block.state.BlockStateContainer;
import net.minecraft.block.state.IBlockState;
import net.minecraft.client.renderer.block.model.ModelResourceLocation;
import net.minecraft.entity.EntityLivingBase;
import net.minecraft.item.Item;
import net.minecraft.util.BlockRenderLayer;
import net.minecraft.util.EnumFacing;
import net.minecraft.util.EnumHand;
import net.minecraft.util.math.AxisAlignedBB;
import net.minecraft.util.math.BlockPos;
import net.minecraft.world.IBlockAccess;
import net.minecraft.world.World;
import net.minecraftforge.client.model.ModelLoader;
import net.minecraftforge.fml.relauncher.Side;
import net.minecraftforge.fml.relauncher.SideOnly;

public class BlockGateBase
extends BlockBase {
    private final String name;
    public static final PropertyDirection FACING = PropertyDirection.func_177714_a((String)"facing");
    public static final PropertyInteger ROTATION = PropertyInteger.func_177719_a((String)"rotation", (int)0, (int)3);
    public static final PropertyBool POWERED_FRONT = PropertyBool.func_177716_a((String)"powered_front");
    public static final PropertyBool POWERED_BACK = PropertyBool.func_177716_a((String)"powered_back");
    public static final PropertyBool POWERED_LEFT = PropertyBool.func_177716_a((String)"powered_left");
    public static final PropertyBool POWERED_RIGHT = PropertyBool.func_177716_a((String)"powered_right");

    public BlockGateBase(String name) {
        super(Material.field_151594_q);
        this.name = name;
        this.func_180632_j(this.field_176227_L.func_177621_b().func_177226_a((IProperty)FACING, (Comparable)EnumFacing.UP).func_177226_a((IProperty)POWERED_BACK, (Comparable)Boolean.valueOf(false)).func_177226_a((IProperty)POWERED_FRONT, (Comparable)Boolean.valueOf(false)).func_177226_a((IProperty)POWERED_LEFT, (Comparable)Boolean.valueOf(false)).func_177226_a((IProperty)POWERED_RIGHT, (Comparable)Boolean.valueOf(false)).func_177226_a((IProperty)ROTATION, (Comparable)Integer.valueOf(0)));
        this.func_149663_c(name);
        this.setWIP(true);
    }

    @SideOnly(value=Side.CLIENT)
    public void initModel() {
        ModelLoader.setCustomModelResourceLocation((Item)Item.func_150898_a((Block)this), (int)0, (ModelResourceLocation)new ModelResourceLocation("bluepower:" + this.name, "inventory"));
    }

    public boolean canConnectRedstone(IBlockState state, IBlockAccess world, BlockPos pos, @Nullable EnumFacing side) {
        return state.func_177229_b((IProperty)FACING) != side && ((EnumFacing)state.func_177229_b((IProperty)FACING)).func_176734_d() != side;
    }

    public IBlockState func_176221_a(IBlockState state, IBlockAccess worldIn, BlockPos pos) {
        Map<String, Byte> map = this.getSidePower(worldIn, state, pos);
        return super.func_176221_a(state, worldIn, pos).func_177226_a((IProperty)POWERED_FRONT, (Comparable)Boolean.valueOf(map.get("front") > 0)).func_177226_a((IProperty)POWERED_BACK, (Comparable)Boolean.valueOf(map.get("back") > 0)).func_177226_a((IProperty)POWERED_LEFT, (Comparable)Boolean.valueOf(map.get("left") > 0)).func_177226_a((IProperty)POWERED_RIGHT, (Comparable)Boolean.valueOf(map.get("right") > 0));
    }

    public int func_180656_a(IBlockState blockState, IBlockAccess blockAccess, BlockPos pos, EnumFacing side) {
        if (side == EnumFacing.func_176731_b((int)((Integer)blockState.func_177229_b((IProperty)ROTATION)))) {
            Map<String, Byte> map = this.getSidePower(blockAccess, blockState, pos);
            return map.get("front").byteValue();
        }
        return 0;
    }

    public int func_176211_b(IBlockState blockState, IBlockAccess blockAccess, BlockPos pos, EnumFacing side) {
        if (side == EnumFacing.func_176731_b((int)((Integer)blockState.func_177229_b((IProperty)ROTATION)))) {
            Map<String, Byte> map = this.getSidePower(blockAccess, blockState, pos);
            return map.get("front").byteValue();
        }
        return 0;
    }

    private Map<String, Byte> getSidePower(IBlockAccess worldIn, IBlockState state, BlockPos pos) {
        HashMap<String, Byte> map = new HashMap<String, Byte>();
        EnumFacing side_left = EnumFacing.func_176731_b((int)((Integer)state.func_177229_b((IProperty)ROTATION) == 3 ? 0 : (Integer)state.func_177229_b((IProperty)ROTATION) + 1));
        EnumFacing side_right = side_left.func_176734_d();
        EnumFacing side_back = EnumFacing.func_176731_b((int)((Integer)state.func_177229_b((IProperty)ROTATION)));
        BlockPos pos_left = pos.func_177972_a(side_left);
        BlockPos pos_right = pos.func_177972_a(side_right);
        BlockPos pos_back = pos.func_177972_a(side_back);
        IBlockState state_left = worldIn.func_180495_p(pos_left);
        IBlockState state_right = worldIn.func_180495_p(pos_right);
        IBlockState state_back = worldIn.func_180495_p(pos_back);
        byte left = (byte)state_left.func_185911_a(worldIn, pos_left, side_right);
        byte right = (byte)state_right.func_185911_a(worldIn, pos_right, side_left);
        byte back = (byte)state_back.func_185911_a(worldIn, pos_back, side_back.func_176734_d());
        if (state_left.func_177230_c() instanceof BlockRedstoneWire) {
            left = ((Integer)state_left.func_177229_b((IProperty)BlockRedstoneWire.field_176351_O)).byteValue();
        }
        if (state_right.func_177230_c() instanceof BlockRedstoneWire) {
            right = ((Integer)state_right.func_177229_b((IProperty)BlockRedstoneWire.field_176351_O)).byteValue();
        }
        if (state_back.func_177230_c() instanceof BlockRedstoneWire) {
            back = ((Integer)state_back.func_177229_b((IProperty)BlockRedstoneWire.field_176351_O)).byteValue();
        }
        map.put("left", left);
        map.put("right", right);
        map.put("back", back);
        map.put("front", this.computeRedstone(back, left, right));
        return map;
    }

    public byte computeRedstone(byte back, byte left, byte right) {
        if (left > 0 && right > 0) {
            return (byte)(back > 0 ? 16 : 0);
        }
        return 0;
    }

    public boolean func_149662_c(IBlockState state) {
        return false;
    }

    public BlockRenderLayer func_180664_k() {
        return BlockRenderLayer.CUTOUT;
    }

    public AxisAlignedBB func_185496_a(IBlockState state, IBlockAccess source, BlockPos pos) {
        return AABBUtils.rotate(Refs.GATE_AABB, (EnumFacing)state.func_177229_b((IProperty)FACING));
    }

    protected BlockStateContainer func_180661_e() {
        return new BlockStateContainer((Block)this, new IProperty[]{FACING, ROTATION, POWERED_BACK, POWERED_FRONT, POWERED_LEFT, POWERED_RIGHT});
    }

    public int func_176201_c(IBlockState state) {
        return ((EnumFacing)state.func_177229_b((IProperty)FACING)).func_176745_a();
    }

    public IBlockState func_176203_a(int meta) {
        return this.func_176223_P().func_177226_a((IProperty)FACING, (Comparable)EnumFacing.func_82600_a((int)meta));
    }

    public void func_189540_a(IBlockState state, World world, BlockPos pos, Block blockIn, BlockPos fromPos) {
        super.func_189540_a(state, world, pos, blockIn, fromPos);
        if (!world.func_180495_p(pos.func_177972_a(((EnumFacing)state.func_177229_b((IProperty)FACING)).func_176734_d())).func_185913_b()) {
            world.func_175698_g(pos);
            this.func_176226_b(world, pos, state, 0);
        }
    }

    public IBlockState getStateForPlacement(World world, BlockPos pos, EnumFacing facing, float hitX, float hitY, float hitZ, int meta, EntityLivingBase placer, EnumHand hand) {
        return super.getStateForPlacement(world, pos, facing, hitX, hitY, hitZ, meta, placer, hand).func_177226_a((IProperty)FACING, (Comparable)facing);
    }
}

