/*
 * Decompiled with CFR 0.152.
 */
package com.bluepowermod.block.machine;

import com.bluepowermod.api.misc.MinecraftColor;
import com.bluepowermod.api.wire.redstone.RedwireType;
import com.bluepowermod.block.BlockContainerBase;
import com.bluepowermod.client.render.IBPColoredBlock;
import com.bluepowermod.init.BPCreativeTabs;
import com.bluepowermod.tile.tier1.TileWire;
import com.google.common.collect.Lists;
import com.google.common.collect.Sets;
import java.util.ArrayList;
import java.util.Set;
import javax.annotation.Nullable;
import net.minecraft.block.Block;
import net.minecraft.block.BlockObserver;
import net.minecraft.block.BlockRedstoneDiode;
import net.minecraft.block.BlockRedstoneRepeater;
import net.minecraft.block.material.Material;
import net.minecraft.block.properties.IProperty;
import net.minecraft.block.properties.PropertyBool;
import net.minecraft.block.properties.PropertyDirection;
import net.minecraft.block.state.BlockStateContainer;
import net.minecraft.block.state.IBlockState;
import net.minecraft.init.Blocks;
import net.minecraft.util.EnumFacing;
import net.minecraft.util.math.AxisAlignedBB;
import net.minecraft.util.math.BlockPos;
import net.minecraft.world.IBlockAccess;
import net.minecraft.world.World;

public class BlockAlloyWire
extends BlockContainerBase
implements IBPColoredBlock {
    public static final PropertyDirection FACING = PropertyDirection.func_177714_a((String)"facing");
    public static final PropertyBool POWERED = PropertyBool.func_177716_a((String)"powered");
    public static final PropertyBool CONNECTED_FRONT = PropertyBool.func_177716_a((String)"connected_front");
    public static final PropertyBool CONNECTED_BACK = PropertyBool.func_177716_a((String)"connected_back");
    public static final PropertyBool CONNECTED_LEFT = PropertyBool.func_177716_a((String)"connected_left");
    public static final PropertyBool CONNECTED_RIGHT = PropertyBool.func_177716_a((String)"connected_right");
    private boolean canProvidePower = true;
    final String type;
    private final Set<BlockPos> blocksNeedingUpdate = Sets.newHashSet();

    public BlockAlloyWire(String type) {
        super(Material.field_151594_q, TileWire.class);
        this.type = type;
        this.func_180632_j(this.field_176227_L.func_177621_b().func_177226_a((IProperty)FACING, (Comparable)EnumFacing.UP).func_177226_a((IProperty)CONNECTED_FRONT, (Comparable)Boolean.valueOf(false)).func_177226_a((IProperty)CONNECTED_BACK, (Comparable)Boolean.valueOf(false)).func_177226_a((IProperty)CONNECTED_LEFT, (Comparable)Boolean.valueOf(false)).func_177226_a((IProperty)CONNECTED_RIGHT, (Comparable)Boolean.valueOf(false)).func_177226_a((IProperty)POWERED, (Comparable)Boolean.valueOf(false)));
        this.func_149663_c("wire." + type);
        this.func_149647_a(BPCreativeTabs.wiring);
        this.setRegistryName("bluepower:" + type + "_wire");
    }

    public BlockAlloyWire(String type, Material material) {
        super(material, TileWire.class);
        this.type = type;
    }

    public boolean func_149662_c(IBlockState state) {
        return false;
    }

    public AxisAlignedBB func_185496_a(IBlockState state, IBlockAccess source, BlockPos pos) {
        return new AxisAlignedBB(0.0, 0.0, 0.0, 1.0, 0.1875, 1.0);
    }

    private IBlockState updateSurroundingWire(World worldIn, BlockPos pos, IBlockState state) {
        state = this.calculateCurrentChanges(worldIn, pos, pos, state);
        ArrayList list = Lists.newArrayList(this.blocksNeedingUpdate);
        this.blocksNeedingUpdate.clear();
        for (BlockPos blockpos : list) {
            worldIn.func_175685_c(blockpos, (Block)this, false);
        }
        return state;
    }

    private IBlockState calculateCurrentChanges(World worldIn, BlockPos pos1, BlockPos pos2, IBlockState state) {
        IBlockState iblockstate = state;
        boolean i = (Boolean)state.func_177229_b((IProperty)POWERED);
        this.canProvidePower = false;
        int k = worldIn.func_175687_A(pos1);
        this.canProvidePower = true;
        if (i != k > 0) {
            state = state.func_177226_a((IProperty)POWERED, (Comparable)Boolean.valueOf(k > 0));
            if (worldIn.func_180495_p(pos1) == iblockstate) {
                worldIn.func_180501_a(pos1, state, 2);
            }
            this.blocksNeedingUpdate.add(pos1);
            for (EnumFacing enumfacing1 : EnumFacing.values()) {
                this.blocksNeedingUpdate.add(pos1.func_177972_a(enumfacing1));
            }
        }
        return state;
    }

    private void notifyWireNeighborsOfStateChange(World worldIn, BlockPos pos) {
        if (worldIn.func_180495_p(pos).func_177230_c() == this) {
            worldIn.func_175685_c(pos, (Block)this, false);
            for (EnumFacing enumfacing : EnumFacing.values()) {
                worldIn.func_175685_c(pos.func_177972_a(enumfacing), (Block)this, false);
            }
        }
    }

    public void func_176213_c(World worldIn, BlockPos pos, IBlockState state) {
        if (!worldIn.field_72995_K) {
            this.updateSurroundingWire(worldIn, pos, state);
            for (EnumFacing enumfacing : EnumFacing.Plane.VERTICAL) {
                worldIn.func_175685_c(pos.func_177972_a(enumfacing), (Block)this, false);
            }
            for (EnumFacing enumfacing1 : EnumFacing.Plane.HORIZONTAL) {
                this.notifyWireNeighborsOfStateChange(worldIn, pos.func_177972_a(enumfacing1));
            }
            for (EnumFacing enumfacing2 : EnumFacing.Plane.HORIZONTAL) {
                BlockPos blockpos = pos.func_177972_a(enumfacing2);
                if (worldIn.func_180495_p(blockpos).func_185915_l()) {
                    this.notifyWireNeighborsOfStateChange(worldIn, blockpos.func_177984_a());
                    continue;
                }
                this.notifyWireNeighborsOfStateChange(worldIn, blockpos.func_177977_b());
            }
        }
    }

    @Override
    public void func_180663_b(World worldIn, BlockPos pos, IBlockState state) {
        super.func_180663_b(worldIn, pos, state);
        if (!worldIn.field_72995_K) {
            for (EnumFacing enumfacing : EnumFacing.values()) {
                worldIn.func_175685_c(pos.func_177972_a(enumfacing), (Block)this, false);
            }
            this.updateSurroundingWire(worldIn, pos, state);
            for (EnumFacing enumfacing1 : EnumFacing.Plane.HORIZONTAL) {
                this.notifyWireNeighborsOfStateChange(worldIn, pos.func_177972_a(enumfacing1));
            }
            for (EnumFacing enumfacing2 : EnumFacing.Plane.HORIZONTAL) {
                BlockPos blockpos = pos.func_177972_a(enumfacing2);
                if (worldIn.func_180495_p(blockpos).func_185915_l()) {
                    this.notifyWireNeighborsOfStateChange(worldIn, blockpos.func_177984_a());
                    continue;
                }
                this.notifyWireNeighborsOfStateChange(worldIn, blockpos.func_177977_b());
            }
        }
    }

    @Override
    public void func_189540_a(IBlockState state, World worldIn, BlockPos pos, Block blockIn, BlockPos fromPos) {
        if (!worldIn.field_72995_K) {
            if (this.func_176196_c(worldIn, pos)) {
                this.updateSurroundingWire(worldIn, pos, state);
            } else {
                this.func_176226_b(worldIn, pos, state, 0);
                worldIn.func_175698_g(pos);
            }
        }
    }

    public boolean func_176196_c(World worldIn, BlockPos pos) {
        return worldIn.func_180495_p(pos.func_177977_b()).func_185896_q() || worldIn.func_180495_p(pos.func_177977_b()).func_177230_c() == Blocks.field_150426_aN;
    }

    @Nullable
    public AxisAlignedBB func_180646_a(IBlockState blockState, IBlockAccess worldIn, BlockPos pos) {
        return field_185506_k;
    }

    protected BlockStateContainer func_180661_e() {
        return new BlockStateContainer((Block)this, new IProperty[]{FACING, CONNECTED_FRONT, CONNECTED_BACK, CONNECTED_LEFT, CONNECTED_RIGHT, POWERED});
    }

    public int func_176201_c(IBlockState state) {
        return (Boolean)state.func_177229_b((IProperty)POWERED) != false ? 1 : 0;
    }

    public IBlockState func_176203_a(int meta) {
        return this.func_176223_P().func_177226_a((IProperty)POWERED, (Comparable)Boolean.valueOf(meta > 0));
    }

    @Override
    public boolean func_149744_f(IBlockState state) {
        return this.canProvidePower;
    }

    public IBlockState func_176221_a(IBlockState state, IBlockAccess worldIn, BlockPos pos) {
        Boolean connected_back = (Boolean)state.func_177229_b((IProperty)CONNECTED_BACK);
        Boolean connected_front = (Boolean)state.func_177229_b((IProperty)CONNECTED_FRONT);
        Boolean connected_left = (Boolean)state.func_177229_b((IProperty)CONNECTED_LEFT);
        Boolean connected_right = (Boolean)state.func_177229_b((IProperty)CONNECTED_RIGHT);
        for (EnumFacing face : FACING.func_177700_c()) {
            IBlockState stateof = worldIn.func_180495_p(pos.func_177972_a(face));
            switch (face) {
                case NORTH: {
                    connected_front = stateof.func_177230_c().canConnectRedstone(stateof, worldIn, pos, face);
                    break;
                }
                case SOUTH: {
                    connected_back = stateof.func_177230_c().canConnectRedstone(stateof, worldIn, pos, face);
                    break;
                }
                case WEST: {
                    connected_left = stateof.func_177230_c().canConnectRedstone(stateof, worldIn, pos, face);
                    break;
                }
                case EAST: {
                    connected_right = stateof.func_177230_c().canConnectRedstone(stateof, worldIn, pos, face);
                }
            }
        }
        return super.func_176221_a(state, worldIn, pos).func_177226_a((IProperty)CONNECTED_RIGHT, (Comparable)connected_right).func_177226_a((IProperty)CONNECTED_LEFT, (Comparable)connected_left).func_177226_a((IProperty)CONNECTED_FRONT, (Comparable)connected_front).func_177226_a((IProperty)CONNECTED_BACK, (Comparable)connected_back);
    }

    public int func_176211_b(IBlockState blockState, IBlockAccess blockAccess, BlockPos pos, EnumFacing side) {
        return !this.canProvidePower ? 0 : blockState.func_185911_a(blockAccess, pos, side);
    }

    @Override
    public int func_180656_a(IBlockState blockState, IBlockAccess blockAccess, BlockPos pos, EnumFacing side) {
        TileWire tile = (TileWire)blockAccess.func_175625_s(pos);
        if (!(this.canProvidePower && this.isPowerSourceAt(blockAccess, pos, side) && tile.getIsRedstonePowered())) {
            return 0;
        }
        return (Boolean)blockState.func_177229_b((IProperty)POWERED) != false ? 16 : 0;
    }

    private boolean isPowerSourceAt(IBlockAccess worldIn, BlockPos pos, EnumFacing side) {
        BlockPos blockpos = pos.func_177972_a(side);
        IBlockState iblockstate = worldIn.func_180495_p(blockpos);
        boolean flag = iblockstate.func_185915_l();
        boolean flag1 = worldIn.func_180495_p(pos.func_177984_a()).func_185915_l();
        if (!flag1 && flag && BlockAlloyWire.canConnectUpwardsTo(worldIn, blockpos.func_177984_a())) {
            return true;
        }
        if (BlockAlloyWire.canConnectTo(iblockstate, side, worldIn, pos)) {
            return true;
        }
        if (iblockstate.func_177230_c() == Blocks.field_150416_aS && iblockstate.func_177229_b((IProperty)BlockRedstoneDiode.field_185512_D) == side) {
            return true;
        }
        return !flag && BlockAlloyWire.canConnectUpwardsTo(worldIn, blockpos.func_177977_b());
    }

    protected static boolean canConnectUpwardsTo(IBlockAccess worldIn, BlockPos pos) {
        return BlockAlloyWire.canConnectTo(worldIn.func_180495_p(pos), null, worldIn, pos);
    }

    protected static boolean canConnectTo(IBlockState blockState, @Nullable EnumFacing side, IBlockAccess world, BlockPos pos) {
        if (Blocks.field_150413_aR.func_185547_C(blockState)) {
            EnumFacing enumfacing = (EnumFacing)blockState.func_177229_b((IProperty)BlockRedstoneRepeater.field_185512_D);
            return enumfacing == side || enumfacing.func_176734_d() == side;
        }
        if (Blocks.field_190976_dk == blockState.func_177230_c()) {
            return side == blockState.func_177229_b((IProperty)BlockObserver.field_176387_N);
        }
        return blockState.func_177230_c().canConnectRedstone(blockState, world, pos, side);
    }

    @Override
    public int getColor(IBlockAccess w, BlockPos pos, int tint) {
        return tint == 2 ? (RedwireType.RED_ALLOY.getName().equals(this.type) ? MinecraftColor.RED.getHex() : MinecraftColor.BLUE.getHex()) : -1;
    }

    @Override
    public int getColor(int tint) {
        return tint == 2 ? (RedwireType.RED_ALLOY.getName().equals(this.type) ? MinecraftColor.RED.getHex() : MinecraftColor.BLUE.getHex()) : -1;
    }
}

