/*
 * Decompiled with CFR 0.152.
 */
package com.bluepowermod.block.machine;

import com.bluepowermod.api.misc.MinecraftColor;
import com.bluepowermod.api.wire.redstone.RedwireType;
import com.bluepowermod.block.machine.BlockAlloyWire;
import com.bluepowermod.client.render.ICustomModelBlock;
import com.bluepowermod.init.BPCreativeTabs;
import java.util.Map;
import net.minecraft.block.Block;
import net.minecraft.block.material.Material;
import net.minecraft.block.properties.IProperty;
import net.minecraft.block.properties.PropertyInteger;
import net.minecraft.block.state.BlockStateContainer;
import net.minecraft.block.state.IBlockState;
import net.minecraft.client.renderer.block.model.ModelResourceLocation;
import net.minecraft.client.renderer.block.statemap.IStateMapper;
import net.minecraft.client.renderer.block.statemap.StateMapperBase;
import net.minecraft.item.Item;
import net.minecraft.util.EnumFacing;
import net.minecraft.util.math.AxisAlignedBB;
import net.minecraft.util.math.BlockPos;
import net.minecraft.world.IBlockAccess;
import net.minecraftforge.client.model.ModelLoader;
import net.minecraftforge.fml.relauncher.Side;
import net.minecraftforge.fml.relauncher.SideOnly;

public class BlockInsulatedAlloyWire
extends BlockAlloyWire
implements ICustomModelBlock {
    private final MinecraftColor color;
    public static final PropertyInteger STRAIGHT = PropertyInteger.func_177719_a((String)"straight", (int)0, (int)5);

    public BlockInsulatedAlloyWire(String type, MinecraftColor color) {
        super(type, Material.field_151594_q);
        this.color = color;
        this.func_180632_j(this.field_176227_L.func_177621_b().func_177226_a((IProperty)FACING, (Comparable)EnumFacing.UP).func_177226_a((IProperty)CONNECTED_FRONT, (Comparable)Boolean.valueOf(false)).func_177226_a((IProperty)CONNECTED_BACK, (Comparable)Boolean.valueOf(false)).func_177226_a((IProperty)CONNECTED_LEFT, (Comparable)Boolean.valueOf(false)).func_177226_a((IProperty)CONNECTED_RIGHT, (Comparable)Boolean.valueOf(false)).func_177226_a((IProperty)STRAIGHT, (Comparable)Integer.valueOf(1)).func_177226_a((IProperty)POWERED, (Comparable)Boolean.valueOf(false)));
        this.func_149663_c("wire." + type + "." + color.name().toLowerCase());
        this.func_149647_a(BPCreativeTabs.wiring);
        this.setRegistryName("bluepower:" + type + "_wire." + color.name());
    }

    @Override
    @SideOnly(value=Side.CLIENT)
    public void initModel() {
        StateMapperBase stateMapper = new StateMapperBase(){

            protected ModelResourceLocation func_178132_a(IBlockState iBlockState) {
                return new ModelResourceLocation("bluepower:insulated_alloy_wire", this.func_178131_a((Map)iBlockState.func_177228_b()));
            }
        };
        ModelLoader.setCustomStateMapper((Block)this, (IStateMapper)stateMapper);
        ModelLoader.setCustomModelResourceLocation((Item)Item.func_150898_a((Block)this), (int)0, (ModelResourceLocation)new ModelResourceLocation("bluepower:insulated_alloy_wire", "inventory"));
    }

    @Override
    public AxisAlignedBB func_185496_a(IBlockState state, IBlockAccess source, BlockPos pos) {
        return new AxisAlignedBB(0.0, 0.0, 0.0, 1.0, 0.1875, 1.0);
    }

    @Override
    protected BlockStateContainer func_180661_e() {
        return new BlockStateContainer((Block)this, new IProperty[]{FACING, CONNECTED_FRONT, CONNECTED_BACK, CONNECTED_LEFT, CONNECTED_RIGHT, STRAIGHT, POWERED});
    }

    @Override
    public IBlockState func_176221_a(IBlockState state, IBlockAccess worldIn, BlockPos pos) {
        Boolean connected_back = (Boolean)state.func_177229_b((IProperty)CONNECTED_BACK);
        Boolean connected_front = (Boolean)state.func_177229_b((IProperty)CONNECTED_FRONT);
        Boolean connected_left = (Boolean)state.func_177229_b((IProperty)CONNECTED_LEFT);
        Boolean connected_right = (Boolean)state.func_177229_b((IProperty)CONNECTED_RIGHT);
        int connections = 0;
        int straight = 1;
        for (EnumFacing face : FACING.func_177700_c()) {
            switch (face) {
                case NORTH: {
                    connected_front = worldIn.func_180495_p(pos.func_177972_a(face)).func_177230_c().equals(this);
                    if (!connected_front.booleanValue()) break;
                    ++connections;
                    straight = 4;
                    break;
                }
                case SOUTH: {
                    connected_back = worldIn.func_180495_p(pos.func_177972_a(face)).func_177230_c().equals(this);
                    if (!connected_back.booleanValue()) break;
                    ++connections;
                    straight = 3;
                    break;
                }
                case WEST: {
                    connected_left = worldIn.func_180495_p(pos.func_177972_a(face)).func_177230_c().equals(this);
                    if (!connected_left.booleanValue()) break;
                    ++connections;
                    straight = 5;
                    break;
                }
                case EAST: {
                    connected_right = worldIn.func_180495_p(pos.func_177972_a(face)).func_177230_c().equals(this);
                    if (!connected_right.booleanValue()) break;
                    ++connections;
                    straight = 2;
                }
            }
        }
        if (connections > 1) {
            straight = 0;
        }
        return super.func_176221_a(state, worldIn, pos).func_177226_a((IProperty)CONNECTED_RIGHT, (Comparable)connected_right).func_177226_a((IProperty)CONNECTED_LEFT, (Comparable)connected_left).func_177226_a((IProperty)CONNECTED_FRONT, (Comparable)connected_front).func_177226_a((IProperty)CONNECTED_BACK, (Comparable)connected_back).func_177226_a((IProperty)STRAIGHT, (Comparable)Integer.valueOf(straight));
    }

    @Override
    public int getColor(IBlockAccess world, BlockPos pos, int tintIndex) {
        return tintIndex == 1 ? this.color.getHex() : (tintIndex == 2 ? (RedwireType.RED_ALLOY.getName().equals(this.type) ? MinecraftColor.RED.getHex() : MinecraftColor.BLUE.getHex()) : -1);
    }

    @Override
    public int getColor(int tintIndex) {
        return tintIndex == 1 ? this.color.getHex() : (tintIndex == 2 ? (RedwireType.RED_ALLOY.getName().equals(this.type) ? MinecraftColor.RED.getHex() : MinecraftColor.BLUE.getHex()) : -1);
    }
}

