/*
 * Decompiled with CFR 0.152.
 */
package com.bluepowermod.block.machine;

import com.bluepowermod.api.misc.MinecraftColor;
import com.bluepowermod.block.BlockContainerBase;
import com.bluepowermod.block.machine.BlockLampRGB;
import com.bluepowermod.client.render.IBPColoredBlock;
import com.bluepowermod.client.render.ICustomModelBlock;
import com.bluepowermod.client.render.RenderLamp;
import com.bluepowermod.init.BPCreativeTabs;
import com.bluepowermod.tile.tier1.TileLamp;
import javax.annotation.Nullable;
import net.minecraft.block.Block;
import net.minecraft.block.material.Material;
import net.minecraft.block.properties.IProperty;
import net.minecraft.block.properties.PropertyInteger;
import net.minecraft.block.state.BlockStateContainer;
import net.minecraft.block.state.IBlockState;
import net.minecraft.client.renderer.block.model.ModelResourceLocation;
import net.minecraft.client.renderer.block.statemap.IStateMapper;
import net.minecraft.client.renderer.block.statemap.StateMapperBase;
import net.minecraft.entity.EntityLivingBase;
import net.minecraft.item.Item;
import net.minecraft.tileentity.TileEntity;
import net.minecraft.util.BlockRenderLayer;
import net.minecraft.util.EnumFacing;
import net.minecraft.util.EnumHand;
import net.minecraft.util.math.AxisAlignedBB;
import net.minecraft.util.math.BlockPos;
import net.minecraft.world.IBlockAccess;
import net.minecraft.world.World;
import net.minecraftforge.client.model.ModelLoader;
import net.minecraftforge.fml.relauncher.Side;
import net.minecraftforge.fml.relauncher.SideOnly;

public class BlockLamp
extends BlockContainerBase
implements ICustomModelBlock,
IBPColoredBlock {
    public static final PropertyInteger POWER = PropertyInteger.func_177719_a((String)"power", (int)0, (int)15);
    private final boolean isInverted;
    private final MinecraftColor color;
    private final String name;

    public BlockLamp(String name, boolean isInverted, MinecraftColor color) {
        super(Material.field_151591_t, TileLamp.class);
        this.isInverted = isInverted;
        this.color = color;
        this.name = name;
        this.func_149663_c(name + "." + color.name().toLowerCase() + (isInverted ? ".inverted" : ""));
        this.func_149647_a(BPCreativeTabs.lighting);
        this.func_180632_j(this.field_176227_L.func_177621_b().func_177226_a((IProperty)POWER, (Comparable)Integer.valueOf(isInverted ? 15 : 0)));
        this.setRegistryName(name + (isInverted ? "inverted" : "") + color.name());
    }

    public AxisAlignedBB getSize() {
        return field_185505_j;
    }

    @Override
    @SideOnly(value=Side.CLIENT)
    public void initModel() {
        StateMapperBase stateMapper = new StateMapperBase(){

            protected ModelResourceLocation func_178132_a(IBlockState iBlockState) {
                return new ModelResourceLocation("bluepower:" + BlockLamp.this.name, !BlockLamp.this.isInverted == (Integer)iBlockState.func_177229_b((IProperty)POWER) > 0 ? "powered=true" : "powered=false");
            }
        };
        ModelLoader.setCustomStateMapper((Block)this, (IStateMapper)stateMapper);
        if (!this.isInverted()) {
            ModelLoader.setCustomModelResourceLocation((Item)Item.func_150898_a((Block)this), (int)0, (ModelResourceLocation)new ModelResourceLocation("bluepower:" + this.name, "inventory"));
        } else {
            ModelLoader.setCustomModelResourceLocation((Item)Item.func_150898_a((Block)this), (int)0, (ModelResourceLocation)new ModelResourceLocation("bluepower:" + this.name, "inventory_glow"));
        }
    }

    @Override
    protected TileLamp get(IBlockAccess w, BlockPos pos) {
        TileEntity te = w.func_175625_s(pos);
        if (te == null || !(te instanceof TileLamp)) {
            return null;
        }
        return (TileLamp)te;
    }

    public int getLightValue(IBlockState state, IBlockAccess w, BlockPos pos) {
        return !this.isInverted ? (Integer)state.func_177229_b((IProperty)POWER) : 15 - (Integer)state.func_177229_b((IProperty)POWER);
    }

    @Override
    public int getColor(IBlockAccess w, BlockPos pos, int tint) {
        return this.color.getHex();
    }

    @Override
    public int getColor(int tint) {
        return this.color.getHex();
    }

    public boolean isInverted() {
        return this.isInverted;
    }

    @Override
    public boolean canConnectRedstone(IBlockState state, IBlockAccess world, BlockPos pos, @Nullable EnumFacing side) {
        return !(world.func_180495_p(pos) instanceof BlockLampRGB) && super.canConnectRedstone(state, world, pos, side);
    }

    public boolean canRenderInLayer(IBlockState state, BlockRenderLayer layer) {
        RenderLamp.pass = layer.ordinal();
        return super.canRenderInLayer(state, layer);
    }

    protected BlockStateContainer func_180661_e() {
        return new BlockStateContainer((Block)this, new IProperty[]{POWER});
    }

    public int func_176201_c(IBlockState state) {
        return (Integer)state.func_177229_b((IProperty)POWER);
    }

    public IBlockState func_176203_a(int meta) {
        return this.func_176223_P().func_177226_a((IProperty)POWER, (Comparable)Integer.valueOf(meta));
    }

    public IBlockState getStateForPlacement(World world, BlockPos pos, EnumFacing facing, float hitX, float hitY, float hitZ, int meta, EntityLivingBase placer, EnumHand hand) {
        return super.getStateForPlacement(world, pos, facing, hitX, hitY, hitZ, meta, placer, hand).func_177226_a((IProperty)POWER, (Comparable)Integer.valueOf(world.func_175687_A(pos)));
    }

    @Override
    public void func_189540_a(IBlockState state, World world, BlockPos pos, Block blockIn, BlockPos fromPos) {
        super.func_189540_a(state, world, pos, blockIn, fromPos);
        world.func_175656_a(pos, state.func_177226_a((IProperty)POWER, (Comparable)Integer.valueOf(world.func_175687_A(pos))));
    }
}

