/*
 * Decompiled with CFR 0.152.
 */
package com.bluepowermod.block.machine;

import com.bluepowermod.api.misc.MinecraftColor;
import com.bluepowermod.block.machine.BlockLamp;
import com.bluepowermod.reference.Refs;
import com.bluepowermod.util.AABBUtils;
import net.minecraft.block.Block;
import net.minecraft.block.properties.IProperty;
import net.minecraft.block.properties.PropertyDirection;
import net.minecraft.block.state.BlockStateContainer;
import net.minecraft.block.state.IBlockState;
import net.minecraft.client.renderer.block.model.ModelResourceLocation;
import net.minecraft.client.renderer.block.statemap.IStateMapper;
import net.minecraft.client.renderer.block.statemap.StateMapperBase;
import net.minecraft.entity.EntityLivingBase;
import net.minecraft.item.Item;
import net.minecraft.util.BlockRenderLayer;
import net.minecraft.util.EnumFacing;
import net.minecraft.util.EnumHand;
import net.minecraft.util.math.AxisAlignedBB;
import net.minecraft.util.math.BlockPos;
import net.minecraft.world.IBlockAccess;
import net.minecraft.world.World;
import net.minecraftforge.client.model.ModelLoader;
import net.minecraftforge.fml.relauncher.Side;
import net.minecraftforge.fml.relauncher.SideOnly;

public class BlockLampSurface
extends BlockLamp {
    private final String name;
    private final Boolean isInverted;
    private final AxisAlignedBB size;
    public static final PropertyDirection FACING = PropertyDirection.func_177714_a((String)"facing");

    public BlockLampSurface(String name, boolean isInverted, MinecraftColor color, AxisAlignedBB size) {
        super(name, isInverted, color);
        this.name = name;
        this.isInverted = isInverted;
        this.size = size;
        this.func_180632_j(this.field_176227_L.func_177621_b().func_177226_a((IProperty)POWER, (Comparable)Integer.valueOf(isInverted ? 15 : 0)).func_177226_a((IProperty)FACING, (Comparable)EnumFacing.UP));
    }

    @Override
    @SideOnly(value=Side.CLIENT)
    public void initModel() {
        StateMapperBase stateMapper = new StateMapperBase(){

            protected ModelResourceLocation func_178132_a(IBlockState iBlockState) {
                return new ModelResourceLocation("bluepower:" + BlockLampSurface.this.name, "facing=" + ((EnumFacing)iBlockState.func_177229_b((IProperty)FACING)).func_176610_l() + "," + (BlockLampSurface.this.isInverted == false == (Integer)iBlockState.func_177229_b((IProperty)BlockLamp.POWER) > 0 ? "powered=true" : "powered=false"));
            }
        };
        ModelLoader.setCustomStateMapper((Block)this, (IStateMapper)stateMapper);
        if (!this.isInverted()) {
            ModelLoader.setCustomModelResourceLocation((Item)Item.func_150898_a((Block)this), (int)0, (ModelResourceLocation)new ModelResourceLocation("bluepower:" + this.name, "inventory"));
        } else {
            ModelLoader.setCustomModelResourceLocation((Item)Item.func_150898_a((Block)this), (int)0, (ModelResourceLocation)new ModelResourceLocation("bluepower:" + this.name, "inventory_glow"));
        }
    }

    public boolean func_149662_c(IBlockState state) {
        return false;
    }

    public BlockRenderLayer func_180664_k() {
        return BlockRenderLayer.CUTOUT;
    }

    public AxisAlignedBB func_185496_a(IBlockState state, IBlockAccess source, BlockPos pos) {
        return AABBUtils.rotate(this.size.equals((Object)Refs.CAGELAMP_AABB) ? this.size.func_186662_g(0.0625) : this.size, (EnumFacing)state.func_177229_b((IProperty)FACING));
    }

    @Override
    public AxisAlignedBB getSize() {
        return this.size;
    }

    @Override
    protected BlockStateContainer func_180661_e() {
        return new BlockStateContainer((Block)this, new IProperty[]{POWER, FACING});
    }

    @Override
    public int func_176201_c(IBlockState state) {
        return ((EnumFacing)state.func_177229_b((IProperty)FACING)).func_176745_a();
    }

    @Override
    public IBlockState func_176203_a(int meta) {
        return this.func_176223_P().func_177226_a((IProperty)FACING, (Comparable)EnumFacing.func_82600_a((int)meta));
    }

    @Override
    public void func_189540_a(IBlockState state, World world, BlockPos pos, Block blockIn, BlockPos fromPos) {
        super.func_189540_a(state, world, pos, blockIn, fromPos);
        if (!world.func_180495_p(pos.func_177972_a(((EnumFacing)state.func_177229_b((IProperty)FACING)).func_176734_d())).func_185913_b()) {
            world.func_175698_g(pos);
            this.func_176226_b(world, pos, state, 0);
        }
    }

    @Override
    public IBlockState getStateForPlacement(World world, BlockPos pos, EnumFacing facing, float hitX, float hitY, float hitZ, int meta, EntityLivingBase placer, EnumHand hand) {
        return super.getStateForPlacement(world, pos, facing, hitX, hitY, hitZ, meta, placer, hand).func_177226_a((IProperty)FACING, (Comparable)facing);
    }
}

