/*
 * Decompiled with CFR 0.152.
 */
package com.bluepowermod.block.power;

import com.bluepowermod.api.power.CapabilityBlutricity;
import com.bluepowermod.api.power.IPowerBase;
import com.bluepowermod.block.BlockContainerBase;
import com.bluepowermod.tile.tier3.TileBattery;
import net.minecraft.block.Block;
import net.minecraft.block.material.Material;
import net.minecraft.block.properties.IProperty;
import net.minecraft.block.properties.PropertyInteger;
import net.minecraft.block.state.BlockStateContainer;
import net.minecraft.block.state.IBlockState;
import net.minecraft.entity.player.EntityPlayer;
import net.minecraft.tileentity.TileEntity;
import net.minecraft.util.BlockRenderLayer;
import net.minecraft.util.EnumFacing;
import net.minecraft.util.EnumHand;
import net.minecraft.util.math.BlockPos;
import net.minecraft.util.text.ITextComponent;
import net.minecraft.util.text.TextComponentString;
import net.minecraft.world.IBlockAccess;
import net.minecraft.world.World;

public class BlockBattery
extends BlockContainerBase {
    public static final PropertyInteger LEVEL = PropertyInteger.func_177719_a((String)"level", (int)0, (int)6);

    public BlockBattery() {
        super(Material.field_151573_f, TileBattery.class);
        this.func_149663_c("battery_block");
        this.setRegistryName("bluepower", "battery_block");
        this.func_180632_j(this.field_176227_L.func_177621_b().func_177226_a((IProperty)LEVEL, (Comparable)Integer.valueOf(0)));
    }

    public IBlockState func_176221_a(IBlockState state, IBlockAccess worldIn, BlockPos pos) {
        TileEntity tile = worldIn.func_175625_s(pos);
        if (tile != null && tile.hasCapability(CapabilityBlutricity.BLUTRICITY_CAPABILITY, null)) {
            IPowerBase storage = (IPowerBase)tile.getCapability(CapabilityBlutricity.BLUTRICITY_CAPABILITY, null);
            double voltage = storage.getVoltage();
            int level = (int)(voltage / storage.getMaxVoltage() * 6.0);
            return this.field_176227_L.func_177621_b().func_177226_a((IProperty)LEVEL, (Comparable)Integer.valueOf(level));
        }
        return super.func_176221_a(state, worldIn, pos);
    }

    @Override
    public boolean func_180639_a(World world, BlockPos pos, IBlockState state, EntityPlayer player, EnumHand hand, EnumFacing facing, float hitX, float hitY, float hitZ) {
        TileEntity tile = world.func_175625_s(pos);
        if (tile != null && tile.hasCapability(CapabilityBlutricity.BLUTRICITY_CAPABILITY, null)) {
            IPowerBase storage = (IPowerBase)tile.getCapability(CapabilityBlutricity.BLUTRICITY_CAPABILITY, null);
            if (world.field_72995_K) {
                player.func_145747_a((ITextComponent)new TextComponentString("Voltage: " + storage.getVoltage()));
            }
            return true;
        }
        return super.func_180639_a(world, pos, state, player, hand, facing, hitX, hitY, hitZ);
    }

    public BlockRenderLayer func_180664_k() {
        return BlockRenderLayer.CUTOUT;
    }

    protected BlockStateContainer func_180661_e() {
        return new BlockStateContainer((Block)this, new IProperty[]{LEVEL});
    }

    public int func_176201_c(IBlockState state) {
        return (Integer)state.func_177229_b((IProperty)LEVEL);
    }

    public IBlockState func_176203_a(int meta) {
        return this.field_176227_L.func_177621_b().func_177226_a((IProperty)LEVEL, (Comparable)Integer.valueOf(meta));
    }
}

