/*
 * Decompiled with CFR 0.152.
 */
package com.bluepowermod.block.power;

import com.bluepowermod.block.BlockContainerBase;
import com.bluepowermod.init.BPCreativeTabs;
import com.bluepowermod.init.BPItems;
import com.bluepowermod.reference.GuiIDs;
import com.bluepowermod.tile.tier3.TileEngine;
import javax.annotation.Nullable;
import net.minecraft.block.Block;
import net.minecraft.block.material.Material;
import net.minecraft.block.properties.IProperty;
import net.minecraft.block.properties.PropertyBool;
import net.minecraft.block.properties.PropertyEnum;
import net.minecraft.block.state.BlockStateContainer;
import net.minecraft.block.state.IBlockState;
import net.minecraft.entity.EntityLivingBase;
import net.minecraft.entity.player.EntityPlayer;
import net.minecraft.item.Item;
import net.minecraft.item.ItemStack;
import net.minecraft.util.EnumBlockRenderType;
import net.minecraft.util.EnumFacing;
import net.minecraft.util.EnumHand;
import net.minecraft.util.math.BlockPos;
import net.minecraft.world.IBlockAccess;
import net.minecraft.world.World;

public class BlockEngine
extends BlockContainerBase {
    public static final PropertyBool ACTIVE = PropertyBool.func_177716_a((String)"active");
    public static final PropertyBool GEAR = PropertyBool.func_177716_a((String)"gear");
    public static final PropertyBool GLIDER = PropertyBool.func_177716_a((String)"glider");
    public static final PropertyEnum<EnumFacing> FACING = PropertyEnum.func_177709_a((String)"facing", EnumFacing.class);

    public BlockEngine() {
        super(Material.field_151573_f, TileEngine.class);
        this.func_149647_a(BPCreativeTabs.machines);
        this.func_149663_c("engine");
        this.func_180632_j(this.field_176227_L.func_177621_b().func_177226_a((IProperty)ACTIVE, (Comparable)Boolean.valueOf(false)).func_177226_a((IProperty)GEAR, (Comparable)Boolean.valueOf(false)).func_177226_a((IProperty)GLIDER, (Comparable)Boolean.valueOf(false)).func_177226_a(FACING, (Comparable)EnumFacing.DOWN));
        this.setRegistryName("bluepower", "engine");
    }

    protected BlockStateContainer func_180661_e() {
        return new BlockStateContainer((Block)this, new IProperty[]{ACTIVE, GEAR, GLIDER, FACING});
    }

    public int func_176201_c(IBlockState state) {
        return (Boolean)state.func_177229_b((IProperty)ACTIVE) != false ? 0 : 1;
    }

    public IBlockState func_176203_a(int meta) {
        return this.func_176223_P().func_177226_a((IProperty)ACTIVE, (Comparable)Boolean.valueOf(meta == 1));
    }

    public IBlockState func_176221_a(IBlockState state, IBlockAccess worldIn, BlockPos pos) {
        TileEngine tile = (TileEngine)worldIn.func_175625_s(pos);
        return tile != null && tile.getOrientation() != null ? this.func_176223_P().func_177226_a(FACING, (Comparable)tile.getOrientation()).func_177226_a((IProperty)ACTIVE, (Comparable)Boolean.valueOf(tile.isActive)) : super.func_176221_a(state, worldIn, pos);
    }

    @Override
    public EnumBlockRenderType func_149645_b(IBlockState state) {
        return EnumBlockRenderType.MODEL;
    }

    public boolean func_149686_d(IBlockState state) {
        return false;
    }

    public boolean func_149662_c(IBlockState state) {
        return false;
    }

    @Override
    public boolean rotateBlock(World world, BlockPos pos, EnumFacing dir) {
        if (!world.field_72995_K) {
            TileEngine engine = (TileEngine)world.func_175625_s(pos);
            if (engine != null) {
                engine.setOrientation(EnumFacing.func_82600_a((int)dir.ordinal()));
            }
            world.func_184138_a(pos, world.func_180495_p(pos), world.func_180495_p(pos), 3);
        }
        return super.rotateBlock(world, pos, dir);
    }

    public void func_180633_a(World world, BlockPos pos, IBlockState state, EntityLivingBase player, ItemStack iStack) {
        if (world.func_175625_s(pos) instanceof TileEngine) {
            EnumFacing facing = player.field_70125_A > 45.0f ? EnumFacing.DOWN : (player.field_70125_A < -45.0f ? EnumFacing.UP : player.func_174811_aO().func_176734_d());
            TileEngine tile = (TileEngine)world.func_175625_s(pos);
            if (tile != null) {
                tile.setOrientation(facing);
            }
        }
    }

    @Override
    public boolean func_180639_a(World world, BlockPos pos, IBlockState state, EntityPlayer player, EnumHand hand, EnumFacing efacing, float hitX, float hitY, float hitZ) {
        Item item;
        if (!player.field_71071_by.func_70448_g().func_190926_b() && (item = player.field_71071_by.func_70448_g().func_77973_b()) == BPItems.screwdriver) {
            return true;
        }
        return super.func_180639_a(world, pos, state, player, hand, efacing, hitX, hitY, hitZ);
    }

    @Override
    public GuiIDs getGuiID() {
        return GuiIDs.INVALID;
    }

    @Override
    public boolean canConnectRedstone(IBlockState state, IBlockAccess world, BlockPos pos, @Nullable EnumFacing side) {
        return true;
    }
}

