/*
 * Decompiled with CFR 0.152.
 */
package com.bluepowermod.block.worldgen;

import com.bluepowermod.init.BPBlocks;
import com.bluepowermod.init.BPItems;
import java.util.Random;
import net.minecraft.block.Block;
import net.minecraft.block.BlockCrops;
import net.minecraft.block.IGrowable;
import net.minecraft.block.SoundType;
import net.minecraft.block.state.IBlockState;
import net.minecraft.entity.player.EntityPlayer;
import net.minecraft.init.Blocks;
import net.minecraft.init.Items;
import net.minecraft.item.Item;
import net.minecraft.item.ItemStack;
import net.minecraft.util.EnumBlockRenderType;
import net.minecraft.util.EnumFacing;
import net.minecraft.util.NonNullList;
import net.minecraft.util.math.AxisAlignedBB;
import net.minecraft.util.math.BlockPos;
import net.minecraft.util.math.MathHelper;
import net.minecraft.world.IBlockAccess;
import net.minecraft.world.World;
import net.minecraftforge.common.EnumPlantType;
import net.minecraftforge.common.IPlantable;

public class BlockCrop
extends BlockCrops
implements IGrowable {
    public BlockCrop() {
        this.func_149675_a(true);
        this.func_149711_c(0.0f);
        this.func_149672_a(SoundType.field_185850_c);
        this.func_149649_H();
        this.func_149663_c("flax_crop");
        this.setRegistryName("bluepower:flax_crop");
        BPBlocks.blockList.add((Block)this);
    }

    public String func_149739_a() {
        return String.format("tile.%s:%s", "bluepower", this.getUnwrappedUnlocalizedName(super.func_149739_a()));
    }

    String getUnwrappedUnlocalizedName(String name) {
        return name.substring(name.indexOf(".") + 1);
    }

    public AxisAlignedBB func_185496_a(IBlockState state, IBlockAccess source, BlockPos pos) {
        int l = this.func_185527_x(source.func_180495_p(pos));
        if (l <= 2) {
            return new AxisAlignedBB(0.0, 0.0, 0.0, 1.0, 0.25, 1.0);
        }
        if (l <= 4) {
            return new AxisAlignedBB(0.0, 0.0, 0.0, 1.0, 0.5, 1.0);
        }
        if (l <= 5) {
            return new AxisAlignedBB(0.0, 0.0, 0.0, 1.0, 0.75, 1.0);
        }
        return new AxisAlignedBB(0.0, 0.0, 0.0, 1.0, 1.0, 1.0);
    }

    public void func_176208_a(World world, BlockPos pos, IBlockState state, EntityPlayer player) {
        if (state.func_177230_c() instanceof BlockCrop && this.func_185525_y(state) && world.func_180495_p(pos.func_177977_b()).func_177230_c() == this) {
            world.func_180501_a(pos.func_177977_b(), this.func_185528_e(4), 2);
        }
    }

    public void func_180650_b(World world, BlockPos pos, IBlockState state, Random random) {
        int age = this.func_185527_x(state);
        if (world.func_175699_k(pos) >= 9 && age < 6 && world.func_180495_p(pos.func_177977_b()).func_177230_c().isFertile(world, pos.func_177977_b()) && random.nextInt(10) == 0) {
            world.func_180501_a(pos, this.func_185528_e(age + 1), 2);
            if (age == 5) {
                world.func_180501_a(pos.func_177984_a(), this.func_185528_e(7), 2);
            }
        }
        if (age == 6 && world.func_180495_p(pos.func_177977_b()).func_177230_c().isFertile(world, pos.func_177977_b()) && world.func_180495_p(pos.func_177984_a()).func_177230_c().isAir(world.func_180495_p(pos.func_177984_a()), (IBlockAccess)world, pos.func_177984_a())) {
            world.func_180501_a(pos, this.func_185528_e(4), 2);
        }
        if (age > 6 && world.func_180495_p(pos.func_177977_b()).func_177230_c().isFertile(world, pos.func_177977_b())) {
            world.func_180501_a(pos, this.func_185528_e(4), 2);
        }
        if (age == 7 && world.func_180495_p(pos.func_177977_b()).func_177230_c().isAir(world.func_180495_p(pos.func_177977_b()), (IBlockAccess)world, pos.func_177977_b())) {
            world.func_175698_g(pos);
        }
    }

    public EnumBlockRenderType func_149645_b(IBlockState state) {
        return EnumBlockRenderType.MODEL;
    }

    protected Item func_149866_i() {
        return BPItems.flax_seeds;
    }

    protected Item func_149865_P() {
        return Items.field_151007_F;
    }

    public int func_149745_a(Random random) {
        return 1;
    }

    public boolean func_180670_a(World world, Random rand, BlockPos pos, IBlockState state) {
        return !this.func_185525_y(state);
    }

    public ItemStack func_185473_a(World worldIn, BlockPos pos, IBlockState state) {
        return new ItemStack(this.func_149866_i());
    }

    public void func_176474_b(World world, Random random, BlockPos pos, IBlockState state) {
        int age = this.func_185527_x(state);
        if (world.func_175623_d(pos.func_177984_a()) && age < 7 && !(world.func_180495_p(pos.func_177977_b()).func_177230_c() instanceof BlockCrop)) {
            if ((age += MathHelper.func_76136_a((Random)world.field_73012_v, (int)2, (int)5)) >= 6) {
                world.func_180501_a(pos, this.func_185528_e(6), 2);
                world.func_180501_a(pos.func_177984_a(), this.func_185528_e(7), 2);
            } else {
                world.func_180501_a(pos, this.func_185528_e(age), 2);
            }
        }
    }

    public void getDrops(NonNullList<ItemStack> drops, IBlockAccess world, BlockPos pos, IBlockState state, int fortune) {
        super.getDrops(drops, world, pos, state, fortune);
        if (this.func_185525_y(state)) {
            for (int i = 0; i < 3 + fortune; ++i) {
                if (RANDOM.nextInt(15) > this.func_185527_x(state)) continue;
                drops.add((Object)new ItemStack(this.func_149865_P(), 1, 0));
            }
            if (RANDOM.nextBoolean()) {
                drops.add((Object)new ItemStack(this.func_149866_i(), 1, 0));
            }
        } else if (this.func_185527_x(state) == 6) {
            drops.add((Object)new ItemStack(this.func_149866_i(), 1 + RANDOM.nextInt(2), 0));
        } else {
            drops.add((Object)new ItemStack(this.func_149866_i(), 1, 0));
        }
    }

    public boolean canSustainPlant(IBlockState state, IBlockAccess world, BlockPos pos, EnumFacing direction, IPlantable plantable) {
        return super.func_176196_c((World)world, pos) && world.func_175623_d(pos.func_177984_a());
    }

    public void onNeighborChange(IBlockAccess world, BlockPos pos, BlockPos neighbor) {
        super.onNeighborChange(world, pos, neighbor);
        if (this.func_185527_x(world.func_180495_p(pos)) == 6 && world.func_175623_d(pos.func_177984_a())) {
            ((World)world).func_180501_a(pos, this.func_185528_e(4), 2);
        }
        if (this.func_185527_x(world.func_180495_p(pos)) == 6 && world.func_180495_p(pos.func_177984_a()).func_177230_c() == this && this.func_185527_x(world.func_180495_p(pos.func_177984_a())) == 7 && !this.func_180671_f((World)world, pos, world.func_180495_p(pos))) {
            ((World)world).func_175698_g(pos);
            ((World)world).func_175698_g(pos.func_177984_a());
        }
        this.func_176475_e((World)world, pos, world.func_180495_p(pos));
        this.func_176475_e((World)world, pos.func_177984_a(), world.func_180495_p(pos.func_177984_a()));
    }

    public boolean func_185525_y(IBlockState state) {
        return this.func_185527_x(state) == 7;
    }

    protected void func_176475_e(World world, BlockPos pos, IBlockState state) {
        if (!this.func_180671_f(world, pos, state)) {
            this.func_176226_b(world, pos, state, 0);
            world.func_180501_a(pos, Blocks.field_150350_a.func_176223_P(), 2);
        }
    }

    public boolean func_180671_f(World world, BlockPos pos, IBlockState state) {
        if (world.func_180495_p(pos).func_177230_c() != this) {
            return super.func_180671_f(world, pos, state);
        }
        if (world.func_180495_p(pos.func_177977_b()).func_177230_c().canSustainPlant(world.func_180495_p(pos.func_177977_b()), (IBlockAccess)world, pos.func_177977_b(), EnumFacing.UP, (IPlantable)this)) {
            return true;
        }
        return world.func_180495_p(pos.func_177977_b()).func_177230_c() == this && this.func_185527_x(world.func_180495_p(pos.func_177977_b())) == 6;
    }

    public EnumPlantType getPlantType(IBlockAccess world, BlockPos pos) {
        return EnumPlantType.Crop;
    }
}

