/*
 * Decompiled with CFR 0.152.
 */
package com.bluepowermod.block.worldgen;

import com.bluepowermod.api.misc.MinecraftColor;
import com.bluepowermod.init.BPBlocks;
import com.bluepowermod.init.BPCreativeTabs;
import java.util.List;
import java.util.Random;
import javax.annotation.Nullable;
import net.minecraft.block.Block;
import net.minecraft.block.SoundType;
import net.minecraft.block.material.Material;
import net.minecraft.block.state.IBlockState;
import net.minecraft.client.util.ITooltipFlag;
import net.minecraft.entity.Entity;
import net.minecraft.entity.boss.EntityWither;
import net.minecraft.item.Item;
import net.minecraft.item.ItemStack;
import net.minecraft.util.BlockRenderLayer;
import net.minecraft.util.math.BlockPos;
import net.minecraft.world.Explosion;
import net.minecraft.world.IBlockAccess;
import net.minecraft.world.World;
import net.minecraftforge.fml.relauncher.Side;
import net.minecraftforge.fml.relauncher.SideOnly;

public class BlockStoneOre
extends Block {
    private String name;
    private boolean transparent = false;
    private boolean witherproof = false;
    private String[] tooltip = new String[0];

    public BlockStoneOre(String name) {
        super(Material.field_151576_e);
        this.name = name;
        this.func_149752_b(5.0f);
        this.func_149711_c(4.0f);
        this.setHarvestLevel("pickaxe", 1);
        this.func_149663_c(name);
        this.func_149647_a(BPCreativeTabs.blocks);
        this.func_149672_a(SoundType.field_185851_d);
        this.setRegistryName("bluepower", name);
        BPBlocks.blockList.add(this);
    }

    public Block setToolLevel(int level) {
        super.setHarvestLevel("pickaxe", level);
        return this;
    }

    public String func_149739_a() {
        return String.format("tile.bluepower:" + this.name, new Object[0]);
    }

    public Item func_180660_a(IBlockState state, Random rand, int fortune) {
        return Item.func_150898_a((Block)Block.func_149684_b((String)("bluepower:" + this.name)));
    }

    public boolean isBeaconBase(IBlockAccess worldObj, BlockPos pos, BlockPos beacon) {
        return this == BPBlocks.amethyst_block || this == BPBlocks.ruby_block || this == BPBlocks.malachite_block || this == BPBlocks.sapphire_block || this == BPBlocks.copper_block || this == BPBlocks.zinc_block || this == BPBlocks.silver_block || this == BPBlocks.tungsten_block;
    }

    public BlockStoneOre setTransparent(boolean transparent) {
        this.transparent = transparent;
        return this;
    }

    public boolean isNormalCube(IBlockState state, IBlockAccess world, BlockPos pos) {
        return !this.transparent;
    }

    public boolean func_149721_r(IBlockState state) {
        return !this.transparent;
    }

    public boolean func_149662_c(IBlockState state) {
        return !this.transparent;
    }

    @SideOnly(value=Side.CLIENT)
    public BlockRenderLayer func_180664_k() {
        return this.transparent ? BlockRenderLayer.TRANSLUCENT : BlockRenderLayer.SOLID;
    }

    public int getLightOpacity(IBlockState state, IBlockAccess world, BlockPos pos) {
        return this.transparent ? 0 : super.getLightOpacity(state, world, pos);
    }

    public BlockStoneOre setWitherproof(boolean witherproof) {
        this.witherproof = witherproof;
        return this;
    }

    public void func_190948_a(ItemStack stack, @Nullable World player, List<String> tooltip, ITooltipFlag advanced) {
        super.func_190948_a(stack, player, tooltip, advanced);
        if (this.witherproof) {
            tooltip.add(MinecraftColor.RED.getChatColor() + "Witherproof");
        }
    }

    public boolean canEntityDestroy(IBlockState state, IBlockAccess world, BlockPos pos, Entity entity) {
        if (this.witherproof) {
            return !(entity instanceof EntityWither) && super.canEntityDestroy(state, world, pos, entity);
        }
        return super.canEntityDestroy(state, world, pos, entity);
    }

    public void onBlockExploded(World world, BlockPos pos, Explosion explosion) {
        if (!this.witherproof) {
            super.onBlockExploded(world, pos, explosion);
        }
    }

    public boolean func_149659_a(Explosion explosion) {
        return this.witherproof ? false : super.func_149659_a(explosion);
    }
}

