/*
 * Decompiled with CFR 0.152.
 */
package com.bluepowermod.client.gui;

import com.bluepowermod.client.gui.GuiContainerBaseBP;
import com.bluepowermod.client.gui.widget.BaseWidget;
import com.bluepowermod.client.gui.widget.IGuiWidget;
import com.bluepowermod.client.gui.widget.WidgetMode;
import com.bluepowermod.client.gui.widget.WidgetSidewaysTab;
import com.bluepowermod.client.gui.widget.WidgetTab;
import com.bluepowermod.container.ContainerCircuitDatabaseMain;
import com.bluepowermod.network.BPNetworkHandler;
import com.bluepowermod.network.message.MessageGuiUpdate;
import com.bluepowermod.network.message.MessageUpdateTextfield;
import com.bluepowermod.tile.tier3.TileCircuitDatabase;
import java.io.IOException;
import java.util.List;
import net.minecraft.client.Minecraft;
import net.minecraft.client.gui.GuiTextField;
import net.minecraft.client.resources.I18n;
import net.minecraft.entity.player.EntityPlayer;
import net.minecraft.entity.player.InventoryPlayer;
import net.minecraft.item.ItemStack;
import net.minecraft.util.ResourceLocation;
import org.lwjgl.input.Keyboard;
import org.lwjgl.opengl.GL11;

public class GuiCircuitDatabaseMain
extends GuiContainerBaseBP {
    private final TileCircuitDatabase circuitDatabase;
    private static final ResourceLocation copyTabTexture = new ResourceLocation("bluepower", "textures/gui/circuit_database.png");
    private GuiTextField nameField;
    private WidgetSidewaysTab shareOptionTab;
    private WidgetMode copyButton;

    public GuiCircuitDatabaseMain(InventoryPlayer invPlayer, TileCircuitDatabase circuitDatabase) {
        super(circuitDatabase, new ContainerCircuitDatabaseMain(invPlayer, circuitDatabase), copyTabTexture);
        this.circuitDatabase = circuitDatabase;
        this.field_147000_g = 224;
    }

    @Override
    public void func_73866_w_() {
        super.func_73866_w_();
        WidgetTab widget = new WidgetTab(1, this.field_147003_i - 32, this.field_147009_r + 10, 33, 35, 198, 3, "bluepower:textures/gui/circuit_database.png"){

            @Override
            protected void addTooltip(int curHoveredTab, List<String> curTip, boolean shiftPressed) {
                switch (curHoveredTab) {
                    case 0: {
                        curTip.add("gui.bluepower:circuitDatabase.tab.copyAndShare");
                        break;
                    }
                    case 1: {
                        curTip.add("gui.bluepower:circuitDatabase.tab.private");
                        break;
                    }
                    case 2: {
                        curTip.add("gui.bluepower:circuitDatabase.tab.server");
                        if (!Minecraft.func_71410_x().func_71356_B()) break;
                        curTip.add("gui.bluepower:circuitDatabase.info.serverOnly");
                    }
                }
            }
        };
        widget.value = this.circuitDatabase.clientCurrentTab;
        widget.enabledTabs[2] = !Minecraft.func_71410_x().func_71356_B();
        this.addWidget(widget);
        this.shareOptionTab = new WidgetSidewaysTab(2, this.field_147003_i + 44, this.field_147009_r + 18, 14, 14, 234, 3, "bluepower:textures/gui/circuit_database.png"){

            @Override
            protected void addTooltip(int curHoveredTab, List<String> curTip, boolean shiftPressed) {
                switch (curHoveredTab) {
                    case 0: {
                        curTip.add("gui.bluepower:circuitDatabase.action.cancel");
                        break;
                    }
                    case 1: {
                        curTip.add("gui.bluepower:circuitDatabase.action.savePrivate");
                        if (this.enabledTabs[curHoveredTab]) break;
                        curTip.add("gui.bluepower:circuitDatabase.info.nameTaken");
                        break;
                    }
                    case 2: {
                        curTip.add("gui.bluepower:circuitDatabase.action.saveServer");
                        if (Minecraft.func_71410_x().func_71356_B()) {
                            curTip.add("gui.bluepower:circuitDatabase.info.serverOnly");
                            break;
                        }
                        if (this.enabledTabs[curHoveredTab]) break;
                        curTip.add("gui.bluepower:circuitDatabase.info.nameTaken");
                    }
                }
            }
        };
        this.shareOptionTab.value = this.circuitDatabase.selectedShareOption;
        this.addWidget(this.shareOptionTab);
        this.copyButton = new WidgetMode(3, this.field_147003_i + 80, this.field_147009_r + 48, 176, 37, 1, new String[]{"bluepower:textures/gui/circuit_database.png"}){

            @Override
            public void addTooltip(int x, int y, List<String> curTip, boolean shiftPressed) {
                curTip.add("gui.bluepower:circuitDatabase.action.copy");
            }
        };
        this.addWidget(this.copyButton);
        Keyboard.enableRepeatEvents((boolean)true);
        this.nameField = new GuiTextField(0, this.field_146289_q, this.field_147003_i + 95, this.field_147009_r + 35, 70, this.field_146289_q.field_78288_b);
        this.nameField.func_146185_a(true);
        this.nameField.func_146189_e(true);
        this.nameField.func_146193_g(0xFFFFFF);
        this.nameField.func_146180_a(this.circuitDatabase.getText(1));
    }

    @Override
    protected void func_73864_a(int x, int y, int button) {
        super.func_73864_a(x, y, button);
        this.nameField.func_146192_a(x, y, button);
        if (this.nameField.func_146206_l() && button == 1) {
            this.nameField.func_146180_a("");
            this.circuitDatabase.setText(1, this.nameField.func_146179_b());
            BPNetworkHandler.INSTANCE.sendToServer(new MessageUpdateTextfield(this.circuitDatabase, 0));
        }
    }

    protected void func_73869_a(char par1, int par2) throws IOException {
        if (par2 == 1) {
            super.func_73869_a(par1, par2);
        } else if (this.nameField.func_146201_a(par1, par2)) {
            this.circuitDatabase.setText(1, this.nameField.func_146179_b());
            BPNetworkHandler.INSTANCE.sendToServer(new MessageUpdateTextfield(this.circuitDatabase, 1));
        } else {
            super.func_73869_a(par1, par2);
        }
    }

    @Override
    protected void func_146976_a(float par1, int par2, int par3) {
        super.func_146976_a(par1, par2, par3);
        this.drawString(this.field_147003_i + 95, this.field_147009_r + 25, I18n.func_135052_a((String)"gui.bluepower:circuitDatabase.name", (Object[])new Object[0]), false);
        this.nameField.func_146194_f();
        GL11.glColor4f((float)1.0f, (float)1.0f, (float)1.0f, (float)1.0f);
        this.field_146297_k.field_71446_o.func_110577_a(copyTabTexture);
        int processPercentage = this.circuitDatabase.curCopyProgress * 22 / 20;
        if (processPercentage > 0) {
            this.func_73729_b(this.field_147003_i + 77, this.field_147009_r + 64, 176, 0, processPercentage, 15);
        }
        if ((processPercentage = this.circuitDatabase.curUploadProgress * 22 / 20) > 0) {
            this.func_73729_b(this.field_147003_i + 57, this.field_147009_r + 57 - processPercentage, 176, 37 - processPercentage, 15, processPercentage);
        }
    }

    @Override
    public void actionPerformed(IGuiWidget widget) {
        if (widget.getID() == 1) {
            this.circuitDatabase.clientCurrentTab = ((BaseWidget)widget).value;
        }
        BPNetworkHandler.INSTANCE.sendToServer(new MessageGuiUpdate(this.circuitDatabase, widget.getID(), ((BaseWidget)widget).value));
    }

    @Override
    public void func_73876_c() {
        super.func_73876_c();
        if (!this.nameField.func_146206_l()) {
            this.nameField.func_146180_a(this.circuitDatabase.nameTextField);
        }
        boolean nameDuplicatePrivate = false;
        boolean nameDuplicateServer = false;
        if (!this.circuitDatabase.copyInventory.func_70301_a(0).func_190926_b()) {
            for (ItemStack stack : this.circuitDatabase.stackDatabase.loadItemStacks()) {
                if (!stack.func_82833_r().equals(this.circuitDatabase.copyInventory.func_70301_a(0).func_82833_r())) continue;
                nameDuplicatePrivate = true;
                break;
            }
            for (ItemStack stack : TileCircuitDatabase.serverDatabaseStacks) {
                if (!stack.func_82833_r().equals(this.circuitDatabase.copyInventory.func_70301_a(0).func_82833_r())) continue;
                nameDuplicateServer = true;
                break;
            }
        }
        this.shareOptionTab.enabledTabs[1] = !nameDuplicatePrivate;
        this.shareOptionTab.enabledTabs[2] = !nameDuplicateServer && !Minecraft.func_71410_x().func_71356_B();
        this.copyButton.enabled = !this.circuitDatabase.copyInventory.func_70301_a(0).func_190926_b() && !this.circuitDatabase.copyInventory.func_70301_a(1).func_190926_b() && this.circuitDatabase.copy((EntityPlayer)Minecraft.func_71410_x().field_71439_g, this.circuitDatabase.copyInventory.func_70301_a(0), this.circuitDatabase.copyInventory.func_70301_a(1), true);
    }

    @Override
    protected boolean isInfoStatLeftSided() {
        return false;
    }
}

