/*
 * Decompiled with CFR 0.152.
 */
package com.bluepowermod.client.gui.widget;

import com.bluepowermod.client.gui.widget.BaseWidget;
import java.util.Arrays;
import java.util.List;
import net.minecraft.client.Minecraft;
import net.minecraft.client.gui.Gui;
import org.lwjgl.opengl.GL11;

public class WidgetTab
extends BaseWidget {
    private final int singleTabHeight;
    private final int tabAmount;
    public boolean[] enabledTabs;

    public WidgetTab(int id, int x, int y, int width, int height, int textureU, int tabAmount, String textureLoc) {
        super(id, x, y, width, height * tabAmount, textureU, 0, textureLoc);
        this.singleTabHeight = height;
        this.tabAmount = tabAmount;
        this.enabledTabs = new boolean[tabAmount];
        Arrays.fill(this.enabledTabs, true);
    }

    @Override
    public void onMouseClicked(int mouseX, int mouseY, int button) {
        int clickedTab = (mouseY - this.y) / this.singleTabHeight;
        if (this.enabledTabs[clickedTab]) {
            this.value = clickedTab;
            super.onMouseClicked(mouseX, mouseY, button);
        }
    }

    @Override
    public void render(int mouseX, int mouseY, float partialTick) {
        if (this.textures.length > 0) {
            Minecraft.func_71410_x().func_110434_K().func_110577_a(this.textures[0]);
        }
        for (int i = 0; i < this.tabAmount; ++i) {
            if (i == this.value) {
                GL11.glColor4d((double)1.0, (double)1.0, (double)1.0, (double)1.0);
            } else if (this.enabledTabs[i]) {
                GL11.glColor4d((double)0.6, (double)0.6, (double)0.6, (double)1.0);
            } else {
                GL11.glColor4d((double)0.2, (double)0.2, (double)0.2, (double)1.0);
            }
            Gui.func_146110_a((int)this.x, (int)(this.y + this.singleTabHeight * i), (float)this.getTextureU(), (float)(this.getTextureV() + this.singleTabHeight * i), (int)this.width, (int)this.singleTabHeight, (float)256.0f, (float)256.0f);
        }
    }

    @Override
    public void addTooltip(int mouseX, int mouseY, List<String> curTip, boolean shiftPressed) {
        this.addTooltip((mouseY - this.y) / this.singleTabHeight, curTip, shiftPressed);
    }

    protected void addTooltip(int hoveredTab, List<String> curTip, boolean shiftPressed) {
    }
}

