/*
 * Decompiled with CFR 0.152.
 */
package com.bluepowermod.client.gui.widget;

import com.bluepowermod.api.tube.IPneumaticTube;
import com.bluepowermod.client.gui.widget.GuiAnimatedStat;
import com.bluepowermod.client.gui.widget.IGuiAnimatedStat;
import com.bluepowermod.container.stack.TubeStack;
import java.util.ArrayList;
import java.util.List;
import net.minecraft.client.gui.FontRenderer;
import net.minecraft.client.gui.Gui;
import net.minecraft.client.gui.GuiScreen;
import net.minecraft.item.ItemDye;
import net.minecraft.item.ItemStack;

public class WidgetTabItemLister
extends GuiAnimatedStat {
    private List<TubeStack> showingItems = new ArrayList<TubeStack>();
    private static final int MAX_ITEMS_X = 5;

    public WidgetTabItemLister(GuiScreen gui, int backgroundColor) {
        super(gui, backgroundColor);
    }

    public WidgetTabItemLister(GuiScreen gui, int backgroundColor, ItemStack icon) {
        super(gui, backgroundColor, icon);
    }

    public WidgetTabItemLister(GuiScreen gui, int backgroundColor, String texture) {
        super(gui, backgroundColor, texture);
    }

    public WidgetTabItemLister(GuiScreen gui, String title, ItemStack icon, int xPos, int yPos, int backGroundColor, IGuiAnimatedStat affectingStat, boolean leftSided) {
        super(gui, title, icon, xPos, yPos, backGroundColor, affectingStat, leftSided);
    }

    public WidgetTabItemLister(GuiScreen gui, String title, String texture, int xPos, int yPos, int backGroundColor, IGuiAnimatedStat affectingStat, boolean leftSided) {
        super(gui, title, texture, xPos, yPos, backGroundColor, affectingStat, leftSided);
    }

    public WidgetTabItemLister setItems(List<TubeStack> showingItems) {
        this.showingItems = showingItems;
        return this;
    }

    @Override
    protected int getMaxWidth(FontRenderer fontRenderer) {
        return Math.max(super.getMaxWidth(fontRenderer), Math.min(this.showingItems.size(), 5) * 18 + 18);
    }

    @Override
    protected int getMaxHeight(FontRenderer fontRenderer) {
        if (this.showingItems.size() == 0) {
            return super.getMaxHeight(fontRenderer);
        }
        return Math.max(super.getMaxHeight(fontRenderer), (this.showingItems.size() - 1) / 5 * 18 + 44);
    }

    @Override
    public void render(FontRenderer fontRenderer, float zLevel, float partialTicks) {
        this.setText(this.showingItems.size() == 0 ? "gui.bluepower:tab.stuffed.noItems" : "");
        super.render(fontRenderer, zLevel, partialTicks);
        if (this.isDoneExpanding()) {
            if (this.showingItems.size() > 0) {
                Gui.func_73734_a((int)(this.getBaseX() + 7), (int)(this.getAffectedY() + 16), (int)(this.getBaseX() + Math.min(5, this.showingItems.size()) * 18 + 9), (int)(this.getAffectedY() + 36 + (this.showingItems.size() - 1) / 5 * 18), (int)-5592406);
            }
            for (int i = 0; i < 5; ++i) {
                int j = 0;
                while (i + j * 5 < this.showingItems.size()) {
                    TubeStack stack = this.showingItems.get(i + j * 5);
                    int x = this.getBaseX() + i * 18 + 9;
                    int y = this.getAffectedY() + j * 18 + 18;
                    if (stack.color != IPneumaticTube.TubeColor.NONE) {
                        Gui.func_73734_a((int)x, (int)y, (int)(x + 16), (int)(y + 16), (int)(-16777216 + ItemDye.field_150922_c[stack.color.ordinal()]));
                    }
                    this.renderItem(fontRenderer, x, y, stack.stack);
                    ++j;
                }
            }
        }
    }
}

