/*
 * Decompiled with CFR 0.152.
 */
package com.bluepowermod.client.render;

import net.minecraft.client.Minecraft;
import net.minecraft.client.renderer.BufferBuilder;
import net.minecraft.client.renderer.Tessellator;
import net.minecraft.client.renderer.vertex.DefaultVertexFormats;
import net.minecraft.util.EnumFacing;
import net.minecraft.util.ResourceLocation;
import net.minecraft.util.math.AxisAlignedBB;
import net.minecraftforge.fml.relauncher.Side;
import net.minecraftforge.fml.relauncher.SideOnly;
import org.lwjgl.opengl.GL11;

@SideOnly(value=Side.CLIENT)
public class RenderHelper {
    public static void addVertex(double x, double y, double z) {
        GL11.glVertex3d((double)x, (double)y, (double)z);
    }

    public static void addVertexWithTexture(double x, double y, double z, double tx, double ty) {
        GL11.glTexCoord2d((double)tx, (double)ty);
        GL11.glVertex3d((double)x, (double)y, (double)z);
    }

    public static void renderPointer(double x, double y, double z, double angle) {
        GL11.glPushMatrix();
        GL11.glTranslated((double)x, (double)y, (double)z);
        GL11.glTranslated((double)0.5, (double)0.5, (double)0.5);
        GL11.glRotated((double)(180.0 + 360.0 * -angle), (double)0.0, (double)1.0, (double)0.0);
        GL11.glTranslated((double)-0.5, (double)-0.5, (double)-0.5);
        Minecraft.func_71410_x().field_71446_o.func_110577_a(new ResourceLocation("minecraft:textures/blocks/stone.png"));
        GL11.glBegin((int)7);
        GL11.glNormal3d((double)0.0, (double)-1.0, (double)0.0);
        RenderHelper.addVertexWithTexture(0.5, 0.0, 0.125, 0.5, 0.0625);
        RenderHelper.addVertexWithTexture(0.625, 0.0, 0.5, 0.625, 0.5);
        RenderHelper.addVertexWithTexture(0.5, 0.0, 0.625, 0.5, 0.625);
        RenderHelper.addVertexWithTexture(0.375, 0.0, 0.5, 0.375, 0.5);
        GL11.glNormal3d((double)0.0, (double)1.0, (double)0.0);
        RenderHelper.addVertexWithTexture(0.5, 0.0625, 0.125, 0.5, 0.0625);
        RenderHelper.addVertexWithTexture(0.375, 0.0625, 0.5, 0.375, 0.5);
        RenderHelper.addVertexWithTexture(0.5, 0.0625, 0.625, 0.5, 0.625);
        RenderHelper.addVertexWithTexture(0.625, 0.0625, 0.5, 0.625, 0.5);
        GL11.glNormal3d((double)1.0, (double)0.0, (double)0.0);
        RenderHelper.addVertexWithTexture(0.5, 0.0625, 0.125, 0.5, 0.0625);
        RenderHelper.addVertexWithTexture(0.5, 0.0, 0.125, 0.5, 0.0625);
        RenderHelper.addVertexWithTexture(0.375, 0.0, 0.5, 0.375, 0.5);
        RenderHelper.addVertexWithTexture(0.375, 0.0625, 0.5, 0.375, 0.5);
        RenderHelper.addVertexWithTexture(0.375, 0.0625, 0.5, 0.375, 0.5);
        RenderHelper.addVertexWithTexture(0.375, 0.0, 0.5, 0.375, 0.5);
        RenderHelper.addVertexWithTexture(0.5, 0.0, 0.625, 0.5, 0.625);
        RenderHelper.addVertexWithTexture(0.5, 0.0625, 0.625, 0.5, 0.625);
        GL11.glNormal3d((double)-1.0, (double)0.0, (double)0.0);
        RenderHelper.addVertexWithTexture(0.5, 0.0625, 0.625, 0.5, 0.625);
        RenderHelper.addVertexWithTexture(0.5, 0.0, 0.625, 0.5, 0.625);
        RenderHelper.addVertexWithTexture(0.625, 0.0, 0.5, 0.625, 0.5);
        RenderHelper.addVertexWithTexture(0.625, 0.0625, 0.5, 0.625, 0.5);
        RenderHelper.addVertexWithTexture(0.625, 0.0625, 0.5, 0.625, 0.5);
        RenderHelper.addVertexWithTexture(0.625, 0.0, 0.5, 0.625, 0.5);
        RenderHelper.addVertexWithTexture(0.5, 0.0, 0.125, 0.5, 0.0625);
        RenderHelper.addVertexWithTexture(0.5, 0.0625, 0.125, 0.5, 0.0625);
        GL11.glEnd();
        GL11.glPopMatrix();
    }

    public static void drawColoredCube(AxisAlignedBB vector) {
        GL11.glColor3f((float)1.0f, (float)0.0f, (float)0.0f);
        GL11.glNormal3d((double)0.0, (double)1.0, (double)0.0);
        RenderHelper.addVertex(vector.field_72340_a, vector.field_72337_e, vector.field_72334_f);
        RenderHelper.addVertex(vector.field_72336_d, vector.field_72337_e, vector.field_72334_f);
        RenderHelper.addVertex(vector.field_72336_d, vector.field_72337_e, vector.field_72339_c);
        RenderHelper.addVertex(vector.field_72340_a, vector.field_72337_e, vector.field_72339_c);
        GL11.glColor3f((float)1.0f, (float)1.0f, (float)0.0f);
        GL11.glNormal3d((double)0.0, (double)-1.0, (double)0.0);
        RenderHelper.addVertex(vector.field_72336_d, vector.field_72338_b, vector.field_72334_f);
        RenderHelper.addVertex(vector.field_72340_a, vector.field_72338_b, vector.field_72334_f);
        RenderHelper.addVertex(vector.field_72340_a, vector.field_72338_b, vector.field_72339_c);
        RenderHelper.addVertex(vector.field_72336_d, vector.field_72338_b, vector.field_72339_c);
        GL11.glColor3f((float)0.0f, (float)1.0f, (float)0.0f);
        GL11.glNormal3d((double)-1.0, (double)0.0, (double)0.0);
        RenderHelper.addVertex(vector.field_72340_a, vector.field_72338_b, vector.field_72334_f);
        RenderHelper.addVertex(vector.field_72340_a, vector.field_72337_e, vector.field_72334_f);
        RenderHelper.addVertex(vector.field_72340_a, vector.field_72337_e, vector.field_72339_c);
        RenderHelper.addVertex(vector.field_72340_a, vector.field_72338_b, vector.field_72339_c);
        GL11.glColor3f((float)0.0f, (float)1.0f, (float)1.0f);
        GL11.glNormal3d((double)1.0, (double)0.0, (double)0.0);
        RenderHelper.addVertex(vector.field_72336_d, vector.field_72338_b, vector.field_72339_c);
        RenderHelper.addVertex(vector.field_72336_d, vector.field_72337_e, vector.field_72339_c);
        RenderHelper.addVertex(vector.field_72336_d, vector.field_72337_e, vector.field_72334_f);
        RenderHelper.addVertex(vector.field_72336_d, vector.field_72338_b, vector.field_72334_f);
        GL11.glColor3f((float)0.0f, (float)0.0f, (float)1.0f);
        GL11.glNormal3d((double)0.0, (double)0.0, (double)-1.0);
        RenderHelper.addVertex(vector.field_72340_a, vector.field_72338_b, vector.field_72339_c);
        RenderHelper.addVertex(vector.field_72340_a, vector.field_72337_e, vector.field_72339_c);
        RenderHelper.addVertex(vector.field_72336_d, vector.field_72337_e, vector.field_72339_c);
        RenderHelper.addVertex(vector.field_72336_d, vector.field_72338_b, vector.field_72339_c);
        GL11.glColor3f((float)0.0f, (float)0.0f, (float)0.0f);
        GL11.glNormal3d((double)0.0, (double)0.0, (double)1.0);
        RenderHelper.addVertex(vector.field_72340_a, vector.field_72338_b, vector.field_72334_f);
        RenderHelper.addVertex(vector.field_72336_d, vector.field_72338_b, vector.field_72334_f);
        RenderHelper.addVertex(vector.field_72336_d, vector.field_72337_e, vector.field_72334_f);
        RenderHelper.addVertex(vector.field_72340_a, vector.field_72337_e, vector.field_72334_f);
    }

    public static void drawColoredCube(AxisAlignedBB vector, double r, double g, double b, double a, boolean ... renderFaces) {
        GL11.glColor4d((double)r, (double)g, (double)b, (double)a);
        if (renderFaces.length < 1 || renderFaces[0]) {
            GL11.glNormal3d((double)0.0, (double)1.0, (double)0.0);
            RenderHelper.addVertex(vector.field_72340_a, vector.field_72337_e, vector.field_72334_f);
            RenderHelper.addVertex(vector.field_72336_d, vector.field_72337_e, vector.field_72334_f);
            RenderHelper.addVertex(vector.field_72336_d, vector.field_72337_e, vector.field_72339_c);
            RenderHelper.addVertex(vector.field_72340_a, vector.field_72337_e, vector.field_72339_c);
        }
        if (renderFaces.length < 2 || renderFaces[1]) {
            GL11.glNormal3d((double)0.0, (double)-1.0, (double)0.0);
            RenderHelper.addVertex(vector.field_72336_d, vector.field_72338_b, vector.field_72334_f);
            RenderHelper.addVertex(vector.field_72340_a, vector.field_72338_b, vector.field_72334_f);
            RenderHelper.addVertex(vector.field_72340_a, vector.field_72338_b, vector.field_72339_c);
            RenderHelper.addVertex(vector.field_72336_d, vector.field_72338_b, vector.field_72339_c);
        }
        if (renderFaces.length < 3 || renderFaces[5]) {
            GL11.glNormal3d((double)-1.0, (double)0.0, (double)0.0);
            RenderHelper.addVertex(vector.field_72340_a, vector.field_72338_b, vector.field_72334_f);
            RenderHelper.addVertex(vector.field_72340_a, vector.field_72337_e, vector.field_72334_f);
            RenderHelper.addVertex(vector.field_72340_a, vector.field_72337_e, vector.field_72339_c);
            RenderHelper.addVertex(vector.field_72340_a, vector.field_72338_b, vector.field_72339_c);
        }
        if (renderFaces.length < 4 || renderFaces[4]) {
            GL11.glNormal3d((double)1.0, (double)0.0, (double)0.0);
            RenderHelper.addVertex(vector.field_72336_d, vector.field_72338_b, vector.field_72339_c);
            RenderHelper.addVertex(vector.field_72336_d, vector.field_72337_e, vector.field_72339_c);
            RenderHelper.addVertex(vector.field_72336_d, vector.field_72337_e, vector.field_72334_f);
            RenderHelper.addVertex(vector.field_72336_d, vector.field_72338_b, vector.field_72334_f);
        }
        if (renderFaces.length < 5 || renderFaces[3]) {
            GL11.glNormal3d((double)0.0, (double)0.0, (double)-1.0);
            RenderHelper.addVertex(vector.field_72340_a, vector.field_72338_b, vector.field_72339_c);
            RenderHelper.addVertex(vector.field_72340_a, vector.field_72337_e, vector.field_72339_c);
            RenderHelper.addVertex(vector.field_72336_d, vector.field_72337_e, vector.field_72339_c);
            RenderHelper.addVertex(vector.field_72336_d, vector.field_72338_b, vector.field_72339_c);
        }
        if (renderFaces.length < 6 || renderFaces[2]) {
            GL11.glNormal3d((double)0.0, (double)0.0, (double)1.0);
            RenderHelper.addVertex(vector.field_72340_a, vector.field_72338_b, vector.field_72334_f);
            RenderHelper.addVertex(vector.field_72336_d, vector.field_72338_b, vector.field_72334_f);
            RenderHelper.addVertex(vector.field_72336_d, vector.field_72337_e, vector.field_72334_f);
            RenderHelper.addVertex(vector.field_72340_a, vector.field_72337_e, vector.field_72334_f);
        }
        GL11.glColor4d((double)1.0, (double)1.0, (double)1.0, (double)1.0);
    }

    public static void drawTesselatedTexturedCube(AxisAlignedBB vector) {
        Tessellator t = Tessellator.func_178181_a();
        BufferBuilder b = t.func_178180_c();
        boolean wasTesselating = false;
        try {
            b.func_181668_a(7, DefaultVertexFormats.field_181707_g);
        }
        catch (IllegalStateException e) {
            wasTesselating = true;
        }
        double minU = 0.0;
        double maxU = 1.0;
        double minV = 0.0;
        double maxV = 1.0;
        b.func_181663_c(0.0f, 1.0f, 0.0f);
        b.func_181662_b(vector.field_72340_a, vector.field_72337_e, vector.field_72334_f).func_187315_a(minU, maxV).func_181675_d();
        b.func_181662_b(vector.field_72336_d, vector.field_72337_e, vector.field_72334_f).func_187315_a(minU, minV).func_181675_d();
        b.func_181662_b(vector.field_72336_d, vector.field_72337_e, vector.field_72339_c).func_187315_a(maxU, minV).func_181675_d();
        b.func_181662_b(vector.field_72340_a, vector.field_72337_e, vector.field_72339_c).func_187315_a(maxU, maxV).func_181675_d();
        b.func_181663_c(0.0f, -1.0f, 0.0f);
        b.func_181662_b(vector.field_72336_d, vector.field_72338_b, vector.field_72334_f).func_187315_a(minU, maxV).func_181675_d();
        b.func_181662_b(vector.field_72340_a, vector.field_72338_b, vector.field_72334_f).func_187315_a(minU, minV).func_181675_d();
        b.func_181662_b(vector.field_72340_a, vector.field_72338_b, vector.field_72339_c).func_187315_a(maxU, minV).func_181675_d();
        b.func_181662_b(vector.field_72336_d, vector.field_72338_b, vector.field_72339_c).func_187315_a(maxU, maxV).func_181675_d();
        b.func_181663_c(-1.0f, 0.0f, 0.0f);
        b.func_181662_b(vector.field_72340_a, vector.field_72338_b, vector.field_72334_f).func_187315_a(minU, maxV).func_181675_d();
        b.func_181662_b(vector.field_72340_a, vector.field_72337_e, vector.field_72334_f).func_187315_a(minU, minV).func_181675_d();
        b.func_181662_b(vector.field_72340_a, vector.field_72337_e, vector.field_72339_c).func_187315_a(maxU, minV).func_181675_d();
        b.func_181662_b(vector.field_72340_a, vector.field_72338_b, vector.field_72339_c).func_187315_a(maxU, maxV).func_181675_d();
        b.func_181663_c(1.0f, 0.0f, 0.0f);
        b.func_181662_b(vector.field_72336_d, vector.field_72338_b, vector.field_72339_c).func_187315_a(minU, maxV).func_181675_d();
        b.func_181662_b(vector.field_72336_d, vector.field_72337_e, vector.field_72339_c).func_187315_a(minU, minV).func_181675_d();
        b.func_181662_b(vector.field_72336_d, vector.field_72337_e, vector.field_72334_f).func_187315_a(maxU, minV).func_181675_d();
        b.func_181662_b(vector.field_72336_d, vector.field_72338_b, vector.field_72334_f).func_187315_a(maxU, maxV).func_181675_d();
        b.func_181663_c(0.0f, 0.0f, -1.0f);
        b.func_181662_b(vector.field_72340_a, vector.field_72338_b, vector.field_72339_c).func_187315_a(minU, maxV).func_181675_d();
        b.func_181662_b(vector.field_72340_a, vector.field_72337_e, vector.field_72339_c).func_187315_a(minU, minV).func_181675_d();
        b.func_181662_b(vector.field_72336_d, vector.field_72337_e, vector.field_72339_c).func_187315_a(maxU, minV).func_181675_d();
        b.func_181662_b(vector.field_72336_d, vector.field_72338_b, vector.field_72339_c).func_187315_a(maxU, maxV).func_181675_d();
        b.func_181663_c(0.0f, 0.0f, 1.0f);
        b.func_181662_b(vector.field_72340_a, vector.field_72338_b, vector.field_72334_f).func_187315_a(minU, maxV).func_181675_d();
        b.func_181662_b(vector.field_72336_d, vector.field_72338_b, vector.field_72334_f).func_187315_a(minU, minV).func_181675_d();
        b.func_181662_b(vector.field_72336_d, vector.field_72337_e, vector.field_72334_f).func_187315_a(maxU, minV).func_181675_d();
        b.func_181662_b(vector.field_72340_a, vector.field_72337_e, vector.field_72334_f).func_187315_a(maxU, maxV).func_181675_d();
        if (!wasTesselating) {
            t.func_78381_a();
        }
    }

    public static void rotateRenderMatrix(EnumFacing d) {
        switch (d) {
            case UP: {
                GL11.glRotatef((float)1.0f, (float)0.0f, (float)0.0f, (float)-90.0f);
                break;
            }
            case DOWN: {
                GL11.glRotatef((float)1.0f, (float)0.0f, (float)0.0f, (float)90.0f);
                break;
            }
            case NORTH: {
                GL11.glRotatef((float)1.0f, (float)0.0f, (float)-90.0f, (float)0.0f);
                break;
            }
            case SOUTH: {
                GL11.glRotatef((float)1.0f, (float)0.0f, (float)90.0f, (float)0.0f);
                break;
            }
            case WEST: {
                GL11.glRotatef((float)1.0f, (float)0.0f, (float)0.0f, (float)180.0f);
                break;
            }
            case EAST: {
                GL11.glRotatef((float)1.0f, (float)0.0f, (float)0.0f, (float)0.0f);
                break;
            }
        }
    }
}

