/*
 * Decompiled with CFR 0.152.
 */
package com.bluepowermod.client.render;

import com.bluepowermod.client.render.BPBlockColor;
import com.bluepowermod.client.render.BPItemColor;
import com.bluepowermod.client.render.IBPColoredBlock;
import com.bluepowermod.client.render.IBPColoredItem;
import com.bluepowermod.client.render.ICustomModelBlock;
import com.bluepowermod.client.render.RenderEngine;
import com.bluepowermod.client.render.RenderLamp;
import com.bluepowermod.init.BPBlocks;
import com.bluepowermod.init.BPItems;
import com.bluepowermod.tile.tier1.TileLamp;
import com.bluepowermod.tile.tier3.TileEngine;
import net.minecraft.block.Block;
import net.minecraft.client.Minecraft;
import net.minecraft.client.renderer.block.model.ModelResourceLocation;
import net.minecraft.client.renderer.color.IBlockColor;
import net.minecraft.client.renderer.color.IItemColor;
import net.minecraft.client.renderer.tileentity.TileEntitySpecialRenderer;
import net.minecraft.item.Item;
import net.minecraft.item.ItemStack;
import net.minecraft.util.NonNullList;
import net.minecraft.util.ResourceLocation;
import net.minecraftforge.client.event.ModelRegistryEvent;
import net.minecraftforge.client.model.ModelLoader;
import net.minecraftforge.fml.client.registry.ClientRegistry;
import net.minecraftforge.fml.common.Mod;
import net.minecraftforge.fml.common.eventhandler.SubscribeEvent;
import net.minecraftforge.fml.relauncher.Side;
import net.minecraftforge.fml.relauncher.SideOnly;

@Mod.EventBusSubscriber(value={Side.CLIENT})
@SideOnly(value=Side.CLIENT)
public class Renderers {
    @SubscribeEvent
    public static void registerModels(ModelRegistryEvent evt) {
        for (Item item : BPItems.itemList) {
            if (!(item instanceof IBPColoredItem)) {
                Renderers.registerItemModel(item, 0);
                continue;
            }
            NonNullList subitems = NonNullList.func_191196_a();
            item.func_150895_a(item.func_77640_w(), subitems);
            for (ItemStack subitem : subitems) {
                Renderers.registerItemModel(item, item.getMetadata(subitem));
            }
        }
        for (Block block : BPBlocks.blockList) {
            if (!(block instanceof ICustomModelBlock)) {
                Renderers.registerItemModel(Item.func_150898_a((Block)block), 0);
                continue;
            }
            Renderers.registerBakedModel(block);
        }
    }

    public static void init() {
        ClientRegistry.bindTileEntitySpecialRenderer(TileLamp.class, (TileEntitySpecialRenderer)new RenderLamp());
        ClientRegistry.bindTileEntitySpecialRenderer(TileEngine.class, (TileEntitySpecialRenderer)new RenderEngine());
        for (Item item : BPItems.itemList) {
            if (!(item instanceof IBPColoredItem)) continue;
            Minecraft.func_71410_x().getItemColors().func_186730_a((IItemColor)new BPItemColor(), new Item[]{item});
        }
        for (Block block : BPBlocks.blockList) {
            if (!(block instanceof IBPColoredBlock)) continue;
            Minecraft.func_71410_x().func_184125_al().func_186722_a((IBlockColor)new BPBlockColor(), new Block[]{block});
            Minecraft.func_71410_x().getItemColors().func_186730_a((IItemColor)new BPBlockColor(), new Item[]{Item.func_150898_a((Block)block)});
        }
    }

    public static void registerItemModel(Item item, int metadata) {
        ResourceLocation loc = (ResourceLocation)Item.field_150901_e.func_177774_c((Object)item);
        if (loc != null) {
            if (item instanceof IBPColoredItem && metadata == 16) {
                ModelLoader.setCustomModelResourceLocation((Item)item, (int)metadata, (ModelResourceLocation)new ModelResourceLocation(loc + "_blank"));
            } else {
                ModelLoader.setCustomModelResourceLocation((Item)item, (int)metadata, (ModelResourceLocation)new ModelResourceLocation(loc, "inventory"));
            }
        }
    }

    public static void registerBakedModel(Block block) {
        ((ICustomModelBlock)block).initModel();
    }
}

