/*
 * Decompiled with CFR 0.152.
 */
package com.bluepowermod.compat;

import com.bluepowermod.compat.CompatModule;
import com.bluepowermod.compat.hydcraft.CompatModuleHydCraft;
import com.bluepowermod.compat.ic2.CompatModuleIC2;
import com.bluepowermod.compat.mcmp.CompatModuleMCMP;
import com.bluepowermod.compat.waila.CompatModuleWaila;
import java.util.ArrayList;
import java.util.Collections;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import net.minecraft.item.ItemStack;
import net.minecraftforge.fml.common.Loader;
import net.minecraftforge.fml.common.event.FMLInitializationEvent;
import net.minecraftforge.fml.common.event.FMLPostInitializationEvent;
import net.minecraftforge.fml.common.event.FMLPreInitializationEvent;
import net.minecraftforge.fml.relauncher.Side;
import net.minecraftforge.fml.relauncher.SideOnly;

public class CompatibilityUtils {
    private static Map<String, CompatModule> modules = new HashMap<String, CompatModule>();

    private CompatibilityUtils() {
    }

    public static void registerModule(String modid, Class<? extends CompatModule> module, Class<? extends CompatModule> alternate) {
        CompatibilityUtils.registerModule(modid, module.getName(), alternate == null ? null : alternate.getName());
    }

    public static void registerModule(String modid, String module, String alternate) {
        if (modid == null || modid.trim().isEmpty()) {
            return;
        }
        if (module == null) {
            return;
        }
        if (modules.containsKey(module)) {
            return;
        }
        if (Loader.isModLoaded((String)modid)) {
            try {
                Class<?> c = Class.forName(module);
                if (!CompatModule.class.isAssignableFrom(c)) {
                    return;
                }
                modules.put(modid, (CompatModule)c.newInstance());
                return;
            }
            catch (Exception e) {
                e.printStackTrace();
            }
        }
        if (alternate == null || alternate.trim().isEmpty()) {
            return;
        }
        try {
            Class<?> c2 = Class.forName(alternate);
            if (!CompatModule.class.isAssignableFrom(c2)) {
                return;
            }
            modules.put(modid, (CompatModule)c2.newInstance());
        }
        catch (Exception e) {
            e.printStackTrace();
        }
    }

    public static List<CompatModule> getLoadedModules() {
        return Collections.unmodifiableList(new ArrayList<CompatModule>(modules.values()));
    }

    public static CompatModule getModule(String modid) {
        try {
            return modules.get(modid);
        }
        catch (Exception exception) {
            return null;
        }
    }

    public static void preInit(FMLPreInitializationEvent ev) {
        for (CompatModule m : CompatibilityUtils.getLoadedModules()) {
            m.preInit(ev);
        }
    }

    public static void init(FMLInitializationEvent ev) {
        for (CompatModule m : CompatibilityUtils.getLoadedModules()) {
            m.init(ev);
        }
    }

    public static void postInit(FMLPostInitializationEvent ev) {
        for (CompatModule m : CompatibilityUtils.getLoadedModules()) {
            m.postInit(ev);
        }
    }

    @SideOnly(value=Side.CLIENT)
    public static void registerRenders() {
        for (CompatModule m : CompatibilityUtils.getLoadedModules()) {
            m.registerRenders();
        }
    }

    public static boolean isScrewdriver(ItemStack item) {
        for (CompatModule m : CompatibilityUtils.getLoadedModules()) {
            if (!m.isScrewdriver(item)) continue;
            return true;
        }
        return false;
    }

    static {
        CompatibilityUtils.registerModule("mcmultipart", CompatModuleMCMP.class, null);
        CompatibilityUtils.registerModule("waila", CompatModuleWaila.class, null);
        CompatibilityUtils.registerModule("ic2", CompatModuleIC2.class, null);
        CompatibilityUtils.registerModule("HydCraft", CompatModuleHydCraft.class, null);
    }
}

