/*
 * Decompiled with CFR 0.152.
 */
package com.bluepowermod.container.slot;

import com.bluepowermod.helper.IOHelper;
import com.bluepowermod.tile.tier2.TileCircuitTable;
import java.util.ArrayList;
import java.util.List;
import net.minecraft.entity.player.EntityPlayer;
import net.minecraft.inventory.IInventory;
import net.minecraft.inventory.InventoryCrafting;
import net.minecraft.inventory.SlotCrafting;
import net.minecraft.item.ItemStack;
import net.minecraft.item.crafting.CraftingManager;
import net.minecraft.item.crafting.IRecipe;
import net.minecraft.item.crafting.Ingredient;
import net.minecraft.item.crafting.ShapedRecipes;
import net.minecraftforge.oredict.ShapedOreRecipe;

public class SlotCircuitTableCrafting
extends SlotCrafting {
    private final TileCircuitTable circuitTable;

    public SlotCircuitTableCrafting(EntityPlayer p_i1823_1_, IInventory circuitTable, InventoryCrafting craftSlot, int p_i1823_4_, int p_i1823_5_, int p_i1823_6_) {
        super(p_i1823_1_, craftSlot, circuitTable, p_i1823_4_, p_i1823_5_, p_i1823_6_);
        this.circuitTable = (TileCircuitTable)circuitTable;
    }

    public boolean func_82869_a(EntityPlayer player) {
        ItemStack stack = this.func_75211_c();
        if (!stack.func_190926_b()) {
            return SlotCircuitTableCrafting.canCraft(stack, this.circuitTable);
        }
        return false;
    }

    public static boolean canCraft(ItemStack stack, TileCircuitTable circuitTable) {
        List<ItemStack> requiredItems = SlotCircuitTableCrafting.getCraftingComponents(stack);
        if (requiredItems.size() == 0) {
            return false;
        }
        for (ItemStack requiredItem : requiredItems) {
            ItemStack extractedStack = IOHelper.extract(circuitTable, null, requiredItem, true, true);
            if (!extractedStack.func_190926_b() && extractedStack.func_190916_E() >= requiredItem.func_190916_E()) continue;
            return false;
        }
        return true;
    }

    public void func_75220_a(ItemStack p_75220_1_, ItemStack craftedItem) {
        this.func_75208_c(craftedItem);
        List<ItemStack> requiredItems = SlotCircuitTableCrafting.getCraftingComponents(craftedItem);
        for (ItemStack requiredItem : requiredItems) {
            IOHelper.extract(this.circuitTable, null, requiredItem, true, false, 1);
        }
        ItemStack item = craftedItem.func_77946_l();
        item.func_190920_e(1);
        this.func_75215_d(item);
    }

    private static List<ItemStack> getCraftingComponents(ItemStack gate) {
        ArrayList<ItemStack> requiredItems = new ArrayList<ItemStack>();
        for (IRecipe r : CraftingManager.field_193380_a) {
            ItemStack result = r.func_77571_b();
            if (result.func_190926_b() || !result.func_77969_a(gate)) continue;
            if (r instanceof ShapedOreRecipe) {
                ShapedOreRecipe recipe = (ShapedOreRecipe)r;
                for (Object o : recipe.func_192400_c()) {
                    ItemStack stack;
                    if (o == null) continue;
                    if (o instanceof ItemStack) {
                        stack = (ItemStack)o;
                    } else {
                        List list = (List)o;
                        ItemStack itemStack = stack = list.size() > 0 ? (ItemStack)list.get(0) : ItemStack.field_190927_a;
                    }
                    if (stack.func_190926_b()) continue;
                    boolean needsAdding = true;
                    for (ItemStack listStack : requiredItems) {
                        if (!listStack.func_77969_a(stack)) continue;
                        listStack.func_190920_e(listStack.func_190916_E() + 1);
                        needsAdding = false;
                        break;
                    }
                    if (!needsAdding) continue;
                    requiredItems.add(stack.func_77946_l());
                }
                return requiredItems;
            }
            if (!(r instanceof ShapedRecipes)) continue;
            ShapedRecipes recipe = (ShapedRecipes)r;
            for (Ingredient stack : recipe.field_77574_d) {
                if (stack.func_193365_a()[0].func_190926_b()) continue;
                boolean needsAdding = true;
                for (ItemStack listStack : requiredItems) {
                    if (!listStack.func_77969_a(stack.func_193365_a()[0])) continue;
                    listStack.func_190920_e(listStack.func_190916_E() + 1);
                    needsAdding = false;
                    break;
                }
                if (!needsAdding) continue;
                requiredItems.add(stack.func_193365_a()[0]);
            }
            return requiredItems;
        }
        return new ArrayList<ItemStack>();
    }
}

