/*
 * Decompiled with CFR 0.152.
 */
package com.bluepowermod.event;

import com.bluepowermod.ClientProxy;
import com.bluepowermod.block.gates.BlockGateBase;
import com.bluepowermod.client.gui.GuiCircuitDatabaseSharing;
import com.bluepowermod.container.ContainerSeedBag;
import com.bluepowermod.container.inventory.InventoryItem;
import com.bluepowermod.helper.MathHelper;
import com.bluepowermod.init.BPBlocks;
import com.bluepowermod.init.BPEnchantments;
import com.bluepowermod.init.BPItems;
import com.bluepowermod.item.ItemSeedBag;
import com.bluepowermod.item.ItemSickle;
import com.bluepowermod.network.BPNetworkHandler;
import com.bluepowermod.network.message.MessageServerTickTime;
import java.util.Random;
import net.minecraft.block.Block;
import net.minecraft.block.BlockGrass;
import net.minecraft.block.properties.IProperty;
import net.minecraft.block.state.IBlockState;
import net.minecraft.client.Minecraft;
import net.minecraft.client.renderer.BlockRendererDispatcher;
import net.minecraft.client.renderer.BufferBuilder;
import net.minecraft.client.renderer.GlStateManager;
import net.minecraft.client.renderer.Tessellator;
import net.minecraft.client.renderer.block.model.IBakedModel;
import net.minecraft.client.renderer.vertex.DefaultVertexFormats;
import net.minecraft.client.resources.I18n;
import net.minecraft.enchantment.Enchantment;
import net.minecraft.enchantment.EnchantmentHelper;
import net.minecraft.entity.Entity;
import net.minecraft.entity.EntityLivingBase;
import net.minecraft.entity.boss.EntityDragon;
import net.minecraft.entity.monster.AbstractSkeleton;
import net.minecraft.entity.monster.EntityCreeper;
import net.minecraft.entity.monster.EntityEnderman;
import net.minecraft.entity.monster.EntitySkeleton;
import net.minecraft.entity.monster.EntityZombie;
import net.minecraft.entity.player.EntityPlayer;
import net.minecraft.init.Blocks;
import net.minecraft.init.Enchantments;
import net.minecraft.init.Items;
import net.minecraft.inventory.IInventory;
import net.minecraft.item.Item;
import net.minecraft.item.ItemStack;
import net.minecraft.nbt.NBTTagCompound;
import net.minecraft.tileentity.TileEntityHopper;
import net.minecraft.util.EntityDamageSource;
import net.minecraft.util.EnumHand;
import net.minecraft.util.math.BlockPos;
import net.minecraft.util.math.RayTraceResult;
import net.minecraft.world.IBlockAccess;
import net.minecraftforge.client.event.DrawBlockHighlightEvent;
import net.minecraftforge.event.AnvilUpdateEvent;
import net.minecraftforge.event.entity.living.LivingAttackEvent;
import net.minecraftforge.event.entity.living.LivingDeathEvent;
import net.minecraftforge.event.entity.player.BonemealEvent;
import net.minecraftforge.event.entity.player.EntityItemPickupEvent;
import net.minecraftforge.event.entity.player.ItemTooltipEvent;
import net.minecraftforge.event.entity.player.PlayerInteractEvent;
import net.minecraftforge.fml.common.eventhandler.Event;
import net.minecraftforge.fml.common.eventhandler.SubscribeEvent;
import net.minecraftforge.fml.common.gameevent.PlayerEvent;
import net.minecraftforge.fml.common.gameevent.TickEvent;
import net.minecraftforge.fml.relauncher.Side;
import net.minecraftforge.fml.relauncher.SideOnly;

public class BPEventHandler {
    private boolean isAttacking = false;

    @SubscribeEvent
    public void tick(TickEvent.WorldTickEvent event) {
        if (event.phase == TickEvent.Phase.END && event.world.func_72820_D() % 200L == 0L) {
            double tickTime = (double)MathHelper.mean(event.world.func_73046_m().field_71311_j) * 1.0E-6;
            BPNetworkHandler.INSTANCE.sendToDimension(new MessageServerTickTime(tickTime), event.world.field_73011_w.getDimension());
        }
    }

    @SubscribeEvent
    public void onAnvilEvent(AnvilUpdateEvent event) {
        if (!event.getLeft().func_190926_b() && event.getLeft().func_77973_b() == BPItems.screwdriver && !event.getRight().func_190926_b() && event.getRight().func_77973_b() == Items.field_151134_bR && EnchantmentHelper.func_82781_a((ItemStack)event.getRight()).get(Enchantments.field_185306_r) != null) {
            event.setOutput(new ItemStack(BPItems.silky_screwdriver, 1, event.getLeft().func_77952_i()));
            event.setCost(20);
        }
    }

    @SubscribeEvent
    public void onPlayerInteract(PlayerInteractEvent.LeftClickBlock event) {
        ItemStack heldItem;
        if (event.getEntityPlayer().field_71075_bZ.field_75098_d && !(heldItem = event.getEntityPlayer().func_184586_b(event.getHand())).func_190926_b() && heldItem.func_77973_b() instanceof ItemSickle) {
            heldItem.func_77973_b().func_179218_a(heldItem, event.getWorld(), event.getWorld().func_180495_p(event.getPos()), event.getPos(), (EntityLivingBase)event.getEntityPlayer());
        }
    }

    @SubscribeEvent
    public void itemPickUp(EntityItemPickupEvent event) {
        EntityPlayer player = event.getEntityPlayer();
        ItemStack pickUp = event.getItem().func_92059_d();
        if (!(player.field_71070_bA instanceof ContainerSeedBag)) {
            for (ItemStack is : player.field_71071_by.field_70462_a) {
                ItemStack seedType;
                if (is.func_190926_b() || !(is.func_77973_b() instanceof ItemSeedBag) || (seedType = ItemSeedBag.getSeedType(is)).func_190926_b() || !seedType.func_77969_a(pickUp)) continue;
                InventoryItem inventory = InventoryItem.getItemInventory(is, "Seed Bag", 9);
                inventory.func_174889_b(event.getEntityPlayer());
                ItemStack pickedUp = TileEntityHopper.func_174918_a(null, (IInventory)inventory, (ItemStack)pickUp, null);
                inventory.closeInventory(is);
                if (pickedUp.func_190926_b()) {
                    event.setResult(Event.Result.ALLOW);
                    event.getItem().func_70106_y();
                    return;
                }
                event.getItem().func_92058_a(pickedUp);
            }
        }
    }

    @SubscribeEvent
    public void onEntityAttack(LivingAttackEvent event) {
        EntityDamageSource entitySource;
        if (!this.isAttacking && event.getSource() instanceof EntityDamageSource && (entitySource = (EntityDamageSource)event.getSource()).func_76346_g() instanceof EntityPlayer) {
            EntityPlayer killer = (EntityPlayer)entitySource.func_76346_g();
            if (!killer.field_71071_by.func_70448_g().func_190926_b() && EnchantmentHelper.func_82781_a((ItemStack)killer.field_71071_by.func_70448_g()).containsKey(BPEnchantments.disjunction) && (event.getEntityLiving() instanceof EntityEnderman || event.getEntityLiving() instanceof EntityDragon)) {
                int level = EnchantmentHelper.func_77506_a((Enchantment)BPEnchantments.disjunction, (ItemStack)killer.field_71071_by.func_70448_g());
                this.isAttacking = true;
                event.getEntityLiving().func_70097_a(event.getSource(), event.getAmount() * ((float)level * 0.5f + 1.0f));
                this.isAttacking = false;
                event.setCanceled(true);
            }
        }
    }

    @SubscribeEvent
    public void onEntityDeath(LivingDeathEvent event) {
        EntityDamageSource entitySource;
        if (event.getSource() instanceof EntityDamageSource && (entitySource = (EntityDamageSource)event.getSource()).func_76346_g() instanceof EntityPlayer) {
            EntityPlayer killer = (EntityPlayer)entitySource.func_76346_g();
            if (!killer.field_71071_by.func_70448_g().func_190926_b() && EnchantmentHelper.func_82781_a((ItemStack)killer.field_71071_by.func_70448_g()).containsKey(BPEnchantments.vorpal)) {
                int level = EnchantmentHelper.func_77506_a((Enchantment)BPEnchantments.vorpal, (ItemStack)killer.field_71071_by.func_70448_g());
                if (level == 1) {
                    if (killer.field_70170_p.field_73012_v.nextInt(6) == 1) {
                        this.dropHeads(event);
                    }
                } else if (level == 2 && killer.field_70170_p.field_73012_v.nextInt(3) == 1) {
                    this.dropHeads(event);
                }
            }
        }
    }

    private void dropHeads(LivingDeathEvent event) {
        if (event.getEntityLiving() instanceof EntityCreeper) {
            event.getEntityLiving().func_70099_a(new ItemStack(Items.field_151144_bL, 1, 4), 0.0f);
        }
        if (event.getEntityLiving() instanceof EntityPlayer) {
            ItemStack drop = new ItemStack(Items.field_151144_bL, 1, 3);
            drop.func_77982_d(new NBTTagCompound());
            drop.func_77978_p().func_74778_a("SkullOwner", ((EntityPlayer)event.getEntityLiving()).func_145748_c_().func_150254_d());
            event.getEntityLiving().func_70099_a(drop, 0.0f);
        }
        if (event.getEntityLiving() instanceof AbstractSkeleton) {
            AbstractSkeleton sk = (AbstractSkeleton)event.getEntityLiving();
            if (sk instanceof EntitySkeleton) {
                event.getEntityLiving().func_70099_a(new ItemStack(Items.field_151144_bL, 1, 0), 0.0f);
            } else {
                event.getEntityLiving().func_70099_a(new ItemStack(Items.field_151144_bL, 1, 1), 0.0f);
            }
        }
        if (event.getEntityLiving() instanceof EntityZombie) {
            event.getEntityLiving().func_70099_a(new ItemStack(Items.field_151144_bL, 1, 2), 0.0f);
        }
    }

    @SubscribeEvent
    @SideOnly(value=Side.CLIENT)
    public void onItemTooltip(ItemTooltipEvent event) {
        if (event.getItemStack().func_77942_o() && event.getItemStack().func_77978_p().func_74764_b("tileData") && !event.getItemStack().func_77978_p().func_74767_n("hideSilkyTooltip")) {
            event.getToolTip().add(I18n.func_135052_a((String)"gui.tooltip.hasSilkyData", (Object[])new Object[0]));
        }
        if (ClientProxy.getOpenedGui() instanceof GuiCircuitDatabaseSharing) {
            ItemStack deletingStack = ((GuiCircuitDatabaseSharing)ClientProxy.getOpenedGui()).getCurrentDeletingTemplate();
            if (!deletingStack.func_190926_b() && deletingStack == event.getItemStack()) {
                event.getToolTip().add(I18n.func_135052_a((String)"gui.circuitDatabase.info.sneakClickToConfirmDeleting", (Object[])new Object[0]));
            } else {
                event.getToolTip().add(I18n.func_135052_a((String)"gui.circuitDatabase.info.sneakClickToDelete", (Object[])new Object[0]));
            }
        }
    }

    @SubscribeEvent
    public void onCrafting(PlayerEvent.ItemCraftedEvent event) {
        Item item = event.crafting.func_77973_b();
        if (item == Item.func_150898_a((Block)Blocks.field_150350_a)) {
            return;
        }
    }

    @SubscribeEvent
    public void onBonemealEvent(BonemealEvent event) {
        if (!event.getWorld().field_72995_K && event.getBlock() instanceof BlockGrass) {
            for (int x = event.getPos().func_177958_n() - 2; x < event.getPos().func_177958_n() + 3; ++x) {
                for (int z = event.getPos().func_177952_p() - 2; z < event.getPos().func_177952_p() + 3; ++z) {
                    if (!event.getWorld().func_175623_d(new BlockPos(x, event.getPos().func_177956_o() + 1, z)) || event.getWorld().field_73012_v.nextInt(50) != 1 || !BPBlocks.indigo_flower.func_180671_f(event.getWorld(), event.getPos().func_177982_a(0, 1, 0), event.getWorld().func_180495_p(event.getPos().func_177982_a(0, 1, 0)))) continue;
                    event.getWorld().func_175656_a(event.getPos().func_177982_a(0, 1, 0), BPBlocks.indigo_flower.func_176223_P());
                }
            }
        }
    }

    @SideOnly(value=Side.CLIENT)
    @SubscribeEvent
    public void blockHighlightEvent(DrawBlockHighlightEvent event) {
        RayTraceResult mop = event.getTarget();
        Block block = Block.func_149634_a((Item)event.getPlayer().func_184586_b(EnumHand.MAIN_HAND).func_77973_b());
        if (block instanceof BlockGateBase && mop.field_72313_a == RayTraceResult.Type.BLOCK) {
            BlockPos position = event.getTarget().func_178782_a().func_177972_a(mop.field_178784_b);
            Entity entity = Minecraft.func_71410_x().func_175606_aa();
            double d0 = entity.field_70142_S + (entity.field_70165_t - entity.field_70142_S) * (double)event.getPartialTicks();
            double d1 = entity.field_70137_T + (entity.field_70163_u - entity.field_70137_T) * (double)event.getPartialTicks();
            double d2 = entity.field_70136_U + (entity.field_70161_v - entity.field_70136_U) * (double)event.getPartialTicks();
            Tessellator tessellator = Tessellator.func_178181_a();
            BufferBuilder vertexbuffer = tessellator.func_178180_c();
            vertexbuffer.func_178969_c(-d0, -d1, -d2);
            GlStateManager.func_179094_E();
            GlStateManager.func_179141_d();
            position.func_177963_a(0.5, 0.1, 0.5);
            vertexbuffer.func_181668_a(7, DefaultVertexFormats.field_176600_a);
            BlockRendererDispatcher blockrendererdispatcher = Minecraft.func_71410_x().func_175602_ab();
            IBlockState state = block.func_176223_P().func_177226_a((IProperty)BlockGateBase.FACING, (Comparable)mop.field_178784_b);
            IBakedModel ibakedmodel = blockrendererdispatcher.func_184389_a(state);
            blockrendererdispatcher.func_175019_b().func_187493_a((IBlockAccess)event.getPlayer().field_70170_p, ibakedmodel, state, position, vertexbuffer, false, new Random().nextLong());
            tessellator.func_78381_a();
            GlStateManager.func_179121_F();
            vertexbuffer.func_178969_c(0.0, 0.0, 0.0);
        }
    }
}

