/*
 * Decompiled with CFR 0.152.
 */
package com.bluepowermod.network;

import com.bluepowermod.network.LocatedPacket;
import com.bluepowermod.network.Packet;
import java.io.DataInput;
import java.io.DataOutput;
import java.io.IOException;
import net.minecraft.util.math.BlockPos;
import net.minecraft.world.World;
import net.minecraftforge.fml.common.network.NetworkRegistry;

public abstract class LocatedPacketDouble<T extends LocatedPacket<T>>
extends Packet<T> {
    protected BlockPos pos;

    public LocatedPacketDouble(BlockPos location) {
        this.pos = location;
    }

    public LocatedPacketDouble(double x, double y, double z) {
        this.pos = new BlockPos(x, y, z);
    }

    public LocatedPacketDouble() {
    }

    @Override
    public void read(DataInput buffer) throws IOException {
        this.pos = new BlockPos(buffer.readDouble(), buffer.readDouble(), buffer.readDouble());
    }

    @Override
    public void write(DataOutput buffer) throws IOException {
        buffer.writeDouble(this.pos.func_177958_n());
        buffer.writeDouble(this.pos.func_177956_o());
        buffer.writeDouble(this.pos.func_177952_p());
    }

    public NetworkRegistry.TargetPoint getTargetPoint(World world) {
        return this.getTargetPoint(world, 64.0);
    }

    public NetworkRegistry.TargetPoint getTargetPoint(World world, double updateDistance) {
        return new NetworkRegistry.TargetPoint(world.field_73011_w.getDimension(), (double)this.pos.func_177958_n(), (double)this.pos.func_177956_o(), (double)this.pos.func_177952_p(), updateDistance);
    }
}

