/*
 * Decompiled with CFR 0.152.
 */
package com.bluepowermod.network;

import com.bluepowermod.network.LocatedPacket;
import net.minecraft.entity.player.EntityPlayerMP;
import net.minecraft.world.World;
import net.minecraftforge.fml.common.network.NetworkRegistry;
import net.minecraftforge.fml.common.network.simpleimpl.IMessage;
import net.minecraftforge.fml.common.network.simpleimpl.SimpleNetworkWrapper;
import net.minecraftforge.fml.relauncher.Side;

public class NetworkHandler {
    public final SimpleNetworkWrapper wrapper;
    private int lastDiscriminator = 0;

    public NetworkHandler(String modid) {
        this.wrapper = NetworkRegistry.INSTANCE.newSimpleChannel(modid);
    }

    public static void initQLib() {
    }

    public void registerPacket(Class packetHandler, Class packetType, Side side) {
        this.wrapper.registerMessage(packetHandler, packetType, this.lastDiscriminator++, side);
    }

    public void registerPacket(Class packetType, Side side) {
        this.wrapper.registerMessage(packetType, packetType, this.lastDiscriminator++, side);
    }

    public void sendToAll(IMessage packet) {
        this.wrapper.sendToAll(packet);
    }

    public void sendTo(IMessage packet, EntityPlayerMP player) {
        this.wrapper.sendTo(packet, player);
    }

    public void sendToAllAround(LocatedPacket packet, World world, double range) {
        this.sendToAllAround((IMessage)packet, packet.getTargetPoint(world, range));
    }

    public void sendToAllAround(LocatedPacket packet, World world) {
        this.sendToAllAround((IMessage)packet, packet.getTargetPoint(world, 64.0));
    }

    public void sendToAllAround(IMessage packet, NetworkRegistry.TargetPoint point) {
        this.wrapper.sendToAllAround(packet, point);
    }

    public void sendToDimension(IMessage packet, int dimensionId) {
        this.wrapper.sendToDimension(packet, dimensionId);
    }

    public void sendToServer(IMessage packet) {
        this.wrapper.sendToServer(packet);
    }
}

