/*
 * Decompiled with CFR 0.152.
 */
package com.bluepowermod.network.annotation;

import com.bluepowermod.network.Packet;
import com.bluepowermod.network.annotation.SyncedField;
import io.netty.buffer.ByteBuf;
import java.io.DataInput;
import java.io.DataOutput;
import java.io.IOException;
import net.minecraft.entity.player.EntityPlayer;
import net.minecraft.inventory.Container;
import net.minecraft.item.ItemStack;
import net.minecraft.nbt.NBTTagCompound;
import net.minecraftforge.fluids.FluidStack;
import net.minecraftforge.fml.common.network.ByteBufUtils;

public class PacketCUpdateGui
extends Packet<PacketCUpdateGui> {
    private int syncId;
    private Object value;
    private byte type;

    public PacketCUpdateGui() {
    }

    public PacketCUpdateGui(int syncId, SyncedField syncField) {
        this.syncId = syncId;
        this.value = syncField.getValue();
        this.type = PacketCUpdateGui.getType(syncField);
    }

    public static byte getType(SyncedField syncedField) {
        if (syncedField instanceof SyncedField.SyncedInt) {
            return 0;
        }
        if (syncedField instanceof SyncedField.SyncedFloat) {
            return 1;
        }
        if (syncedField instanceof SyncedField.SyncedDouble) {
            return 2;
        }
        if (syncedField instanceof SyncedField.SyncedBoolean) {
            return 3;
        }
        if (syncedField instanceof SyncedField.SyncedString) {
            return 4;
        }
        if (syncedField instanceof SyncedField.SyncedEnum) {
            return 5;
        }
        if (syncedField instanceof SyncedField.SyncedItemStack) {
            return 6;
        }
        if (syncedField instanceof SyncedField.SyncedFluidTank) {
            return 7;
        }
        throw new IllegalArgumentException("Invalid sync type! " + syncedField);
    }

    public static Object readField(ByteBuf buf, int type) {
        switch (type) {
            case 0: {
                return buf.readInt();
            }
            case 1: {
                return Float.valueOf(buf.readFloat());
            }
            case 2: {
                return buf.readDouble();
            }
            case 3: {
                return buf.readBoolean();
            }
            case 4: {
                return ByteBufUtils.readUTF8String((ByteBuf)buf);
            }
            case 5: {
                return buf.readByte();
            }
            case 6: {
                return ByteBufUtils.readItemStack((ByteBuf)buf);
            }
            case 7: {
                if (!buf.readBoolean()) {
                    return null;
                }
                return FluidStack.loadFluidStackFromNBT((NBTTagCompound)ByteBufUtils.readTag((ByteBuf)buf));
            }
        }
        throw new IllegalArgumentException("Invalid sync type! " + type);
    }

    public static void writeField(ByteBuf buf, Object value, int type) {
        switch (type) {
            case 0: {
                buf.writeInt(((Integer)value).intValue());
                break;
            }
            case 1: {
                buf.writeFloat(((Float)value).floatValue());
                break;
            }
            case 2: {
                buf.writeDouble(((Double)value).doubleValue());
                break;
            }
            case 3: {
                buf.writeBoolean(((Boolean)value).booleanValue());
                break;
            }
            case 4: {
                ByteBufUtils.writeUTF8String((ByteBuf)buf, (String)((String)value));
                break;
            }
            case 5: {
                buf.writeByte((int)((Byte)value).byteValue());
                break;
            }
            case 6: {
                ByteBufUtils.writeItemStack((ByteBuf)buf, (ItemStack)((ItemStack)value));
                break;
            }
            case 7: {
                buf.writeBoolean(value != null);
                if (value == null) break;
                FluidStack stack = (FluidStack)value;
                stack.writeToNBT(ByteBufUtils.readTag((ByteBuf)buf));
            }
        }
    }

    @Override
    public void fromBytes(ByteBuf buf) {
        this.syncId = buf.readInt();
        this.type = buf.readByte();
        this.value = PacketCUpdateGui.readField(buf, this.type);
    }

    @Override
    public void toBytes(ByteBuf buf) {
        buf.writeInt(this.syncId);
        buf.writeByte((int)this.type);
        PacketCUpdateGui.writeField(buf, this.value, this.type);
    }

    @Override
    public void handleClientSide(EntityPlayer player) {
        Container container = player.field_71070_bA;
    }

    @Override
    public void handleServerSide(EntityPlayer player) {
    }

    @Override
    public void read(DataInput buffer) throws IOException {
    }

    @Override
    public void write(DataOutput buffer) throws IOException {
    }
}

