/*
 * Decompiled with CFR 0.152.
 */
package com.bluepowermod.network.message;

import com.bluepowermod.BluePower;
import com.bluepowermod.helper.ItemStackDatabase;
import com.bluepowermod.network.BPNetworkHandler;
import com.bluepowermod.network.LocatedPacket;
import com.bluepowermod.network.message.MessageSendClientServerTemplates;
import com.bluepowermod.reference.GuiIDs;
import com.bluepowermod.tile.tier3.TileCircuitDatabase;
import io.netty.buffer.ByteBuf;
import net.minecraft.entity.player.EntityPlayer;
import net.minecraft.item.ItemStack;
import net.minecraft.tileentity.TileEntity;
import net.minecraftforge.fml.common.network.ByteBufUtils;

public class MessageCircuitDatabaseTemplate
extends LocatedPacket<MessageCircuitDatabaseTemplate> {
    private ItemStack stack;
    private boolean deleting;

    public MessageCircuitDatabaseTemplate() {
    }

    public MessageCircuitDatabaseTemplate(TileCircuitDatabase circuitDatabase, ItemStack stack) {
        super(circuitDatabase.func_174877_v().func_177958_n(), circuitDatabase.func_174877_v().func_177956_o(), circuitDatabase.func_174877_v().func_177952_p());
        this.stack = stack;
    }

    public MessageCircuitDatabaseTemplate(TileCircuitDatabase circuitDatabase, ItemStack stack, boolean deleting) {
        super(circuitDatabase.func_174877_v().func_177958_n(), circuitDatabase.func_174877_v().func_177956_o(), circuitDatabase.func_174877_v().func_177952_p());
        this.stack = stack;
        this.deleting = deleting;
    }

    @Override
    public void toBytes(ByteBuf buf) {
        super.toBytes(buf);
        ByteBufUtils.writeItemStack((ByteBuf)buf, (ItemStack)this.stack);
        buf.writeBoolean(this.deleting);
    }

    @Override
    public void fromBytes(ByteBuf buf) {
        super.fromBytes(buf);
        this.stack = ByteBufUtils.readItemStack((ByteBuf)buf);
        this.deleting = buf.readBoolean();
    }

    @Override
    public void handleClientSide(EntityPlayer player) {
        TileEntity te = player.field_70170_p.func_175625_s(this.pos);
        if (te instanceof TileCircuitDatabase) {
            ((TileCircuitDatabase)te).saveToPrivateLibrary(this.stack);
        }
    }

    @Override
    public void handleServerSide(EntityPlayer player) {
        if (this.deleting) {
            if (TileCircuitDatabase.hasPermissions(player)) {
                ItemStackDatabase stackDatabase = new ItemStackDatabase();
                stackDatabase.deleteStack(this.stack);
                BPNetworkHandler.INSTANCE.sendToAll(new MessageSendClientServerTemplates(stackDatabase.loadItemStacks()));
            }
        } else {
            TileEntity te = player.field_70170_p.func_175625_s(this.pos);
            if (te instanceof TileCircuitDatabase) {
                ((TileCircuitDatabase)te).copyInventory.func_70299_a(0, this.stack);
                player.openGui((Object)BluePower.instance, GuiIDs.CIRCUITDATABASE_MAIN_ID.ordinal(), player.field_70170_p, this.pos.func_177958_n(), this.pos.func_177956_o(), this.pos.func_177952_p());
            }
        }
    }
}

