/*
 * Decompiled with CFR 0.152.
 */
package com.bluepowermod.network.message;

import com.bluepowermod.ClientProxy;
import com.bluepowermod.client.gui.GuiContainerBase;
import com.bluepowermod.container.stack.TubeStack;
import com.bluepowermod.network.LocatedPacket;
import com.bluepowermod.tile.TileMachineBase;
import io.netty.buffer.ByteBuf;
import java.util.ArrayList;
import java.util.List;
import net.minecraft.entity.player.EntityPlayer;
import net.minecraft.nbt.NBTTagCompound;
import net.minecraft.tileentity.TileEntity;
import net.minecraftforge.fml.common.network.ByteBufUtils;

public class MessageSyncMachineBacklog
extends LocatedPacket<MessageSyncMachineBacklog> {
    private List<TubeStack> stacks = new ArrayList<TubeStack>();

    public MessageSyncMachineBacklog() {
    }

    public MessageSyncMachineBacklog(TileMachineBase tile, List<TubeStack> stacks) {
        super(tile.func_174877_v());
        this.stacks = stacks;
    }

    @Override
    public void toBytes(ByteBuf buf) {
        super.toBytes(buf);
        buf.writeInt(this.stacks.size());
        for (TubeStack stack : this.stacks) {
            NBTTagCompound tag = new NBTTagCompound();
            stack.writeToNBT(tag);
            ByteBufUtils.writeTag((ByteBuf)buf, (NBTTagCompound)tag);
        }
    }

    @Override
    public void fromBytes(ByteBuf buf) {
        super.fromBytes(buf);
        int amount = buf.readInt();
        for (int i = 0; i < amount; ++i) {
            this.stacks.add(TubeStack.loadFromNBT(ByteBufUtils.readTag((ByteBuf)buf)));
        }
    }

    @Override
    public void handleClientSide(EntityPlayer player) {
        TileEntity te = player.field_70170_p.func_175625_s(this.pos);
        if (te instanceof TileMachineBase) {
            ((TileMachineBase)te).setBacklog(this.stacks);
            GuiContainerBase gui = (GuiContainerBase)ClientProxy.getOpenedGui();
            if (gui != null) {
                gui.redraw();
            }
        }
    }

    @Override
    public void handleServerSide(EntityPlayer player) {
    }
}

