/*
 * Decompiled with CFR 0.152.
 */
package com.bluepowermod.recipe;

import com.bluepowermod.BluePower;
import com.bluepowermod.api.recipe.IAlloyFurnaceRecipe;
import com.bluepowermod.api.recipe.IAlloyFurnaceRegistry;
import com.bluepowermod.init.Config;
import com.bluepowermod.util.ItemStackUtils;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collections;
import java.util.HashMap;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import net.minecraft.block.Block;
import net.minecraft.item.Item;
import net.minecraft.item.ItemStack;
import net.minecraft.item.crafting.CraftingManager;
import net.minecraft.item.crafting.IRecipe;
import net.minecraft.item.crafting.Ingredient;
import net.minecraft.item.crafting.ShapedRecipes;
import net.minecraft.item.crafting.ShapelessRecipes;
import net.minecraft.util.NonNullList;
import net.minecraftforge.fml.common.Loader;
import net.minecraftforge.fml.common.ModContainer;
import net.minecraftforge.oredict.ShapedOreRecipe;
import net.minecraftforge.oredict.ShapelessOreRecipe;

public class AlloyFurnaceRegistry
implements IAlloyFurnaceRegistry {
    private static AlloyFurnaceRegistry INSTANCE = new AlloyFurnaceRegistry();
    private final List<IAlloyFurnaceRecipe> alloyFurnaceRecipes = new ArrayList<IAlloyFurnaceRecipe>();
    private final List<ItemStack> bufferedRecyclingItems = new ArrayList<ItemStack>();
    private final Map<ItemStack, ItemStack> moltenDownMap = new HashMap<ItemStack, ItemStack>();
    private final List<String> blacklist = new ArrayList<String>();

    private AlloyFurnaceRegistry() {
    }

    public static AlloyFurnaceRegistry getInstance() {
        return INSTANCE;
    }

    @Override
    public void addRecipe(IAlloyFurnaceRecipe recipe) {
        this.alloyFurnaceRecipes.add(recipe);
    }

    public List<IAlloyFurnaceRecipe> getAllRecipes() {
        return this.alloyFurnaceRecipes;
    }

    @Override
    public void addRecipe(ItemStack craftingResult, Object ... requiredItems) {
        if (craftingResult == null || craftingResult.func_77973_b() == null) {
            throw new NullPointerException("Can't register an Alloy Furnace recipe with a null output stack or item");
        }
        if (craftingResult.func_190926_b()) {
            throw new NullPointerException("Can't register an Alloy Furnace recipe with a invalid output stack or item");
        }
        NonNullList requiredStacks = NonNullList.func_191197_a((int)requiredItems.length, (Object)ItemStack.field_190927_a);
        for (int i = 0; i < requiredStacks.size(); ++i) {
            if (requiredItems[i] instanceof ItemStack) {
                requiredStacks.set(i, (Object)((ItemStack)requiredItems[i]));
                continue;
            }
            if (requiredItems[i] instanceof Item) {
                requiredStacks.set(i, (Object)new ItemStack((Item)requiredItems[i], 1, Short.MAX_VALUE));
                continue;
            }
            if (requiredItems[i] instanceof Block) {
                requiredStacks.set(i, (Object)new ItemStack(Item.func_150898_a((Block)((Block)requiredItems[i])), 1, Short.MAX_VALUE));
                continue;
            }
            throw new IllegalArgumentException("Alloy Furnace crafting ingredients can only be ItemStack, Item or Block!");
        }
        this.addRecipe(new StandardAlloyFurnaceRecipe(craftingResult, requiredStacks));
    }

    @Override
    public void addRecyclingRecipe(ItemStack recycledItem, String ... blacklist) {
        if (recycledItem.func_190926_b()) {
            throw new NullPointerException("Recycled item can't be null!");
        }
        this.bufferedRecyclingItems.add(recycledItem);
        if (blacklist.length > 0) {
            ModContainer mc = Loader.instance().activeModContainer();
            BluePower.log.info((mc != null ? mc.getName() : "Unknown mod") + " added to the Alloy Furnace recycling blacklist: " + Arrays.toString(blacklist));
            Collections.addAll(this.blacklist, blacklist);
        }
    }

    @Override
    public void addRecyclingRecipe(ItemStack recycledItem, ItemStack moltenDownItem, String ... blacklist) {
        if (moltenDownItem.func_190926_b()) {
            throw new NullPointerException("Molten down item can't be null!");
        }
        this.addRecyclingRecipe(recycledItem, blacklist);
        this.moltenDownMap.put(recycledItem, moltenDownItem);
    }

    public void generateRecyclingRecipes() {
        Collections.addAll(this.blacklist, Config.alloyFurnaceBlacklist);
        ArrayList<Item> blacklist = new ArrayList<Item>();
        for (String configString : this.blacklist) {
            Item item = Item.func_111206_d((String)configString);
            if (item != null) {
                blacklist.add(item);
                continue;
            }
            BluePower.log.info("Config entry \"" + configString + "\" not an existing item/block name! Will not be added to the blacklist");
        }
        ArrayList<ItemStack> registeredRecycledItems = new ArrayList<ItemStack>();
        ArrayList<ItemStack> registeredResultItems = new ArrayList<ItemStack>();
        for (IRecipe recipe : CraftingManager.field_193380_a) {
            int recyclingAmount = 0;
            ItemStack currentlyRecycledInto = ItemStack.field_190927_a;
            for (ItemStack recyclingItem : this.bufferedRecyclingItems) {
                try {
                    ItemStack moltenDownItem;
                    ShapelessRecipes shapeless;
                    ItemStack moltenDownItem2;
                    if (recipe instanceof ShapedRecipes) {
                        ShapedRecipes shaped = (ShapedRecipes)recipe;
                        if (shaped.func_192400_c().isEmpty()) continue;
                        for (Ingredient input : shaped.func_192400_c()) {
                            if (!input.test((Object)recyclingItem)) continue;
                            moltenDownItem2 = this.getRecyclingStack(recyclingItem);
                            if (!currentlyRecycledInto.func_190926_b() && !ItemStackUtils.isItemFuzzyEqual(currentlyRecycledInto, moltenDownItem2)) continue;
                            currentlyRecycledInto = moltenDownItem2;
                            recyclingAmount += moltenDownItem2.func_190916_E();
                        }
                        continue;
                    }
                    if (recipe instanceof ShapelessRecipes) {
                        shapeless = (ShapelessRecipes)recipe;
                        if (shapeless.field_77579_b.isEmpty()) continue;
                        for (Ingredient input : shapeless.field_77579_b) {
                            if (!input.test((Object)recyclingItem)) continue;
                            moltenDownItem2 = this.getRecyclingStack(recyclingItem);
                            if (!currentlyRecycledInto.func_190926_b() && !ItemStackUtils.isItemFuzzyEqual(currentlyRecycledInto, moltenDownItem2)) continue;
                            currentlyRecycledInto = moltenDownItem2;
                            recyclingAmount += moltenDownItem2.func_190916_E();
                        }
                        continue;
                    }
                    if (recipe instanceof ShapedOreRecipe) {
                        ShapedOreRecipe shapedOreRecipe = (ShapedOreRecipe)recipe;
                        block7: for (Ingredient input : shapedOreRecipe.func_192400_c()) {
                            if (input == null) continue;
                            for (ItemStack item : input.func_193365_a()) {
                                if (item.func_190926_b() || !ItemStackUtils.isItemFuzzyEqual(item, recyclingItem)) continue;
                                moltenDownItem = this.getRecyclingStack(recyclingItem);
                                if (!currentlyRecycledInto.func_190926_b() && !ItemStackUtils.isItemFuzzyEqual(currentlyRecycledInto, moltenDownItem)) continue block7;
                                currentlyRecycledInto = moltenDownItem;
                                recyclingAmount += moltenDownItem.func_190916_E();
                                continue block7;
                            }
                        }
                        continue;
                    }
                    if (!(recipe instanceof ShapelessOreRecipe)) continue;
                    shapeless = (ShapelessOreRecipe)recipe;
                    block9: for (Ingredient input : shapeless.func_192400_c()) {
                        if (input == null) continue;
                        for (ItemStack item : input.func_193365_a()) {
                            if (item.func_190926_b() || !ItemStackUtils.isItemFuzzyEqual(item, recyclingItem)) continue;
                            moltenDownItem = this.getRecyclingStack(recyclingItem);
                            if (!currentlyRecycledInto.func_190926_b() && !ItemStackUtils.isItemFuzzyEqual(currentlyRecycledInto, moltenDownItem)) continue block9;
                            currentlyRecycledInto = moltenDownItem;
                            recyclingAmount += moltenDownItem.func_190916_E();
                            continue block9;
                        }
                    }
                }
                catch (Throwable e) {
                    BluePower.log.error("Error when generating an Alloy Furnace recipe for item " + recyclingItem.func_82833_r() + ", recipe output: " + recipe.func_77571_b().func_82833_r());
                    e.printStackTrace();
                }
            }
            if (recyclingAmount <= 0 || recipe.func_77571_b().func_190916_E() <= 0) continue;
            boolean shouldAdd = true;
            for (int i = 0; i < registeredRecycledItems.size(); ++i) {
                if (!ItemStackUtils.isItemFuzzyEqual((ItemStack)registeredRecycledItems.get(i), recipe.func_77571_b())) continue;
                if (((ItemStack)registeredResultItems.get(i)).func_190916_E() < recyclingAmount) {
                    shouldAdd = false;
                    break;
                }
                registeredResultItems.remove(i);
                registeredRecycledItems.remove(i);
                --i;
            }
            if (!shouldAdd) continue;
            if (blacklist.contains(recipe.func_77571_b().func_77973_b())) {
                BluePower.log.info("Skipped adding item/block " + recipe.func_77571_b().func_82833_r() + " to the Alloy Furnace recipes.");
                continue;
            }
            ItemStack resultItem = new ItemStack(currentlyRecycledInto.func_77973_b(), Math.min(64, recyclingAmount), currentlyRecycledInto.func_77952_i());
            registeredResultItems.add(resultItem);
            registeredRecycledItems.add(recipe.func_77571_b());
        }
        for (int i = 0; i < registeredResultItems.size(); ++i) {
            this.addRecipe((ItemStack)registeredResultItems.get(i), registeredRecycledItems.get(i));
        }
    }

    private ItemStack getRecyclingStack(ItemStack original) {
        ItemStack moltenDownStack = this.moltenDownMap.get(original);
        return moltenDownStack != null ? moltenDownStack : original;
    }

    public IAlloyFurnaceRecipe getMatchingRecipe(NonNullList<ItemStack> input, ItemStack outputSlot) {
        for (IAlloyFurnaceRecipe recipe : this.alloyFurnaceRecipes) {
            ItemStack craftingResult;
            if (!recipe.matches(input) || outputSlot != null && !outputSlot.func_190926_b() && (!ItemStack.func_77970_a((ItemStack)outputSlot, (ItemStack)(craftingResult = recipe.getCraftingResult(input))) || !outputSlot.func_77969_a(craftingResult) || craftingResult.func_190916_E() + outputSlot.func_190916_E() > outputSlot.func_77976_d())) continue;
            return recipe;
        }
        return null;
    }

    public class StandardAlloyFurnaceRecipe
    implements IAlloyFurnaceRecipe {
        private final ItemStack craftingResult;
        private final NonNullList<ItemStack> requiredItems;

        private StandardAlloyFurnaceRecipe(ItemStack craftingResult, NonNullList<ItemStack> requiredItems) {
            if (craftingResult.func_190926_b()) {
                throw new IllegalArgumentException("Alloy Furnace crafting result can't be null!");
            }
            if (requiredItems.size() > 9) {
                throw new IllegalArgumentException("There can't be more than 9 crafting ingredients for the Alloy Furnace!");
            }
            for (ItemStack requiredItem : requiredItems) {
                if (!requiredItem.func_190926_b()) continue;
                throw new NullPointerException("An Alloy Furnace crafting ingredient can't be null!");
            }
            for (ItemStack stack : requiredItems) {
                for (ItemStack stack2 : requiredItems) {
                    if (stack == stack2 || !ItemStackUtils.isItemFuzzyEqual(stack, stack2)) continue;
                    throw new IllegalArgumentException("No equivalent Alloy Furnace crafting ingredient can be given twice! This does take OreDict + wildcard values in account.");
                }
            }
            this.craftingResult = craftingResult;
            this.requiredItems = requiredItems;
        }

        @Override
        public boolean matches(NonNullList<ItemStack> input) {
            for (ItemStack requiredItem : this.requiredItems) {
                ItemStack inputStack;
                int itemsNeeded = requiredItem.func_190916_E();
                Iterator iterator = input.iterator();
                while (iterator.hasNext() && ((inputStack = (ItemStack)iterator.next()).func_190926_b() || !ItemStackUtils.isItemFuzzyEqual(inputStack, requiredItem) || (itemsNeeded -= inputStack.func_190916_E()) > 0)) {
                }
                if (itemsNeeded <= 0) continue;
                return false;
            }
            return true;
        }

        @Override
        public void useItems(NonNullList<ItemStack> input) {
            for (ItemStack requiredItem : this.requiredItems) {
                int itemsNeeded = requiredItem.func_190916_E();
                for (int i = 0; i < input.size(); ++i) {
                    ItemStack inputStack = (ItemStack)input.get(i);
                    if (inputStack.func_190926_b() || !ItemStackUtils.isItemFuzzyEqual(inputStack, requiredItem)) continue;
                    int itemsSubstracted = Math.min(inputStack.func_190916_E(), itemsNeeded);
                    inputStack.func_190920_e(inputStack.func_190916_E() - itemsSubstracted);
                    if (inputStack.func_190916_E() <= 0) {
                        input.set(i, (Object)ItemStack.field_190927_a);
                    }
                    if ((itemsNeeded -= itemsSubstracted) <= 0) break;
                }
                if (itemsNeeded <= 0) continue;
                throw new IllegalArgumentException("Alloy Furnace recipe using items, after using still items required?? This is a bug!");
            }
        }

        @Override
        public ItemStack getCraftingResult(NonNullList<ItemStack> input) {
            return this.craftingResult;
        }

        public NonNullList<ItemStack> getRequiredItems() {
            return this.requiredItems;
        }
    }
}

