/*
 * Decompiled with CFR 0.152.
 */
package com.bluepowermod.tile;

import com.bluepowermod.block.BlockContainerFacingBase;
import com.bluepowermod.tile.IRotatable;
import java.util.ArrayList;
import java.util.List;
import javax.annotation.Nullable;
import net.minecraft.block.properties.IProperty;
import net.minecraft.item.ItemStack;
import net.minecraft.nbt.NBTTagCompound;
import net.minecraft.network.NetworkManager;
import net.minecraft.network.play.server.SPacketUpdateTileEntity;
import net.minecraft.tileentity.TileEntity;
import net.minecraft.util.EnumFacing;
import net.minecraft.util.ITickable;

public class TileBase
extends TileEntity
implements IRotatable,
ITickable {
    private boolean isRedstonePowered;
    private int outputtingRedstone;
    private int ticker = 0;

    public void func_145839_a(NBTTagCompound tCompound) {
        super.func_145839_a(tCompound);
        this.isRedstonePowered = tCompound.func_74767_n("isRedstonePowered");
        this.readFromPacketNBT(tCompound);
    }

    public NBTTagCompound func_189515_b(NBTTagCompound tCompound) {
        super.func_189515_b(tCompound);
        tCompound.func_74757_a("isRedstonePowered", this.isRedstonePowered);
        this.writeToPacketNBT(tCompound);
        return tCompound;
    }

    protected void writeToPacketNBT(NBTTagCompound tCompound) {
        tCompound.func_74774_a("outputtingRedstone", (byte)this.outputtingRedstone);
    }

    protected void readFromPacketNBT(NBTTagCompound tCompound) {
        this.outputtingRedstone = tCompound.func_74771_c("outputtingRedstone");
        if (this.field_145850_b != null) {
            this.markForRenderUpdate();
        }
    }

    @Nullable
    public SPacketUpdateTileEntity func_189518_D_() {
        NBTTagCompound tCompound = new NBTTagCompound();
        this.writeToPacketNBT(tCompound);
        return new SPacketUpdateTileEntity(this.field_174879_c, 0, tCompound);
    }

    public void onDataPacket(NetworkManager net, SPacketUpdateTileEntity pkt) {
        this.readFromPacketNBT(pkt.func_148857_g());
    }

    protected void sendUpdatePacket() {
        if (!this.field_145850_b.field_72995_K) {
            this.field_145850_b.func_175685_c(this.field_174879_c, this.func_145838_q(), true);
        }
    }

    protected void markForRenderUpdate() {
        if (this.field_145850_b != null) {
            this.field_145850_b.func_147458_c(this.field_174879_c.func_177958_n(), this.field_174879_c.func_177956_o(), this.field_174879_c.func_177952_p(), this.field_174879_c.func_177958_n(), this.field_174879_c.func_177956_o(), this.field_174879_c.func_177952_p());
        }
    }

    protected void notifyNeighborBlockUpdate() {
    }

    public void func_73660_a() {
        if (this.ticker == 0) {
            this.onTileLoaded();
        }
        ++this.ticker;
    }

    public void onBlockNeighbourChanged() {
        this.checkRedstonePower();
    }

    public void checkRedstonePower() {
        boolean isIndirectlyPowered;
        boolean bl = isIndirectlyPowered = this.func_145831_w().func_175687_A(this.field_174879_c) != 0;
        if (isIndirectlyPowered && !this.getIsRedstonePowered()) {
            this.redstoneChanged(true);
        } else if (this.getIsRedstonePowered() && !isIndirectlyPowered) {
            this.redstoneChanged(false);
        }
    }

    public void setOutputtingRedstone(boolean newValue) {
        this.setOutputtingRedstone(newValue ? 15 : 0);
    }

    public void setOutputtingRedstone(int value) {
        value = Math.max(0, value);
        if (this.outputtingRedstone != (value = Math.min(15, value))) {
            this.outputtingRedstone = value;
            this.notifyNeighborBlockUpdate();
        }
    }

    public int getOutputtingRedstone() {
        return this.outputtingRedstone;
    }

    protected void redstoneChanged(boolean newValue) {
        this.isRedstonePowered = newValue;
    }

    public boolean getIsRedstonePowered() {
        return this.isRedstonePowered;
    }

    public int getTicker() {
        return this.ticker;
    }

    protected void onTileLoaded() {
        if (!this.field_145850_b.field_72995_K) {
            this.onBlockNeighbourChanged();
        }
    }

    public List<ItemStack> getDrops() {
        return new ArrayList<ItemStack>();
    }

    @Override
    public void setFacingDirection(EnumFacing dir) {
        if (this.field_145850_b.func_180495_p(this.field_174879_c).func_177230_c() instanceof BlockContainerFacingBase) {
            BlockContainerFacingBase.setState(dir, this.field_145850_b, this.field_174879_c);
            if (this.field_145850_b != null) {
                this.sendUpdatePacket();
                this.notifyNeighborBlockUpdate();
            }
        }
    }

    @Override
    public EnumFacing getFacingDirection() {
        if (this.field_145850_b.func_180495_p(this.field_174879_c).func_177230_c() instanceof BlockContainerFacingBase) {
            return (EnumFacing)this.field_145850_b.func_180495_p(this.field_174879_c).func_177229_b((IProperty)BlockContainerFacingBase.FACING);
        }
        return EnumFacing.UP;
    }

    public boolean canConnectRedstone() {
        return false;
    }
}

