/*
 * Decompiled with CFR 0.152.
 */
package com.bluepowermod.tile;

import com.bluepowermod.api.misc.MinecraftColor;
import com.bluepowermod.api.tube.IPneumaticTube;
import com.bluepowermod.api.tube.ITubeConnection;
import com.bluepowermod.api.tube.IWeightedTubeInventory;
import com.bluepowermod.container.stack.TubeStack;
import com.bluepowermod.helper.IOHelper;
import com.bluepowermod.helper.TileEntityCache;
import com.bluepowermod.tile.IEjectAnimator;
import com.bluepowermod.tile.TileBase;
import java.util.ArrayList;
import java.util.Iterator;
import java.util.List;
import net.minecraft.block.Block;
import net.minecraft.block.BlockLiquid;
import net.minecraft.client.resources.I18n;
import net.minecraft.entity.Entity;
import net.minecraft.entity.item.EntityItem;
import net.minecraft.item.ItemStack;
import net.minecraft.nbt.NBTBase;
import net.minecraft.nbt.NBTTagCompound;
import net.minecraft.nbt.NBTTagList;
import net.minecraft.tileentity.TileEntity;
import net.minecraft.util.EnumFacing;
import net.minecraft.world.IBlockAccess;
import net.minecraftforge.fluids.IFluidBlock;
import net.minecraftforge.fml.relauncher.Side;
import net.minecraftforge.fml.relauncher.SideOnly;

public class TileMachineBase
extends TileBase
implements ITubeConnection,
IWeightedTubeInventory,
IEjectAnimator {
    protected boolean spawnItemsInWorld = true;
    protected boolean acceptsTubeItems = true;
    private final List<TubeStack> internalItemStackBuffer = new ArrayList<TubeStack>();
    private TileEntityCache tileCache;
    public static final int BUFFER_EMPTY_INTERVAL = 10;
    protected byte animationTicker = (byte)-1;
    protected static final int ANIMATION_TIME = 7;
    private boolean isAnimating;
    protected boolean ejectionScheduled;
    private static final int WARNING_INTERVAL = 600;

    @Override
    public void func_73660_a() {
        super.func_73660_a();
        if (!this.field_145850_b.field_72995_K && (this.ejectionScheduled || this.getTicker() % 10 == 0)) {
            this.ejectItems();
            this.ejectionScheduled = false;
        }
    }

    private void ejectItems() {
        Iterator<TubeStack> iterator = this.internalItemStackBuffer.iterator();
        while (iterator.hasNext()) {
            TubeStack tubeStack = iterator.next();
            if (IOHelper.canInterfaceWith(this.getTileCache(this.getOutputDirection()), this.getFacingDirection())) {
                ItemStack returnedStack = IOHelper.insert(this.getTileCache(this.getOutputDirection()), tubeStack.stack, this.getFacingDirection(), tubeStack.color, false);
                if (returnedStack.func_190926_b()) {
                    iterator.remove();
                    this.func_70296_d();
                    if (this.ejectionScheduled) continue;
                    break;
                }
                if (returnedStack.func_190916_E() == tubeStack.stack.func_190916_E()) break;
                this.func_70296_d();
                if (this.ejectionScheduled) continue;
                break;
            }
            if (!this.spawnItemsInWorld) continue;
            EnumFacing direction = this.getFacingDirection().func_176734_d();
            Block block = this.field_145850_b.func_180495_p(this.field_174879_c.func_177972_a(direction)).func_177230_c();
            if (!block.func_176205_b((IBlockAccess)this.field_145850_b, this.field_174879_c.func_177972_a(direction)) && !(block instanceof BlockLiquid) && !(block instanceof IFluidBlock)) break;
            this.ejectItemInWorld(tubeStack.stack, direction);
            iterator.remove();
            this.func_70296_d();
        }
    }

    public void func_145829_t() {
        super.func_145829_t();
        this.tileCache = null;
    }

    @Override
    public void onBlockNeighbourChanged() {
        super.onBlockNeighbourChanged();
        this.tileCache = null;
    }

    protected void addItemToOutputBuffer(ItemStack stack, IPneumaticTube.TubeColor color) {
        if (!this.field_145850_b.field_72995_K) {
            this.internalItemStackBuffer.add(new TubeStack(stack, this.getOutputDirection().func_176734_d(), color));
            if (this.internalItemStackBuffer.size() == 1) {
                this.ejectionScheduled = true;
            }
            this.animationTicker = 0;
            this.sendUpdatePacket();
            this.func_70296_d();
        }
    }

    public List<TubeStack> getBacklog() {
        return this.internalItemStackBuffer;
    }

    @SideOnly(value=Side.CLIENT)
    public void setBacklog(List<TubeStack> backlog) {
        this.internalItemStackBuffer.clear();
        this.internalItemStackBuffer.addAll(backlog);
    }

    protected void addItemToOutputBuffer(ItemStack stack) {
        this.addItemToOutputBuffer(stack, IPneumaticTube.TubeColor.NONE);
    }

    protected void addItemsToOutputBuffer(Iterable<ItemStack> stacks) {
        this.addItemsToOutputBuffer(stacks, IPneumaticTube.TubeColor.NONE);
    }

    protected void addItemsToOutputBuffer(Iterable<ItemStack> stacks, IPneumaticTube.TubeColor color) {
        for (ItemStack stack : stacks) {
            this.addItemToOutputBuffer(stack, color);
        }
    }

    protected boolean isBufferEmpty() {
        return this.internalItemStackBuffer.isEmpty();
    }

    public TileEntity getTileCache(EnumFacing d) {
        if (this.tileCache == null) {
            this.tileCache = new TileEntityCache(this.field_145850_b, this.field_174879_c);
        }
        return (TileEntity)this.tileCache.getValue(d);
    }

    public EnumFacing getOutputDirection() {
        return this.getFacingDirection().func_176734_d();
    }

    @Override
    public void func_145839_a(NBTTagCompound compound) {
        super.func_145839_a(compound);
        NBTTagList nbttaglist = compound.func_150295_c("ItemBuffer", 10);
        for (int i = 0; i < nbttaglist.func_74745_c(); ++i) {
            NBTTagCompound nbttagcompound1 = nbttaglist.func_150305_b(i);
            this.internalItemStackBuffer.add(TubeStack.loadFromNBT(nbttagcompound1));
        }
    }

    @Override
    public NBTTagCompound func_189515_b(NBTTagCompound compound) {
        super.func_189515_b(compound);
        NBTTagList nbttaglist = new NBTTagList();
        for (TubeStack tubeStack : this.internalItemStackBuffer) {
            if (tubeStack == null) continue;
            NBTTagCompound nbttagcompound1 = new NBTTagCompound();
            tubeStack.writeToNBT(nbttagcompound1);
            nbttaglist.func_74742_a((NBTBase)nbttagcompound1);
        }
        compound.func_74782_a("ItemBuffer", (NBTBase)nbttaglist);
        return compound;
    }

    public void ejectItemInWorld(ItemStack stack, EnumFacing oppDirection) {
        float spawnX = (float)this.field_174879_c.func_177958_n() + 0.5f + (float)oppDirection.func_82601_c() * 0.8f;
        float spawnY = (float)this.field_174879_c.func_177956_o() + 0.5f + (float)oppDirection.func_96559_d() * 0.8f;
        float spawnZ = (float)this.field_174879_c.func_177952_p() + 0.5f + (float)oppDirection.func_82599_e() * 0.8f;
        EntityItem droppedItem = new EntityItem(this.field_145850_b, (double)spawnX, (double)spawnY, (double)spawnZ, stack);
        droppedItem.field_70159_w = (float)oppDirection.func_82601_c() * 0.2f;
        droppedItem.field_70181_x = (float)oppDirection.func_96559_d() * 0.2f;
        droppedItem.field_70179_y = (float)oppDirection.func_82599_e() * 0.2f;
        this.field_145850_b.func_72838_d((Entity)droppedItem);
    }

    @Override
    public List<ItemStack> getDrops() {
        List<ItemStack> drops = super.getDrops();
        for (TubeStack stack : this.internalItemStackBuffer) {
            drops.add(stack.stack);
        }
        return drops;
    }

    @Override
    public boolean isConnectedTo(EnumFacing from) {
        EnumFacing dir = this.getOutputDirection();
        return from == dir.func_176734_d() || this.acceptsTubeItems && from == dir;
    }

    @Override
    public int getWeight(EnumFacing from) {
        return from == this.getOutputDirection().func_176734_d() ? 1000000 : 0;
    }

    @Override
    public boolean isEjecting() {
        return this.isAnimating;
    }

    @SideOnly(value=Side.CLIENT)
    public void addWailaInfo(List<String> info) {
        if (this.isEjecting()) {
            info.add(MinecraftColor.RED.getChatColor() + "[" + I18n.func_135052_a((String)"waila.machine.stuffed", (Object[])new Object[0]) + "]");
        }
    }
}

