/*
 * Decompiled with CFR 0.152.
 */
package com.bluepowermod.tile.tier1;

import com.bluepowermod.api.recipe.IAlloyFurnaceRecipe;
import com.bluepowermod.block.machine.BlockAlloyFurnace;
import com.bluepowermod.init.BPBlocks;
import com.bluepowermod.recipe.AlloyFurnaceRegistry;
import com.bluepowermod.tile.TileBase;
import java.util.List;
import net.minecraft.entity.player.EntityPlayer;
import net.minecraft.inventory.ISidedInventory;
import net.minecraft.item.ItemStack;
import net.minecraft.nbt.NBTBase;
import net.minecraft.nbt.NBTTagCompound;
import net.minecraft.tileentity.TileEntityFurnace;
import net.minecraft.util.EnumFacing;
import net.minecraft.util.NonNullList;
import net.minecraftforge.fml.relauncher.Side;
import net.minecraftforge.fml.relauncher.SideOnly;

public class TileAlloyFurnace
extends TileBase
implements ISidedInventory {
    private boolean isActive;
    public int currentBurnTime;
    public int currentProcessTime;
    public int maxBurnTime;
    private NonNullList<ItemStack> inventory = NonNullList.func_191197_a((int)10, (Object)ItemStack.field_190927_a);
    private ItemStack fuelInventory = ItemStack.field_190927_a;
    private ItemStack outputInventory = ItemStack.field_190927_a;
    private IAlloyFurnaceRecipe currentRecipe;
    private boolean updatingRecipe = true;

    @Override
    public void func_145839_a(NBTTagCompound tCompound) {
        super.func_145839_a(tCompound);
        for (int i = 0; i < 9; ++i) {
            NBTTagCompound tc = tCompound.func_74775_l("inventory" + i);
            this.inventory.set(i, (Object)new ItemStack(tc));
        }
        this.fuelInventory = new ItemStack(tCompound.func_74775_l("fuelInventory"));
        this.outputInventory = new ItemStack(tCompound.func_74775_l("outputInventory"));
    }

    @Override
    public NBTTagCompound func_189515_b(NBTTagCompound tCompound) {
        super.func_189515_b(tCompound);
        for (int i = 0; i < 9; ++i) {
            NBTTagCompound tc = new NBTTagCompound();
            ((ItemStack)this.inventory.get(i)).func_77955_b(tc);
            tCompound.func_74782_a("inventory" + i, (NBTBase)tc);
        }
        if (this.fuelInventory != null) {
            NBTTagCompound fuelCompound = new NBTTagCompound();
            this.fuelInventory.func_77955_b(fuelCompound);
            tCompound.func_74782_a("fuelInventory", (NBTBase)fuelCompound);
        }
        if (this.outputInventory != null) {
            NBTTagCompound outputCompound = new NBTTagCompound();
            this.outputInventory.func_77955_b(outputCompound);
            tCompound.func_74782_a("outputInventory", (NBTBase)outputCompound);
        }
        return tCompound;
    }

    @Override
    public void readFromPacketNBT(NBTTagCompound tag) {
        super.readFromPacketNBT(tag);
        this.isActive = tag.func_74767_n("isActive");
        this.currentBurnTime = tag.func_74762_e("currentBurnTime");
        this.currentProcessTime = tag.func_74762_e("currentProcessTime");
        this.maxBurnTime = tag.func_74762_e("maxBurnTime");
        this.markForRenderUpdate();
    }

    @Override
    public void writeToPacketNBT(NBTTagCompound tag) {
        super.writeToPacketNBT(tag);
        tag.func_74768_a("currentBurnTime", this.currentBurnTime);
        tag.func_74768_a("currentProcessTime", this.currentProcessTime);
        tag.func_74768_a("maxBurnTime", this.maxBurnTime);
        tag.func_74757_a("isActive", this.isActive);
    }

    @Override
    public void func_73660_a() {
        super.func_73660_a();
        if (!this.field_145850_b.field_72995_K) {
            this.setIsActive(this.currentBurnTime > 0);
            if (this.isActive) {
                --this.currentBurnTime;
            }
            if (this.updatingRecipe) {
                this.currentRecipe = AlloyFurnaceRegistry.getInstance().getMatchingRecipe(this.inventory, this.outputInventory);
                this.updatingRecipe = false;
            }
            if (this.currentRecipe != null) {
                if (this.currentBurnTime <= 0) {
                    if (TileEntityFurnace.func_145954_b((ItemStack)this.fuelInventory)) {
                        this.currentBurnTime = this.maxBurnTime = TileEntityFurnace.func_145952_a((ItemStack)this.fuelInventory) + 1;
                        if (!this.fuelInventory.func_190926_b()) {
                            this.fuelInventory.func_190920_e(this.fuelInventory.func_190916_E() - 1);
                            if (this.fuelInventory.func_190916_E() <= 0) {
                                this.fuelInventory = this.fuelInventory.func_77973_b().getContainerItem(this.fuelInventory);
                            }
                        }
                    } else {
                        this.currentProcessTime = 0;
                    }
                }
                if (++this.currentProcessTime >= 200) {
                    this.currentProcessTime = 0;
                    if (!this.outputInventory.func_190926_b()) {
                        this.outputInventory.func_190920_e(this.outputInventory.func_190916_E() + this.currentRecipe.getCraftingResult(this.inventory).func_190916_E());
                    } else {
                        this.outputInventory = this.currentRecipe.getCraftingResult(this.inventory).func_77946_l();
                    }
                    this.currentRecipe.useItems(this.inventory);
                    this.updatingRecipe = true;
                }
            } else {
                this.currentProcessTime = 0;
            }
        }
    }

    @Override
    protected void redstoneChanged(boolean newValue) {
    }

    @SideOnly(value=Side.CLIENT)
    public void setBurnTicks(int _maxBurnTime, int _currentBurnTime) {
        this.maxBurnTime = _maxBurnTime;
        this.currentBurnTime = _currentBurnTime;
    }

    public float getBurningPercentage() {
        if (this.maxBurnTime > 0) {
            return (float)this.currentBurnTime / (float)this.maxBurnTime;
        }
        return 0.0f;
    }

    public float getProcessPercentage() {
        return (float)this.currentProcessTime / 200.0f;
    }

    public boolean getIsActive() {
        return this.isActive;
    }

    public void setIsActive(boolean _isActive) {
        if (_isActive != this.isActive) {
            this.isActive = _isActive;
            BlockAlloyFurnace.setState(this.isActive, this.field_145850_b, this.field_174879_c);
            this.sendUpdatePacket();
        }
    }

    public int func_70302_i_() {
        return 11;
    }

    public ItemStack func_70301_a(int var1) {
        this.updatingRecipe = true;
        if (var1 == 0) {
            return this.fuelInventory;
        }
        if (var1 == 1) {
            return this.outputInventory;
        }
        if (var1 < 11) {
            return (ItemStack)this.inventory.get(var1 - 2);
        }
        return ItemStack.field_190927_a;
    }

    public ItemStack func_70298_a(int var1, int var2) {
        ItemStack tInventory = this.func_70301_a(var1);
        if (tInventory.func_190926_b()) {
            return ItemStack.field_190927_a;
        }
        ItemStack ret = ItemStack.field_190927_a;
        if (tInventory.func_190916_E() < var2) {
            ret = tInventory;
            this.inventory = null;
        } else {
            ret = tInventory.func_77979_a(var2);
            if (tInventory.func_190916_E() <= 0) {
                if (var1 == 0) {
                    this.fuelInventory = ItemStack.field_190927_a;
                } else if (var1 == 1) {
                    this.outputInventory = ItemStack.field_190927_a;
                } else {
                    this.inventory.set(var1 - 2, (Object)ItemStack.field_190927_a);
                }
            }
        }
        return ret;
    }

    public ItemStack func_70304_b(int index) {
        return this.func_70301_a(index);
    }

    public void func_70299_a(int var1, ItemStack itemStack) {
        if (var1 == 0) {
            this.fuelInventory = itemStack;
        } else if (var1 == 1) {
            this.outputInventory = itemStack;
        } else {
            this.inventory.set(var1 - 2, (Object)itemStack);
        }
        this.updatingRecipe = true;
    }

    public String func_70005_c_() {
        return BPBlocks.alloyfurnace.func_149739_a();
    }

    public boolean func_145818_k_() {
        return false;
    }

    public int func_70297_j_() {
        return 64;
    }

    public boolean func_70300_a(EntityPlayer player) {
        return player.func_174831_c(this.field_174879_c) <= 64.0;
    }

    public void func_174889_b(EntityPlayer player) {
    }

    public void func_174886_c(EntityPlayer player) {
    }

    public boolean func_94041_b(int slot, ItemStack itemStack) {
        if (slot == 0) {
            return TileEntityFurnace.func_145954_b((ItemStack)itemStack);
        }
        return slot != 1;
    }

    @Override
    public List<ItemStack> getDrops() {
        List<ItemStack> drops = super.getDrops();
        if (!this.fuelInventory.func_190926_b()) {
            drops.add(this.fuelInventory);
        }
        if (!this.outputInventory.func_190926_b()) {
            drops.add(this.outputInventory);
        }
        for (ItemStack stack : this.inventory) {
            if (stack.func_190926_b()) continue;
            drops.add(stack);
        }
        return drops;
    }

    public int[] func_180463_a(EnumFacing side) {
        return new int[]{0, 1, 2, 3, 4, 5, 6, 7, 8, 9, 10};
    }

    public boolean func_180462_a(int slot, ItemStack item, EnumFacing direction) {
        return this.func_94041_b(slot, item);
    }

    public boolean func_180461_b(int slot, ItemStack stack, EnumFacing direction) {
        return slot == 1;
    }

    public boolean func_191420_l() {
        return this.inventory.isEmpty();
    }

    public int func_174887_a_(int id) {
        return 0;
    }

    public void func_174885_b(int id, int value) {
    }

    public int func_174890_g() {
        return 0;
    }

    public void func_174888_l() {
    }
}

