/*
 * Decompiled with CFR 0.152.
 */
package com.bluepowermod.tile.tier1;

import com.bluepowermod.BluePower;
import com.bluepowermod.block.BlockContainerFacingBase;
import com.bluepowermod.helper.IOHelper;
import com.bluepowermod.init.BPBlocks;
import com.bluepowermod.tile.IEjectAnimator;
import com.bluepowermod.tile.TileBase;
import com.mojang.authlib.GameProfile;
import java.util.ArrayList;
import java.util.List;
import java.util.UUID;
import net.minecraft.block.Block;
import net.minecraft.block.properties.IProperty;
import net.minecraft.entity.Entity;
import net.minecraft.entity.EntityLivingBase;
import net.minecraft.entity.item.EntityItem;
import net.minecraft.entity.passive.EntityAnimal;
import net.minecraft.entity.player.EntityPlayer;
import net.minecraft.init.Items;
import net.minecraft.inventory.ISidedInventory;
import net.minecraft.item.Item;
import net.minecraft.item.ItemRedstone;
import net.minecraft.item.ItemStack;
import net.minecraft.nbt.NBTBase;
import net.minecraft.nbt.NBTTagCompound;
import net.minecraft.util.EnumActionResult;
import net.minecraft.util.EnumFacing;
import net.minecraft.util.EnumHand;
import net.minecraft.util.NonNullList;
import net.minecraft.util.math.AxisAlignedBB;
import net.minecraft.util.math.BlockPos;
import net.minecraft.world.WorldServer;
import net.minecraftforge.common.util.FakePlayer;
import net.minecraftforge.common.util.FakePlayerFactory;
import net.minecraftforge.event.entity.player.PlayerInteractEvent;

public class TileDeployer
extends TileBase
implements ISidedInventory,
IEjectAnimator {
    private final NonNullList<ItemStack> inventory = NonNullList.func_191197_a((int)10, (Object)ItemStack.field_190927_a);
    private static final List<Item> blacklistedItems = new ArrayList<Item>();
    private static final GameProfile FAKE_PLAYER_PROFILE = new GameProfile(UUID.randomUUID(), "[BP Deployer]");

    private boolean canDeployItem(ItemStack stack) {
        return !stack.func_190926_b() && !blacklistedItems.contains(stack.func_77973_b());
    }

    @Override
    protected void redstoneChanged(boolean newValue) {
        super.redstoneChanged(newValue);
        if (!this.field_145850_b.field_72995_K && newValue) {
            ItemStack stack;
            int i;
            this.sendUpdatePacket();
            FakePlayer player = FakePlayerFactory.get((WorldServer)((WorldServer)this.field_145850_b), (GameProfile)FAKE_PLAYER_PROFILE);
            for (i = 0; i < this.inventory.size(); ++i) {
                stack = (ItemStack)this.inventory.get(i);
                player.field_71071_by.func_70299_a(i, stack);
            }
            this.rightClick(player, 9);
            for (i = 0; i < this.inventory.size(); ++i) {
                stack = player.field_71071_by.func_70301_a(i);
                if (stack.func_190926_b() || stack.func_190916_E() <= 0) {
                    this.inventory.set(i, (Object)ItemStack.field_190927_a);
                } else {
                    this.inventory.set(i, (Object)stack);
                }
                player.field_71071_by.func_70299_a(i, ItemStack.field_190927_a);
            }
            for (i = 0; i < player.field_71071_by.func_70302_i_(); ++i) {
                stack = player.field_71071_by.func_70301_a(i);
                if (stack.func_190926_b() || stack.func_190916_E() <= 0) continue;
                ItemStack remainder = IOHelper.insert(this, stack, this.getFacingDirection().func_176734_d(), false);
                if (!remainder.func_190926_b()) {
                    this.field_145850_b.func_72838_d((Entity)new EntityItem(this.field_145850_b, (double)this.field_174879_c.func_177958_n() + 0.5, (double)this.field_174879_c.func_177956_o() + 0.5, (double)this.field_174879_c.func_177952_p() + 0.5, remainder));
                }
                player.field_71071_by.func_70299_a(i, ItemStack.field_190927_a);
            }
        }
    }

    protected boolean rightClick(FakePlayer player, int useItems) {
        if (useItems > 9) {
            throw new IllegalArgumentException("Hotbar is 9 items in width! You're trying " + useItems + "!");
        }
        EnumFacing faceDir = this.getFacingDirection();
        int dx = faceDir.func_82601_c();
        int dy = faceDir.func_96559_d();
        int dz = faceDir.func_82599_e();
        int x = this.field_174879_c.func_177958_n() + dx;
        int y = this.field_174879_c.func_177956_o() + dy;
        int z = this.field_174879_c.func_177952_p() + dz;
        player.func_70107_b((double)x + 0.5, (double)y + 0.5 - (double)player.eyeHeight, (double)z + 0.5);
        player.field_70125_A = faceDir.func_96559_d() * -90;
        switch (faceDir) {
            case NORTH: {
                player.field_70177_z = 180.0f;
                break;
            }
            case SOUTH: {
                player.field_70177_z = 0.0f;
                break;
            }
            case WEST: {
                player.field_70177_z = 90.0f;
                break;
            }
            case EAST: {
                player.field_70177_z = -90.0f;
            }
        }
        try {
            ItemStack stack;
            int i;
            Entity entity;
            PlayerInteractEvent.RightClickEmpty event = new PlayerInteractEvent.RightClickEmpty((EntityPlayer)player, EnumHand.MAIN_HAND);
            if (event.isCanceled()) {
                return false;
            }
            Block block = this.field_145850_b.func_180495_p(new BlockPos(x, y, z)).func_177230_c();
            List detectedEntities = this.field_145850_b.func_72872_a(EntityLivingBase.class, new AxisAlignedBB((double)x, (double)y, (double)z, (double)(x + 1), (double)(y + 1), (double)(z + 1)));
            Entity entity2 = entity = detectedEntities.isEmpty() ? null : (Entity)detectedEntities.get(this.field_145850_b.field_73012_v.nextInt(detectedEntities.size()));
            if (entity != null) {
                for (i = 0; i < useItems; ++i) {
                    player.field_71071_by.field_70461_c = i;
                    stack = player.func_184614_ca();
                    if (this.canDeployItem(stack) && stack.func_77973_b().func_111207_a(stack, (EntityPlayer)player, (EntityLivingBase)entity, EnumHand.MAIN_HAND)) {
                        return true;
                    }
                    if (!(entity instanceof EntityAnimal) || !((EntityAnimal)entity).func_184645_a((EntityPlayer)player, EnumHand.MAIN_HAND)) continue;
                    return true;
                }
            }
            for (i = 0; i < useItems; ++i) {
                player.field_71071_by.field_70461_c = i;
                stack = player.func_184614_ca();
                if (!this.canDeployItem(stack) || stack.func_77973_b().onItemUseFirst((EntityPlayer)player, this.field_145850_b, new BlockPos(x, y, z), faceDir, (float)dx, (float)dy, (float)dz, EnumHand.MAIN_HAND) != EnumActionResult.SUCCESS) continue;
                return true;
            }
            for (i = 0; i < useItems; ++i) {
                player.field_71071_by.field_70461_c = i;
                if (this.field_145850_b.func_175623_d(new BlockPos(x, y, z)) || !block.func_180639_a(this.field_145850_b, new BlockPos(x, y, z), this.field_145850_b.func_180495_p(new BlockPos(x, y, z)), (EntityPlayer)player, EnumHand.MAIN_HAND, faceDir, (float)dx, (float)dy, (float)dz)) continue;
                return true;
            }
            for (i = 0; i < useItems; ++i) {
                int useZ;
                player.field_71071_by.field_70461_c = i;
                stack = player.func_184614_ca();
                boolean isGoingToShift = false;
                if (!stack.func_190926_b() && (stack.func_77973_b() == Items.field_151120_aE || stack.func_77973_b() instanceof ItemRedstone)) {
                    isGoingToShift = true;
                }
                int useX = isGoingToShift ? this.field_174879_c.func_177958_n() : x;
                int useY = isGoingToShift ? this.field_174879_c.func_177956_o() : y;
                int n = useZ = isGoingToShift ? this.field_174879_c.func_177952_p() : z;
                if (!this.canDeployItem(stack) || stack.func_77973_b().func_180614_a((EntityPlayer)player, this.field_145850_b, new BlockPos(useX, useY, useZ), EnumHand.MAIN_HAND, faceDir, (float)dx, (float)dy, (float)dz) != EnumActionResult.SUCCESS) continue;
                return true;
            }
            for (i = 0; i < useItems; ++i) {
                player.field_71071_by.field_70461_c = i;
                stack = player.func_184614_ca();
                if (!this.canDeployItem(stack)) continue;
                ItemStack copy = stack.func_77946_l();
                player.func_184611_a(EnumHand.MAIN_HAND, (ItemStack)stack.func_77973_b().func_77659_a(this.field_145850_b, (EntityPlayer)player, EnumHand.MAIN_HAND).func_188398_b());
                if (copy.func_77969_a(stack)) continue;
                return true;
            }
            return false;
        }
        catch (Throwable e) {
            BluePower.log.error("Deployer crashed! Stacktrace: ");
            e.printStackTrace();
            return true;
        }
    }

    @Override
    public void func_145839_a(NBTTagCompound tCompound) {
        super.func_145839_a(tCompound);
        for (int i = 0; i < 9; ++i) {
            NBTTagCompound tc = tCompound.func_74775_l("inventory" + i);
            this.inventory.set(i, (Object)new ItemStack(tc));
        }
    }

    @Override
    public NBTTagCompound func_189515_b(NBTTagCompound tCompound) {
        super.func_189515_b(tCompound);
        for (int i = 0; i < 9; ++i) {
            NBTTagCompound tc = new NBTTagCompound();
            ((ItemStack)this.inventory.get(i)).func_77955_b(tc);
            tCompound.func_74782_a("inventory" + i, (NBTBase)tc);
        }
        return tCompound;
    }

    public int func_70302_i_() {
        return this.inventory.size();
    }

    public ItemStack func_70301_a(int i) {
        return (ItemStack)this.inventory.get(i);
    }

    public ItemStack func_70298_a(int slot, int amount) {
        ItemStack itemStack = this.func_70301_a(slot);
        if (!itemStack.func_190926_b()) {
            if (itemStack.func_190916_E() <= amount) {
                this.func_70299_a(slot, ItemStack.field_190927_a);
            } else if ((itemStack = itemStack.func_77979_a(amount)).func_190916_E() == 0) {
                this.func_70299_a(slot, ItemStack.field_190927_a);
            }
        }
        return itemStack;
    }

    public ItemStack func_70304_b(int i) {
        return this.func_70301_a(i);
    }

    public void func_70299_a(int i, ItemStack itemStack) {
        this.inventory.set(i, (Object)itemStack);
    }

    public String func_70005_c_() {
        return BPBlocks.deployer.func_149739_a();
    }

    public boolean func_145818_k_() {
        return true;
    }

    public int func_70297_j_() {
        return 64;
    }

    public boolean func_70300_a(EntityPlayer player) {
        return player.func_174831_c(this.field_174879_c) <= 64.0;
    }

    public void func_174889_b(EntityPlayer player) {
    }

    public void func_174886_c(EntityPlayer player) {
    }

    public boolean func_94041_b(int i, ItemStack itemStack) {
        return true;
    }

    @Override
    public List<ItemStack> getDrops() {
        List<ItemStack> drops = super.getDrops();
        for (ItemStack stack : this.inventory) {
            if (stack.func_190926_b()) continue;
            drops.add(stack);
        }
        return drops;
    }

    public int[] func_180463_a(EnumFacing side) {
        EnumFacing direction = this.getFacingDirection();
        if (side == direction) {
            return new int[0];
        }
        return new int[]{0, 1, 2, 3, 4, 5, 6, 7, 8};
    }

    public boolean func_180462_a(int index, ItemStack itemStackIn, EnumFacing direction) {
        for (int i : this.func_180463_a(direction)) {
            if (index != i) continue;
            return true;
        }
        return false;
    }

    public boolean func_180461_b(int index, ItemStack stack, EnumFacing direction) {
        for (int i : this.func_180463_a(direction)) {
            if (index != i) continue;
            return true;
        }
        return false;
    }

    @Override
    public boolean isEjecting() {
        return (Boolean)this.field_145850_b.func_180495_p(this.field_174879_c).func_177229_b((IProperty)BlockContainerFacingBase.ACTIVE);
    }

    @Override
    public boolean canConnectRedstone() {
        return true;
    }

    public boolean func_191420_l() {
        return this.inventory.size() == 0;
    }

    public int func_174887_a_(int id) {
        return 0;
    }

    public void func_174885_b(int id, int value) {
    }

    public int func_174890_g() {
        return 0;
    }

    public void func_174888_l() {
    }

    static {
        blacklistedItems.add(Items.field_151079_bi);
    }
}

