/*
 * Decompiled with CFR 0.152.
 */
package com.bluepowermod.tile.tier1;

import com.bluepowermod.client.gui.IGuiButtonSensitive;
import com.bluepowermod.helper.ItemStackHelper;
import com.bluepowermod.init.BPBlocks;
import com.bluepowermod.tile.TileMachineBase;
import java.util.List;
import net.minecraft.entity.player.EntityPlayer;
import net.minecraft.inventory.ISidedInventory;
import net.minecraft.item.ItemStack;
import net.minecraft.nbt.NBTBase;
import net.minecraft.nbt.NBTTagCompound;
import net.minecraft.util.EnumFacing;
import net.minecraft.util.NonNullList;

public class TileItemDetector
extends TileMachineBase
implements ISidedInventory,
IGuiButtonSensitive {
    public int mode;
    private final NonNullList<ItemStack> inventory = NonNullList.func_191197_a((int)10, (Object)ItemStack.field_190927_a);
    private int savedPulses = 0;
    public int fuzzySetting;

    @Override
    public void func_73660_a() {
        super.func_73660_a();
        if (!(this.field_145850_b.field_72995_K || this.mode != 0 && this.mode != 1 || this.field_145850_b.func_72820_D() % 2L != 0L)) {
            if (this.getOutputtingRedstone() > 0) {
                this.setOutputtingRedstone(false);
                this.sendUpdatePacket();
            } else if (this.savedPulses > 0) {
                --this.savedPulses;
                this.setOutputtingRedstone(true);
                this.sendUpdatePacket();
            }
        }
    }

    @Override
    public boolean isEjecting() {
        return this.getOutputtingRedstone() > 0;
    }

    private boolean isItemAccepted(ItemStack item) {
        boolean everythingNull = true;
        for (ItemStack invStack : this.inventory) {
            if (invStack.func_190926_b()) continue;
            if (ItemStackHelper.areStacksEqual(invStack, item, this.fuzzySetting)) {
                return true;
            }
            everythingNull = false;
        }
        return everythingNull;
    }

    @Override
    public void func_145839_a(NBTTagCompound tCompound) {
        super.func_145839_a(tCompound);
        for (int i = 0; i < 9; ++i) {
            NBTTagCompound tc = tCompound.func_74775_l("inventory" + i);
            this.inventory.set(i, (Object)new ItemStack(tc));
        }
        this.mode = tCompound.func_74771_c("mode");
        this.fuzzySetting = tCompound.func_74771_c("fuzzySetting");
        this.savedPulses = tCompound.func_74762_e("savedPulses");
    }

    @Override
    public NBTTagCompound func_189515_b(NBTTagCompound tCompound) {
        super.func_189515_b(tCompound);
        for (int i = 0; i < 9; ++i) {
            NBTTagCompound tc = new NBTTagCompound();
            ((ItemStack)this.inventory.get(i)).func_77955_b(tc);
            tCompound.func_74782_a("inventory" + i, (NBTBase)tc);
        }
        tCompound.func_74774_a("mode", (byte)this.mode);
        tCompound.func_74774_a("fuzzySetting", (byte)this.fuzzySetting);
        tCompound.func_74768_a("savedPulses", this.savedPulses);
        return tCompound;
    }

    public int func_70302_i_() {
        return this.inventory.size();
    }

    public ItemStack func_70301_a(int i) {
        return (ItemStack)this.inventory.get(i);
    }

    public ItemStack func_70298_a(int slot, int amount) {
        ItemStack itemStack = this.func_70301_a(slot);
        if (!itemStack.func_190926_b()) {
            if (itemStack.func_190916_E() <= amount) {
                this.func_70299_a(slot, ItemStack.field_190927_a);
            } else if ((itemStack = itemStack.func_77979_a(amount)).func_190916_E() == 0) {
                this.func_70299_a(slot, ItemStack.field_190927_a);
            }
        }
        return itemStack;
    }

    public ItemStack func_70304_b(int i) {
        ItemStack itemStack = this.func_70301_a(i);
        if (!itemStack.func_190926_b()) {
            this.func_70299_a(i, ItemStack.field_190927_a);
        }
        return itemStack;
    }

    public void func_70299_a(int i, ItemStack itemStack) {
        this.inventory.set(i, (Object)itemStack);
    }

    public String func_70005_c_() {
        return BPBlocks.item_detector.func_149739_a();
    }

    public boolean func_145818_k_() {
        return false;
    }

    public int func_70297_j_() {
        return 64;
    }

    public boolean func_70300_a(EntityPlayer player) {
        return player.func_174831_c(this.field_174879_c) <= 64.0;
    }

    public void func_174889_b(EntityPlayer player) {
    }

    public void func_174886_c(EntityPlayer player) {
    }

    public boolean func_94041_b(int i, ItemStack itemStack) {
        return true;
    }

    @Override
    public List<ItemStack> getDrops() {
        List<ItemStack> drops = super.getDrops();
        for (ItemStack stack : this.inventory) {
            if (stack.func_190926_b()) continue;
            drops.add(stack);
        }
        return drops;
    }

    public int[] func_180463_a(EnumFacing side) {
        EnumFacing direction = this.getFacingDirection();
        if (side == direction || side == direction.func_176734_d()) {
            return new int[0];
        }
        return new int[]{0, 1, 2, 3, 4, 5, 6, 7, 8};
    }

    public boolean func_180462_a(int index, ItemStack itemStackIn, EnumFacing direction) {
        return true;
    }

    public boolean func_180461_b(int index, ItemStack stack, EnumFacing direction) {
        return true;
    }

    @Override
    public void onButtonPress(EntityPlayer player, int messageId, int value) {
        if (messageId == 0) {
            this.mode = value;
        }
        if (messageId == 1) {
            this.fuzzySetting = value;
        }
    }

    @Override
    public boolean canConnectRedstone() {
        return true;
    }

    public boolean func_191420_l() {
        return this.inventory.size() == 0;
    }

    public int func_174887_a_(int id) {
        return 0;
    }

    public void func_174885_b(int id, int value) {
    }

    public int func_174890_g() {
        return 0;
    }

    public void func_174888_l() {
    }
}

