/*
 * Decompiled with CFR 0.152.
 */
package com.bluepowermod.tile.tier1;

import com.bluepowermod.api.misc.MinecraftColor;
import com.bluepowermod.block.machine.BlockLamp;
import com.bluepowermod.block.machine.BlockLampRGB;
import com.bluepowermod.client.render.RenderLamp;
import com.bluepowermod.helper.MathHelper;
import com.bluepowermod.init.Config;
import com.bluepowermod.tile.TileBase;
import elucent.albedo.lighting.ILightProvider;
import elucent.albedo.lighting.Light;
import net.minecraft.nbt.NBTTagCompound;
import net.minecraft.util.math.BlockPos;
import net.minecraft.world.IBlockAccess;
import net.minecraft.world.World;
import net.minecraftforge.fml.common.Optional;

@Optional.Interface(iface="elucent.albedo.lighting.ILightProvider", modid="albedo")
public class TileLamp
extends TileBase
implements ILightProvider {
    private byte[] bundledPower = new byte[16];

    @Override
    protected void writeToPacketNBT(NBTTagCompound tCompound) {
        if (this.field_145854_h instanceof BlockLampRGB) {
            tCompound.func_74774_a("red", this.bundledPower[MinecraftColor.RED.ordinal()]);
            tCompound.func_74774_a("green", this.bundledPower[MinecraftColor.GREEN.ordinal()]);
            tCompound.func_74774_a("blue", this.bundledPower[MinecraftColor.BLUE.ordinal()]);
        }
    }

    @Override
    protected void readFromPacketNBT(NBTTagCompound tCompound) {
        if (tCompound.func_74764_b("red")) {
            byte[] pow = this.bundledPower;
            pow[MinecraftColor.RED.ordinal()] = tCompound.func_74771_c("red");
            pow[MinecraftColor.GREEN.ordinal()] = tCompound.func_74771_c("green");
            pow[MinecraftColor.BLUE.ordinal()] = tCompound.func_74771_c("blue");
            this.bundledPower = pow;
        }
    }

    public boolean shouldRenderInPass(int pass) {
        RenderLamp.pass = pass;
        return true;
    }

    public World func_145831_w() {
        return this.field_145850_b;
    }

    public BlockPos func_174877_v() {
        return this.field_174879_c;
    }

    public int getColor() {
        int r = MathHelper.map(this.bundledPower[MinecraftColor.RED.ordinal()] & 0xFF, 0, 255, 20, 235);
        int g = MathHelper.map(this.bundledPower[MinecraftColor.GREEN.ordinal()] & 0xFF, 0, 255, 20, 235);
        int b = MathHelper.map(this.bundledPower[MinecraftColor.BLUE.ordinal()] & 0xFF, 0, 255, 20, 235);
        return (r << 16) + (g << 8) + b;
    }

    @Override
    protected void onTileLoaded() {
        this.field_145850_b.func_180495_p(this.field_174879_c).func_189546_a(this.field_145850_b, this.field_174879_c, this.field_145850_b.func_180495_p(this.field_174879_c).func_177230_c(), this.field_174879_c);
    }

    @Optional.Method(modid="albedo")
    public Light provideLight() {
        BlockLamp block = (BlockLamp)this.field_145850_b.func_180495_p(this.field_174879_c).func_177230_c();
        int value = block.getLightValue(this.field_145850_b.func_180495_p(this.field_174879_c), (IBlockAccess)this.field_145850_b, this.field_174879_c);
        int color = block.getColor((IBlockAccess)this.field_145850_b, this.field_174879_c, 0);
        int redMask = 0xFF0000;
        int greenMask = 65280;
        int blueMask = 255;
        int r = (color & redMask) >> 16;
        int g = (color & greenMask) >> 8;
        int b = color & blueMask;
        return Light.builder().pos(this.field_174879_c).color((float)r, (float)g, (float)b, Config.albedoBrightness).radius((float)Math.max(value / 2, 1)).build();
    }
}

