/*
 * Decompiled with CFR 0.152.
 */
package com.bluepowermod.tile.tier3;

import com.bluepowermod.api.tube.IPneumaticTube;
import com.bluepowermod.client.gui.IGuiButtonSensitive;
import com.bluepowermod.helper.IOHelper;
import com.bluepowermod.init.BPBlocks;
import com.bluepowermod.tile.IFuzzyRetrieving;
import com.bluepowermod.tile.IRejectAnimator;
import com.bluepowermod.tile.TileMachineBase;
import java.util.List;
import java.util.Optional;
import mcmultipart.api.multipart.MultipartHelper;
import net.minecraft.entity.player.EntityPlayer;
import net.minecraft.inventory.IInventory;
import net.minecraft.inventory.ISidedInventory;
import net.minecraft.item.ItemStack;
import net.minecraft.nbt.NBTBase;
import net.minecraft.nbt.NBTTagCompound;
import net.minecraft.tileentity.TileEntity;
import net.minecraft.util.EnumFacing;
import net.minecraft.util.NonNullList;
import net.minecraft.util.math.BlockPos;
import net.minecraft.world.IBlockAccess;

public class TileManager
extends TileMachineBase
implements ISidedInventory,
IRejectAnimator,
IFuzzyRetrieving,
IGuiButtonSensitive {
    protected final NonNullList<ItemStack> inventory = NonNullList.func_191197_a((int)25, (Object)ItemStack.field_190927_a);
    public IPneumaticTube.TubeColor filterColor = IPneumaticTube.TubeColor.NONE;
    public int priority;
    public int mode;
    public int fuzzySetting;
    private int rejectTicker = -1;

    private int acceptedItems(ItemStack item) {
        if (item.func_190926_b()) {
            return 0;
        }
        int managerCount = IOHelper.getItemCount(item, this, null, this.fuzzySetting);
        if (this.mode == 1 && managerCount > 0) {
            return item.func_190916_E();
        }
        return managerCount - IOHelper.getItemCount(item, this.getTileCache(this.getFacingDirection()), this.getFacingDirection().func_176734_d(), this.fuzzySetting);
    }

    @Override
    public void onButtonPress(EntityPlayer player, int messageId, int value) {
        if (messageId == 0) {
            this.filterColor = IPneumaticTube.TubeColor.values()[value];
        } else if (messageId == 1) {
            this.mode = value;
        } else if (messageId == 2) {
            this.priority = value;
        } else {
            this.fuzzySetting = value;
        }
    }

    @Override
    public void func_73660_a() {
        if (!this.field_145850_b.field_72995_K && this.getTicker() % 10 == 0) {
            this.dumpUnwantedItems();
            this.retrieveItemsFromManagers();
            this.setOutputtingRedstone(this.mode == 0 && this.shouldEmitRedstone());
        }
        if (this.rejectTicker >= 0 && ++this.rejectTicker > 7) {
            this.rejectTicker = -1;
            this.markForRenderUpdate();
        }
        super.func_73660_a();
    }

    private boolean shouldEmitRedstone() {
        for (ItemStack stack : this.inventory) {
            if (stack.func_190926_b() || this.acceptedItems(stack) <= 0) continue;
            return false;
        }
        return true;
    }

    private void retrieveItemsFromManagers() {
        Optional container = MultipartHelper.getContainer((IBlockAccess)this.field_145850_b, (BlockPos)this.field_174879_c.func_177972_a(this.getOutputDirection()));
        if (container.isPresent()) {
            // empty if block
        }
    }

    private void dumpUnwantedItems() {
        int[] slots;
        TileEntity te = this.getTileCache(this.getFacingDirection());
        IInventory inv = IOHelper.getInventoryForTE(te);
        for (int slot : slots = IOHelper.getAccessibleSlotsForInventory(inv, this.getFacingDirection().func_176734_d())) {
            ItemStack stack = inv.func_70301_a(slot);
            int acceptedItems = this.acceptedItems(stack);
            if (acceptedItems >= 0) continue;
            int rejectedItems = -acceptedItems;
            ItemStack rejectingStack = stack.func_77946_l();
            rejectingStack.func_190920_e(Math.min(rejectedItems, rejectingStack.func_77976_d()));
            rejectingStack = IOHelper.extract(te, this.getFacingDirection().func_176734_d(), rejectingStack, true, false, this.fuzzySetting);
            if (rejectingStack.func_190926_b()) continue;
            this.addItemToOutputBuffer(rejectingStack, this.filterColor);
        }
    }

    @Override
    public void func_145839_a(NBTTagCompound tCompound) {
        super.func_145839_a(tCompound);
        for (int i = 0; i < 24; ++i) {
            NBTTagCompound tc = tCompound.func_74775_l("inventory" + i);
            this.inventory.set(i, (Object)new ItemStack(tc));
        }
        this.filterColor = IPneumaticTube.TubeColor.values()[tCompound.func_74771_c("filterColor")];
        this.mode = tCompound.func_74771_c("mode");
        this.priority = tCompound.func_74771_c("priority");
        this.fuzzySetting = tCompound.func_74771_c("fuzzySetting");
    }

    @Override
    public NBTTagCompound func_189515_b(NBTTagCompound tCompound) {
        super.func_189515_b(tCompound);
        for (int i = 0; i < 24; ++i) {
            NBTTagCompound tc = new NBTTagCompound();
            ((ItemStack)this.inventory.get(i)).func_77955_b(tc);
            tCompound.func_74782_a("inventory" + i, (NBTBase)tc);
        }
        tCompound.func_74774_a("filterColor", (byte)this.filterColor.ordinal());
        tCompound.func_74774_a("mode", (byte)this.mode);
        tCompound.func_74774_a("priority", (byte)this.priority);
        tCompound.func_74774_a("fuzzySetting", (byte)this.fuzzySetting);
        return tCompound;
    }

    @Override
    public void writeToPacketNBT(NBTTagCompound tag) {
        super.writeToPacketNBT(tag);
        tag.func_74774_a("rejectAnimation", (byte)this.rejectTicker);
    }

    @Override
    public void readFromPacketNBT(NBTTagCompound tag) {
        super.readFromPacketNBT(tag);
        this.rejectTicker = tag.func_74771_c("rejectAnimation");
    }

    public int func_70302_i_() {
        return this.inventory.size();
    }

    public boolean func_191420_l() {
        return this.inventory.size() == 0;
    }

    public ItemStack func_70301_a(int i) {
        return (ItemStack)this.inventory.get(i);
    }

    public ItemStack func_70298_a(int slot, int amount) {
        ItemStack itemStack = this.func_70301_a(slot);
        if (!itemStack.func_190926_b()) {
            if (itemStack.func_190916_E() <= amount) {
                this.func_70299_a(slot, ItemStack.field_190927_a);
            } else if ((itemStack = itemStack.func_77979_a(amount)).func_190916_E() == 0) {
                this.func_70299_a(slot, ItemStack.field_190927_a);
            }
        }
        return itemStack;
    }

    public ItemStack func_70304_b(int i) {
        ItemStack itemStack = this.func_70301_a(i);
        if (itemStack != ItemStack.field_190927_a) {
            this.func_70299_a(i, ItemStack.field_190927_a);
        }
        return itemStack;
    }

    public void func_70299_a(int i, ItemStack itemStack) {
        this.inventory.set(i, (Object)itemStack);
    }

    public String func_70005_c_() {
        return BPBlocks.manager.func_149739_a();
    }

    public boolean func_145818_k_() {
        return false;
    }

    public int func_70297_j_() {
        return 64;
    }

    public boolean func_70300_a(EntityPlayer player) {
        return player.func_174831_c(this.field_174879_c) <= 64.0;
    }

    public void func_174889_b(EntityPlayer player) {
    }

    public void func_174886_c(EntityPlayer player) {
    }

    public boolean func_94041_b(int i, ItemStack itemStack) {
        return true;
    }

    public int func_174887_a_(int id) {
        return 0;
    }

    public void func_174885_b(int id, int value) {
    }

    public int func_174890_g() {
        return 0;
    }

    public void func_174888_l() {
    }

    @Override
    public List<ItemStack> getDrops() {
        List<ItemStack> drops = super.getDrops();
        for (ItemStack stack : this.inventory) {
            if (stack.func_190926_b()) continue;
            drops.add(stack);
        }
        return drops;
    }

    public int[] func_180463_a(EnumFacing side) {
        EnumFacing direction = this.getFacingDirection();
        if (side == direction || side == direction.func_176734_d()) {
            return new int[0];
        }
        int[] slots = new int[this.inventory.size()];
        for (int i = 0; i < slots.length; ++i) {
            slots[i] = i;
        }
        return slots;
    }

    public boolean func_180462_a(int index, ItemStack itemStackIn, EnumFacing direction) {
        return true;
    }

    public boolean func_180461_b(int index, ItemStack stack, EnumFacing direction) {
        return true;
    }

    @Override
    public boolean canConnectRedstone() {
        return true;
    }

    @Override
    public boolean isRejecting() {
        return this.rejectTicker >= 0;
    }

    @Override
    public int getFuzzySetting() {
        return this.fuzzySetting;
    }
}

