/*
 * Decompiled with CFR 0.152.
 */
package com.bluepowermod.util;

import com.bluepowermod.compat.CompatibilityUtils;
import net.minecraft.item.ItemStack;
import net.minecraft.util.NonNullList;
import net.minecraftforge.oredict.OreDictionary;

public class ItemStackUtils {
    public static boolean isItemFuzzyEqual(ItemStack stack1, ItemStack stack2) {
        if (ItemStackUtils.isSameOreDictStack(stack1, stack2)) {
            return true;
        }
        if (stack1.func_77973_b() != stack2.func_77973_b()) {
            return false;
        }
        return stack1.func_77952_i() == stack2.func_77952_i() || stack1.func_77952_i() == Short.MAX_VALUE || stack2.func_77952_i() == Short.MAX_VALUE;
    }

    public static boolean isSameOreDictStack(ItemStack stack1, ItemStack stack2) {
        int[] ids;
        for (int id : ids = OreDictionary.getOreIDs((ItemStack)stack1)) {
            String name = OreDictionary.getOreName((int)id);
            NonNullList oreDictStacks = OreDictionary.getOres((String)name);
            for (ItemStack oreDictStack : oreDictStacks) {
                if (!OreDictionary.itemMatches((ItemStack)stack2, (ItemStack)oreDictStack, (boolean)false)) continue;
                return true;
            }
        }
        return false;
    }

    public static boolean isScrewdriver(ItemStack item) {
        if (item.func_190926_b()) {
            return false;
        }
        if (item.func_77973_b() == null) {
            return false;
        }
        return CompatibilityUtils.isScrewdriver(item);
    }
}

