/*
 * Decompiled with CFR 0.152.
 */
package com.bluepowermod.world;

import com.bluepowermod.init.BPBlocks;
import com.bluepowermod.init.BPItems;
import com.bluepowermod.init.Config;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import java.util.Random;
import net.minecraft.block.Block;
import net.minecraft.block.material.Material;
import net.minecraft.init.Blocks;
import net.minecraft.item.ItemStack;
import net.minecraft.tileentity.TileEntityChest;
import net.minecraft.util.EnumFacing;
import net.minecraft.util.math.BlockPos;
import net.minecraft.world.World;
import net.minecraft.world.storage.loot.LootTableList;

public class WorldGenVolcano {
    private static final int MAX_VOLCANO_RADIUS = 200;
    private final HashMap<BlockPos, Integer> volcanoMap = new HashMap();
    private static final Block[] ALTAR_BLOCKS = new Block[]{BPBlocks.amethyst_block, BPBlocks.ruby_block, BPBlocks.sapphire_block, BPBlocks.tungsten_block};

    public void generate(World world, Random rand, int middleX, int volcanoHeight, int middleZ) {
        List<Pos>[] distMap = this.calculateDistMap();
        boolean first = true;
        int centreWorldHeight = world.func_189649_b(middleX, middleZ);
        for (int dist = 0; dist < distMap.length; ++dist) {
            List<Pos> distList = distMap[dist];
            boolean isFinished = true;
            for (Pos p : distList) {
                int posHeight;
                int worldHeight = world.func_189649_b(p.x + middleX, p.z + middleZ) - 1;
                int n = posHeight = first ? volcanoHeight : this.getNewVolcanoHeight(worldHeight, p, rand, dist);
                if (posHeight >= 0 && (posHeight > worldHeight || this.canReplace(world, p.x + middleX, posHeight, p.z + middleZ))) {
                    this.volcanoMap.put(new BlockPos(p.x, 0, p.z), posHeight);
                    if (!first) {
                        int i;
                        for (i = posHeight; i > 0 && (i > worldHeight || this.canReplace(world, p.x + middleX, i, p.z + middleZ)); --i) {
                            world.func_180501_a(new BlockPos(p.x + middleX, i, p.z + middleZ), BPBlocks.basalt.func_176223_P(), 2);
                        }
                        for (i = posHeight + 1; i < volcanoHeight; ++i) {
                            if (!this.canReplace(world, p.x + middleX, i, p.z + middleZ) || world.func_180495_p(new BlockPos(p.x + middleX, i, p.z + middleZ)).func_185904_a() == Material.field_151586_h) continue;
                            world.func_175698_g(new BlockPos(p.x + middleX, i, p.z + middleZ));
                        }
                    }
                    isFinished = false;
                }
                first = false;
            }
            if (isFinished) break;
        }
        this.generateLavaColumn(world, middleX, volcanoHeight, middleZ, rand);
        this.generateLootChamber(world, middleX, rand.nextInt(volcanoHeight - 20 - centreWorldHeight) + centreWorldHeight, middleZ, rand);
    }

    private boolean canReplace(World world, int x, int y, int z) {
        if (world.func_175623_d(new BlockPos(x, y, z))) {
            return true;
        }
        Block block = world.func_180495_p(new BlockPos(x, y, z)).func_177230_c();
        Material material = world.func_180495_p(new BlockPos(x, y, z)).func_185904_a();
        return material == Material.field_151575_d || material == Material.field_151570_A || material == Material.field_151584_j || material == Material.field_151585_k || material == Material.field_151582_l || block == Blocks.field_150355_j || block == Blocks.field_150358_i;
    }

    private void generateLavaColumn(World world, int x, int topY, int z, Random rand) {
        if (rand.nextDouble() < Config.volcanoActiveToInactiveRatio) {
            world.func_175656_a(new BlockPos(x, topY, z), BPBlocks.cracked_basalt_lava.func_176223_P());
        } else {
            world.func_175656_a(new BlockPos(x, topY + 1, z), Blocks.field_150353_l.func_176223_P());
            world.func_175656_a(new BlockPos(x, topY, z), Blocks.field_150353_l.func_176223_P());
        }
        for (int y = topY - 1; y >= 10; --y) {
            if (world.func_180495_p(new BlockPos(x, y, z)) == Blocks.field_150357_h.func_176223_P()) continue;
            world.func_180501_a(new BlockPos(x + 1, y, z), BPBlocks.basalt.func_176223_P(), 2);
            world.func_180501_a(new BlockPos(x - 1, y, z), BPBlocks.basalt.func_176223_P(), 2);
            world.func_180501_a(new BlockPos(x, y, z + 1), BPBlocks.basalt.func_176223_P(), 2);
            world.func_180501_a(new BlockPos(x, y, z - 1), BPBlocks.basalt.func_176223_P(), 2);
            world.func_180501_a(new BlockPos(x, y, z), Blocks.field_150353_l.func_176223_P(), 2);
        }
    }

    private List<Pos>[] calculateDistMap() {
        List[] distMap = new List[200];
        for (int x = -200; x <= 200; ++x) {
            for (int z = -200; z <= 200; ++z) {
                int dist = (int)Math.sqrt(x * x + z * z);
                if (dist >= 200) continue;
                ArrayList<Pos> distList = distMap[dist];
                if (distList == null) {
                    distMap[dist] = distList = new ArrayList<Pos>();
                }
                distList.add(new Pos(x, z));
            }
        }
        return distMap;
    }

    private int getNewVolcanoHeight(int worldHeight, Pos requestedPos, Random rand, int distFromCenter) {
        int neighborCount = 0;
        int totalHeight = 0;
        for (int x = requestedPos.x - 1; x <= requestedPos.x + 1; ++x) {
            for (int z = requestedPos.z - 1; z <= requestedPos.z + 1; ++z) {
                Integer neighborHeight = this.volcanoMap.get(new BlockPos(x, 0, z));
                if (neighborHeight == null) continue;
                ++neighborCount;
                totalHeight += neighborHeight.intValue();
            }
        }
        if (neighborCount != 0) {
            double avgHeight = (double)totalHeight / (double)neighborCount;
            if ((int)avgHeight < worldHeight + 2 && rand.nextInt(5) != 0) {
                return (int)avgHeight - 2;
            }
            int blocksDown = distFromCenter < 2 ? 0 : (distFromCenter == 2 ? rand.nextInt(2) : (int)(Math.pow(avgHeight - (double)worldHeight + 1.0, 1.2) * 0.005 + (rand.nextDouble() - 0.5) * 3.0 + 0.4));
            if (blocksDown < 0) {
                blocksDown = 0;
            }
            int newHeight = (int)avgHeight - blocksDown;
            return newHeight;
        }
        return -1;
    }

    private void generateLootChamber(World world, int middleX, int startY, int middleZ, Random rand) {
        int roomSize = 9;
        int roomHeight = 5;
        int startX = middleX - roomSize / 2;
        int startZ = middleZ - roomSize / 2;
        for (int x = startX; x < startX + roomSize; ++x) {
            for (int y = startY; y < startY + roomHeight; ++y) {
                for (int z = startZ; z < startZ + roomSize; ++z) {
                    int xOffset = Math.abs(x - middleX);
                    int zOffset = Math.abs(z - middleZ);
                    if (xOffset == 0 && zOffset == 0) continue;
                    boolean spawnGlass = xOffset <= 1 && zOffset <= 1;
                    world.func_180501_a(new BlockPos(x, y, z), spawnGlass ? BPBlocks.reinforced_sapphire_glass.func_176223_P() : Blocks.field_150350_a.func_176223_P(), 0);
                }
            }
        }
        for (EnumFacing d : EnumFacing.field_82609_l) {
            if (d == EnumFacing.UP || d == EnumFacing.DOWN || rand.nextInt(2) != 0) continue;
            this.generateAltar(world, middleX + d.func_82601_c() * roomSize / 2, startY - 1, middleZ + d.func_82599_e() * roomSize / 2, rand, d);
        }
    }

    private void generateAltar(World world, int startX, int startY, int startZ, Random rand, EnumFacing dir) {
        this.generateLootChest(world, new BlockPos(startX, startY + 1, startZ), rand, dir);
        EnumFacing opDir = dir.func_176734_d();
        Block altarBlock = ALTAR_BLOCKS[rand.nextInt(ALTAR_BLOCKS.length)];
        this.setAltarBlockAndPossiblyTrap(world, startX, startY, startZ, rand, altarBlock);
        this.setAltarBlockAndPossiblyTrap(world, startX + opDir.func_82601_c(), startY, startZ + opDir.func_82599_e(), rand, altarBlock);
        EnumFacing sideDir = EnumFacing.DOWN;
        this.setAltarBlockAndPossiblyTrap(world, startX + sideDir.func_82601_c(), startY, startZ + sideDir.func_82599_e(), rand, altarBlock);
        this.setAltarBlockAndPossiblyTrap(world, startX + sideDir.func_82601_c() + opDir.func_82601_c(), startY, startZ + sideDir.func_82599_e() + opDir.func_82599_e(), rand, altarBlock);
        sideDir = sideDir.func_176734_d();
        this.setAltarBlockAndPossiblyTrap(world, startX + sideDir.func_82601_c(), startY, startZ + sideDir.func_82599_e(), rand, altarBlock);
        this.setAltarBlockAndPossiblyTrap(world, startX + sideDir.func_82601_c() + opDir.func_82601_c(), startY, startZ + sideDir.func_82599_e() + opDir.func_82599_e(), rand, altarBlock);
    }

    private void setAltarBlockAndPossiblyTrap(World world, int x, int y, int z, Random rand, Block altarBlock) {
        world.func_180501_a(new BlockPos(x, y, z), altarBlock.func_176223_P(), 2);
        if (rand.nextInt(6) == 0) {
            world.func_180501_a(new BlockPos(x, y - 1, z), Blocks.field_150335_W.func_176223_P(), 2);
            world.func_180501_a(new BlockPos(x, y - 2, z), Blocks.field_150451_bX.func_176223_P(), 2);
        }
    }

    private void generateLootChest(World world, BlockPos pos, Random rand, EnumFacing dir) {
        world.func_180501_a(pos, Blocks.field_150486_ae.func_176223_P(), dir.func_176734_d().ordinal());
        if (rand.nextInt(5) == 0) {
            ((TileEntityChest)world.func_175625_s(pos)).func_70299_a(13, new ItemStack(BPItems.tungsten_ingot, 5 + rand.nextInt(10)));
        } else {
            ((TileEntityChest)world.func_175625_s(pos)).func_189404_a(LootTableList.field_186422_d, (long)rand.nextInt());
        }
    }

    private static class Pos {
        public final int x;
        public final int z;

        public Pos(int x, int z) {
            this.x = x;
            this.z = z;
        }

        public boolean equals(Object object) {
            if (object instanceof Pos) {
                Pos pos = (Pos)object;
                return pos.x == this.x && pos.z == this.z;
            }
            return false;
        }

        public int hashCode() {
            return (this.x << 13) + this.z;
        }
    }
}

