/*
 * Decompiled with CFR 0.152.
 */
package com.bluepowermod.world;

import com.bluepowermod.init.BPBlocks;
import com.bluepowermod.init.Config;
import com.bluepowermod.world.WorldGenMarble;
import com.bluepowermod.world.WorldGenVolcano;
import java.util.Random;
import net.minecraft.block.Block;
import net.minecraft.init.Biomes;
import net.minecraft.init.Blocks;
import net.minecraft.util.math.BlockPos;
import net.minecraft.world.World;
import net.minecraft.world.biome.Biome;
import net.minecraft.world.chunk.IChunkProvider;
import net.minecraft.world.gen.IChunkGenerator;
import net.minecraft.world.gen.feature.WorldGenBush;
import net.minecraft.world.gen.feature.WorldGenMinable;
import net.minecraftforge.fml.common.IWorldGenerator;

public class WorldGenerationHandler
implements IWorldGenerator {
    public void generate(Random random, int chunkX, int chunkZ, World world, IChunkGenerator chunkGenerator, IChunkProvider chunkProvider) {
        int z;
        int y;
        int x;
        int i;
        if (!world.field_73011_w.func_76569_d()) {
            return;
        }
        if (Config.generateAmethyst) {
            this.addOreToGenerate(random, Config.veinCountAmethyst, Config.veinSizeAmethyst, Config.minAmethystY, Config.maxAmethystY, BPBlocks.amethyst_ore, world, chunkX, chunkZ);
        }
        if (Config.generateRuby) {
            this.addOreToGenerate(random, Config.veinCountRuby, Config.veinSizeRuby, Config.minRubyY, Config.maxRubyY, BPBlocks.ruby_ore, world, chunkX, chunkZ);
        }
        if (Config.generateSapphire) {
            this.addOreToGenerate(random, Config.veinCountSapphire, Config.veinSizeSapphire, Config.minSapphireY, Config.maxSapphireY, BPBlocks.sapphire_ore, world, chunkX, chunkZ);
        }
        if (Config.generateSilver) {
            this.addOreToGenerate(random, Config.veinCountSilver, Config.veinSizeSilver, Config.minSilverY, Config.maxSilverY, BPBlocks.silver_ore, world, chunkX, chunkZ);
        }
        if (Config.generateTeslatite) {
            this.addOreToGenerate(random, Config.veinCountTeslatite, Config.veinSizeTeslatite, Config.minTeslatiteY, Config.maxTeslatiteY, BPBlocks.teslatite_ore, world, chunkX, chunkZ);
        }
        if (Config.generateZinc) {
            this.addOreToGenerate(random, Config.veinCountZinc, Config.veinSizeZinc, Config.minZincY, Config.maxZincY, BPBlocks.zinc_ore, world, chunkX, chunkZ);
        }
        if (Config.generateCopper) {
            this.addOreToGenerate(random, Config.veinCountCopper, Config.veinSizeCopper, Config.minCopperY, Config.maxCopperY, BPBlocks.copper_ore, world, chunkX, chunkZ);
        }
        if (Config.generateTungsten) {
            this.addOreToGenerate(random, Config.veinCountTungsten, Config.veinSizeTungsten, Config.minTungstenY, Config.maxTungstenY, BPBlocks.tungsten_ore, world, chunkX, chunkZ);
        }
        Biome bgb = world.func_72959_q().func_180631_a(new BlockPos(chunkX * 16 + 16, 0, chunkZ * 16 + 16));
        int n = 0;
        if (bgb == Biomes.field_150583_P) {
            n = 1;
        } else if (bgb == Biomes.field_150582_Q) {
            n = 1;
        } else if (bgb == Biomes.field_76772_c) {
            n = 1;
        } else if (bgb == Biomes.field_76767_f) {
            n = 4;
        } else if (bgb == Biomes.field_150585_R) {
            n = 4;
        }
        for (i = 0; i < n; ++i) {
            x = chunkX * 16 + random.nextInt(16) + 8;
            y = random.nextInt(128);
            z = chunkZ * 16 + random.nextInt(16) + 8;
            new WorldGenBush(BPBlocks.indigo_flower).func_180709_b(world, random, new BlockPos(x, y, z));
        }
        if (Config.veinSizeMarble > 0) {
            for (i = 0; i < 4; ++i) {
                x = chunkX * 16 + random.nextInt(16);
                y = 32 + random.nextInt(32);
                z = chunkZ * 16 + random.nextInt(16);
                new WorldGenMarble(BPBlocks.marble, random.nextInt(Config.veinSizeMarble)).func_180709_b(world, random, new BlockPos(x, y, z));
            }
        }
        if (random.nextDouble() < Config.volcanoSpawnChance) {
            int x2 = chunkX * 16 + random.nextInt(16);
            int z2 = chunkZ * 16 + random.nextInt(16);
            y = world.func_189649_b(x2, z2) + 30 + random.nextInt(40);
            if (world.func_180495_p(new BlockPos(x2, 10, z2)).func_177230_c() == Blocks.field_150353_l && world.func_189649_b(x2, z2) <= 90) {
                new WorldGenVolcano().generate(world, random, x2, y, z2);
            }
        }
    }

    private void addOreToGenerate(Random random, int veinCount, int veinSize, int minY, int maxY, Block block, World world, int chunkX, int chunkZ) {
        for (int i = 0; i < veinCount; ++i) {
            int x = chunkX * 16 + random.nextInt(16);
            int y = random.nextInt(maxY - minY) + minY;
            int z = chunkZ * 16 + random.nextInt(16);
            new WorldGenMinable(block.func_176223_P(), veinSize).func_180709_b(world, random, new BlockPos(x, y, z));
        }
    }
}

