/*
 * Decompiled with CFR 0.152.
 */
package com.bluepowermod.container.stack;

import com.bluepowermod.api.tube.IPneumaticTube;
import com.bluepowermod.client.render.RenderHelper;
import io.netty.buffer.ByteBuf;
import net.minecraft.client.Minecraft;
import net.minecraft.client.renderer.ItemRenderer;
import net.minecraft.client.renderer.model.ItemCameraTransforms;
import net.minecraft.entity.item.ItemEntity;
import net.minecraft.item.BlockItem;
import net.minecraft.item.DyeColor;
import net.minecraft.item.ItemStack;
import net.minecraft.nbt.CompoundNBT;
import net.minecraft.tileentity.TileEntity;
import net.minecraft.util.Direction;
import net.minecraft.util.IItemProvider;
import net.minecraft.util.math.AxisAlignedBB;
import net.minecraft.util.math.BlockPos;
import net.minecraft.world.World;
import net.minecraftforge.api.distmarker.Dist;
import net.minecraftforge.api.distmarker.OnlyIn;
import org.lwjgl.opengl.GL11;

public class TubeStack {
    public ItemStack stack;
    public final IPneumaticTube.TubeColor color;
    public double progress;
    public double oldProgress;
    public Direction heading;
    public boolean enabled = true;
    public int idleCounter;
    private TileEntity target;
    private int targetX;
    private int targetY;
    private int targetZ;
    public static final double ITEM_SPEED = 0.0625;
    private double speed = 0.0625;
    public static double tickTimeMultiplier = 1.0;
    @OnlyIn(value=Dist.CLIENT)
    private static ItemRenderer customRenderItem;
    private static ItemEntity renderedItem;
    public static RenderMode renderMode;

    public TubeStack(ItemStack stack, Direction from) {
        this(stack, from, IPneumaticTube.TubeColor.NONE);
    }

    public TubeStack(ItemStack stack, Direction from, IPneumaticTube.TubeColor color) {
        this.heading = from;
        this.stack = stack;
        this.color = color;
    }

    public void setSpeed(double speed) {
        this.speed = speed;
    }

    public double getSpeed() {
        return this.speed;
    }

    public boolean update(World worldObj) {
        this.oldProgress = this.progress;
        if (this.enabled) {
            boolean isEntering = this.progress < 0.5;
            this.progress += this.speed * (worldObj.field_72995_K ? tickTimeMultiplier : 1.0);
            return this.progress >= 0.5 && isEntering;
        }
        ++this.idleCounter;
        return false;
    }

    public TileEntity getTarget(World world) {
        if (this.target == null && (this.targetX != 0 || this.targetY != 0 || this.targetZ != 0)) {
            this.target = world.func_175625_s(new BlockPos(this.targetX, this.targetY, this.targetZ));
        }
        return this.target;
    }

    public void setTarget(TileEntity tileEntity) {
        this.target = tileEntity;
        if (this.target != null) {
            this.targetX = this.target.func_174877_v().func_177958_n();
            this.targetY = this.target.func_174877_v().func_177956_o();
            this.targetZ = this.target.func_174877_v().func_177952_p();
        } else {
            this.targetX = 0;
            this.targetY = 0;
            this.targetZ = 0;
        }
    }

    public TubeStack copy() {
        CompoundNBT tag = new CompoundNBT();
        this.writeToNBT(tag);
        return TubeStack.loadFromNBT(tag);
    }

    public void writeToNBT(CompoundNBT tag) {
        this.stack.func_77955_b(tag);
        tag.func_74774_a("color", (byte)this.color.ordinal());
        tag.func_74774_a("heading", (byte)this.heading.ordinal());
        tag.func_74780_a("progress", this.progress);
        tag.func_74780_a("speed", this.speed);
        tag.func_74768_a("targetX", this.targetX);
        tag.func_74768_a("targetY", this.targetY);
        tag.func_74768_a("targetZ", this.targetZ);
    }

    public static TubeStack loadFromNBT(CompoundNBT tag) {
        TubeStack stack = new TubeStack(new ItemStack((IItemProvider)tag), Direction.func_82600_a((int)tag.func_74771_c("heading")), IPneumaticTube.TubeColor.values()[tag.func_74771_c("color")]);
        stack.progress = tag.func_74769_h("progress");
        stack.speed = tag.func_74769_h("speed");
        stack.targetX = tag.func_74762_e("targetX");
        stack.targetY = tag.func_74762_e("targetY");
        stack.targetZ = tag.func_74762_e("targetZ");
        return stack;
    }

    public void writeToPacket(ByteBuf buf) {
        buf.writeByte(this.heading.ordinal());
        buf.writeByte((int)((byte)this.color.ordinal()));
        buf.writeDouble(this.speed);
        buf.writeDouble(this.progress);
    }

    public static TubeStack loadFromPacket(ByteBuf buf) {
        TubeStack stack = new TubeStack(null, Direction.func_82600_a((int)buf.readByte()), IPneumaticTube.TubeColor.values()[buf.readByte()]);
        stack.speed = buf.readDouble();
        stack.progress = buf.readDouble();
        return stack;
    }

    @OnlyIn(value=Dist.CLIENT)
    public void render(float partialTick) {
        float size;
        if (renderMode == RenderMode.AUTO) {
            renderMode = Minecraft.func_71410_x().field_71474_y.field_74347_j ? RenderMode.NORMAL : RenderMode.REDUCED;
        }
        RenderMode finalRenderMode = renderMode;
        if (customRenderItem == null) {
            customRenderItem = Minecraft.func_71410_x().func_175599_af();
            renderedItem = new ItemEntity((World)Minecraft.func_71410_x().field_71441_e, 0.0, 0.0, 0.0);
        }
        double renderProgress = (this.oldProgress + (this.progress - this.oldProgress) * (double)partialTick) * 2.0 - 1.0;
        GL11.glPushMatrix();
        GL11.glTranslated((double)((double)this.heading.func_82601_c() * renderProgress * 0.5), (double)((double)this.heading.func_96559_d() * renderProgress * 0.5), (double)((double)this.heading.func_82599_e() * renderProgress * 0.5));
        if (finalRenderMode != RenderMode.NONE) {
            GL11.glPushMatrix();
            if (this.stack.func_190916_E() > 5) {
                GL11.glScaled((double)0.8, (double)0.8, (double)0.8);
            }
            if (!(this.stack.func_77973_b() instanceof BlockItem)) {
                GL11.glScaled((double)0.8, (double)0.8, (double)0.8);
                GL11.glTranslated((double)0.0, (double)-0.15, (double)0.0);
            }
            customRenderItem.func_181564_a(this.stack, ItemCameraTransforms.TransformType.GROUND);
            GL11.glPopMatrix();
        } else {
            size = 0.02f;
            GL11.glDisable((int)3553);
            GL11.glBegin((int)7);
            RenderHelper.drawColoredCube(new AxisAlignedBB((double)(-size), (double)(-size), (double)(-size), (double)size, (double)size, (double)size), 1.0, 1.0, 1.0, 1.0, new boolean[0]);
            GL11.glEnd();
            GL11.glEnable((int)3553);
        }
        if (this.color != IPneumaticTube.TubeColor.NONE) {
            size = 0.2f;
            int colorInt = DyeColor.values()[this.color.ordinal()].func_196059_a();
            float red = (float)(colorInt >> 16) / 256.0f;
            float green = (float)(colorInt >> 8 & 0xFF) / 256.0f;
            float blue = (float)(colorInt & 0xFF) / 256.0f;
            GL11.glDisable((int)2884);
            GL11.glDisable((int)2896);
            GL11.glColor3f((float)red, (float)green, (float)blue);
            RenderHelper.drawTesselatedTexturedCube(new AxisAlignedBB((double)(-size), (double)(-size), (double)(-size), (double)size, (double)size, (double)size));
            GL11.glEnable((int)2884);
            GL11.glEnable((int)2896);
        }
        GL11.glPopMatrix();
    }

    public static enum RenderMode {
        AUTO,
        NORMAL,
        REDUCED,
        NONE;

    }
}

