/*
 * Decompiled with CFR 0.152.
 */
package com.bluepowermod.tile.tier3;

import com.bluepowermod.api.power.BlutricityStorage;
import com.bluepowermod.api.power.CapabilityBlutricity;
import com.bluepowermod.api.power.IPowerBase;
import com.bluepowermod.block.power.BlockBlulectricCable;
import com.bluepowermod.helper.EnergyHelper;
import com.bluepowermod.tile.BPTileEntityType;
import com.bluepowermod.tile.TileMachineBase;
import java.util.ArrayList;
import javax.annotation.Nonnull;
import javax.annotation.Nullable;
import net.minecraft.block.Block;
import net.minecraft.block.BlockState;
import net.minecraft.block.Blocks;
import net.minecraft.nbt.CompoundNBT;
import net.minecraft.nbt.INBT;
import net.minecraft.network.NetworkManager;
import net.minecraft.network.play.server.SUpdateTileEntityPacket;
import net.minecraft.state.IProperty;
import net.minecraft.tileentity.TileEntity;
import net.minecraft.util.Direction;
import net.minecraftforge.common.capabilities.Capability;
import net.minecraftforge.common.util.LazyOptional;

public class TileBlulectricCable
extends TileMachineBase {
    private final BlutricityStorage storage = new BlutricityStorage(100.0, 100.0);
    private LazyOptional<IPowerBase> blutricityCap;

    public TileBlulectricCable() {
        super(BPTileEntityType.BLULECTRIC_CABLE);
    }

    @Override
    public void func_73660_a() {
        if (this.field_145850_b != null && !this.field_145850_b.field_72995_K) {
            this.storage.resetCurrent();
            BlockState state = this.field_145850_b.func_180495_p(this.field_174879_c);
            if (state.func_177230_c() instanceof BlockBlulectricCable) {
                ArrayList<Direction> directions = new ArrayList<Direction>(BlockBlulectricCable.FACING.func_177700_c());
                directions.removeIf(d -> !this.getCapability((Capability)CapabilityBlutricity.BLUTRICITY_CAPABILITY, (Direction)d).isPresent());
                for (Direction facing : directions) {
                    TileEntity tile;
                    Block fBlock = this.field_145850_b.func_180495_p(this.field_174879_c.func_177972_a(facing)).func_177230_c();
                    if (fBlock != Blocks.field_150350_a && fBlock != Blocks.field_150355_j) {
                        tile = this.field_145850_b.func_175625_s(this.field_174879_c.func_177972_a(facing));
                        if (tile == null) continue;
                        tile.getCapability(CapabilityBlutricity.BLUTRICITY_CAPABILITY, facing.func_176734_d()).ifPresent(exStorage -> EnergyHelper.balancePower(exStorage, this.storage));
                        continue;
                    }
                    tile = this.field_145850_b.func_175625_s(this.field_174879_c.func_177972_a(facing).func_177972_a(((Direction)state.func_177229_b((IProperty)BlockBlulectricCable.FACING)).func_176734_d()));
                    if (!(tile instanceof TileBlulectricCable)) continue;
                    tile.getCapability(CapabilityBlutricity.BLUTRICITY_CAPABILITY, (Direction)state.func_177229_b((IProperty)BlockBlulectricCable.FACING)).ifPresent(exStorage -> EnergyHelper.balancePower(exStorage, this.storage));
                }
            }
        }
    }

    @Nonnull
    public <T> LazyOptional<T> getCapability(@Nonnull Capability<T> cap, @Nullable Direction side) {
        BlockState state;
        ArrayList<Direction> directions = new ArrayList<Direction>(BlockBlulectricCable.FACING.func_177700_c());
        if (this.field_145850_b != null && (state = this.field_145850_b.func_180495_p(this.field_174879_c)).func_177230_c() instanceof BlockBlulectricCable) {
            directions.remove(state.func_177229_b((IProperty)BlockBlulectricCable.FACING));
            directions.removeIf(d -> this.field_145850_b.func_180495_p(this.field_174879_c.func_177972_a(d)).func_177230_c() instanceof BlockBlulectricCable && this.field_145850_b.func_180495_p(this.field_174879_c.func_177972_a(d)).func_177229_b((IProperty)BlockBlulectricCable.FACING) != state.func_177229_b((IProperty)BlockBlulectricCable.FACING));
        }
        if (cap == CapabilityBlutricity.BLUTRICITY_CAPABILITY && (side == null || directions.contains(side))) {
            if (this.blutricityCap == null) {
                this.blutricityCap = LazyOptional.of(() -> this.storage);
            }
            return this.blutricityCap.cast();
        }
        return LazyOptional.empty();
    }

    protected void invalidateCaps() {
        super.invalidateCaps();
        if (this.blutricityCap != null) {
            this.blutricityCap.invalidate();
            this.blutricityCap = null;
        }
    }

    @Override
    protected void readFromPacketNBT(CompoundNBT tCompound) {
        super.readFromPacketNBT(tCompound);
        if (tCompound.func_74764_b("energy")) {
            INBT nbtstorage = tCompound.func_74781_a("energy");
            CapabilityBlutricity.BLUTRICITY_CAPABILITY.getStorage().readNBT(CapabilityBlutricity.BLUTRICITY_CAPABILITY, (Object)this.storage, null, nbtstorage);
        }
    }

    @Override
    protected void writeToPacketNBT(CompoundNBT tCompound) {
        super.writeToPacketNBT(tCompound);
        INBT nbtstorage = CapabilityBlutricity.BLUTRICITY_CAPABILITY.getStorage().writeNBT(CapabilityBlutricity.BLUTRICITY_CAPABILITY, (Object)this.storage, null);
        tCompound.func_218657_a("energy", nbtstorage);
    }

    @Override
    @Nullable
    public SUpdateTileEntityPacket func_189518_D_() {
        return new SUpdateTileEntityPacket(this.field_174879_c, 3, this.func_189517_E_());
    }

    public CompoundNBT func_189517_E_() {
        return this.func_189515_b(new CompoundNBT());
    }

    @Override
    public void onDataPacket(NetworkManager net, SUpdateTileEntityPacket pkt) {
        super.onDataPacket(net, pkt);
        this.handleUpdateTag(pkt.func_148857_g());
    }
}

